/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChart;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLChartDBType;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class GLFrameTimeChart
extends GLChart {
    private static GLFrameTimeChart instance = null;
    private static final String MS = "ms";
    private DAChartSeries frameTimeSeries;

    public static GLFrameTimeChart getInstance() {
        if (instance == null) {
            instance = new GLFrameTimeChart();
        }
        return instance;
    }

    private GLFrameTimeChart() {
        this.chartName = GLPageLabels.GL_CHART_TITLE_FRAME_TIME;
        this.chartIcon = ImageResources.FEATURE_FRAMETIME_SMALL_NOR;
        this.frameTimeSeries = new DAChartSeries(this.chartName, 2, ColorResources.SERIES_COLOR_CPU_APP);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard, boolean enablePopupMenu) {
        DAChartBoardItem item = super.createBoardItem(chartBoard, enablePopupMenu);
        this.chart.addSeries(this.frameTimeSeries);
        this.chart.getPlot().setSeriesHeightRange(true);
        this.chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.AUTO);
        this.chart.getPlot().setAxisUnit(MS);
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.GL_MS);
        this.chart.getPlot().setShowAxis(true);
        return item;
    }

    public void updateView(double startIndex, double endIndex) {
        this.frameTimeSeries.getSeriesItemList().clear();
        List<GLChartDBType> chartDataList = GLDataManager.getInstance().getFrameTimeDBTableManager().selectFrameTime(startIndex, endIndex);
        if (chartDataList == null) {
            return;
        }
        int i = 0;
        while (i < chartDataList.size()) {
            GLChartDBType chartData = chartDataList.get(i);
            this.addData(chartData.getChartTime(), chartData.getFrameMakingTime(), chartData.isErrno());
            ++i;
        }
    }

    @Override
    public void parseLogPackage(LogPackage logPack) {
    }

    public void addData(int frameNumber, int fps, boolean isError) {
        double frameTime = 1.0 / (double)fps * 1000.0;
        String tooltipMessage = String.format("%.1f %s (%d fps)", frameTime, MS, fps);
        if (isError) {
            this.frameTimeSeries.addSeriesItem(new DAChartSeriesItem((double)frameNumber, frameTime, ColorResources.RED, tooltipMessage, false));
        } else {
            this.frameTimeSeries.addSeriesItem(new DAChartSeriesItem((double)frameNumber, frameTime, tooltipMessage, false));
        }
    }
}

