/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary;

import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.leaks.CurrentLeakData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.FreeDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.leaks.MemoryAllocationDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.leaks.NewLeakDetector;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataMaker;

public class SummaryDataManager
extends PageDataManager {
    private static SummaryDataManager instance = new SummaryDataManager();
    private LeakDataMaker leakDataMaker = null;
    private FailedApiDataMaker failedApiDataMaker = null;
    private WarningDataMaker warningDataMaker = null;
    private MemoryAllocationDataDBTable memoryAllocationDataTable = new MemoryAllocationDataDBTable();
    private FreeDataDBTable freeDataTable = new FreeDataDBTable();
    private LeakDataDBTable leakDataTable = new LeakDataDBTable();
    private FailedApiDataDBTable failedApiDataTable = new FailedApiDataDBTable();
    private WarningDataDBTable warningDataDBTable = new WarningDataDBTable();

    private SummaryDataManager() {
        this.leakDataMaker = new LeakDataMaker(this.makeInserter(this.memoryAllocationDataTable), this.makeInserter(this.freeDataTable));
        this.failedApiDataMaker = new FailedApiDataMaker(this.makeInserter(this.failedApiDataTable));
        this.warningDataMaker = new WarningDataMaker(this.warningDataDBTable);
    }

    public LeakDataMaker getLeakDataMaker() {
        return this.leakDataMaker;
    }

    public FailedApiDataMaker getFailedApiDataMaker() {
        return this.failedApiDataMaker;
    }

    public WarningDataMaker getWarningDataMaker() {
        return this.warningDataMaker;
    }

    public DBTable getMemoryAllocationDataDBTable() {
        return this.memoryAllocationDataTable;
    }

    public DBTable getFreeDataDBTable() {
        return this.freeDataTable;
    }

    public DBTable getLeakDataDBTable() {
        return this.leakDataTable;
    }

    public DBTable getFailedApiDataDBTable() {
        return this.failedApiDataTable;
    }

    public DBTable getWarningDataDBTable() {
        return this.warningDataDBTable;
    }

    public static SummaryDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.leakDataMaker.clear();
        this.failedApiDataMaker.clear();
        this.warningDataMaker.clear();
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs memoryLogs = pack.getLogs(257);
        if (memoryLogs != null && memoryLogs.getRawLogs().size() != 0) {
            List<LogData> inputs = memoryLogs.getLogs();
            this.leakDataMaker.makeData(inputs);
        }
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
        this.leakDataMaker.makeData();
        this.warningDataMaker.insertDBWhenSave();
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        List<List<Object>> leakDataList = this.leakDataMaker.getLeakDataFromDB();
        if (leakDataList == null) {
            return;
        }
        int size = leakDataList.size();
        NewLeakDetector leakDetector = AnalyzerManager.getNewLeakDetector();
        leakDetector.clear();
        int i = 0;
        while (i < size) {
            List<Object> iLeakData = leakDataList.get(i);
            long seqNum = (Long)iLeakData.get(LeakDataDBTable.COLUMN.SEQUENCE_NUMBER.index);
            long allocValue = (Long)iLeakData.get(LeakDataDBTable.COLUMN.ALLOCATED_VALUE.index);
            int pid = (Integer)iLeakData.get(LeakDataDBTable.COLUMN.PID.index);
            CurrentLeakData newLeakData = new CurrentLeakData(seqNum, allocValue, pid);
            leakDetector.addCurrentLeakData(newLeakData);
            ++i;
        }
        this.warningDataMaker.selectDBWhenOpen();
    }
}

