/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DALimit;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.leaks.CurrentLeakData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.FreeDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.leaks.MemoryAllocationDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.leaks.NewLeakDetector;
import org.tizen.dynamicanalyzer.util.Logger;

public class LeakDataMaker {
    private static final String query_withSeq = "where %s = %s";
    private static final String query_withSeqList = "where %s in (";
    private static final String query_withPidAndTime = "where %s = %s and %s >= %s and %s <= %s order by %s";
    private ArrayList<List<Object>> memoryAllocDataList;
    private ArrayList<List<Object>> freeDataList;
    private List<List<Object>> rangeDataList;
    private NewLeakDetector leakDetector = AnalyzerManager.getNewLeakDetector();
    private DBInserter allocDBInserter = null;
    private DBInserter freeDBInserter = null;

    public LeakDataMaker(DBInserter alloc_inserter, DBInserter free_inserter) {
        this.memoryAllocDataList = new ArrayList();
        this.freeDataList = new ArrayList();
        this.rangeDataList = new ArrayList<List<Object>>();
        this.allocDBInserter = alloc_inserter;
        this.freeDBInserter = free_inserter;
    }

    public void makeData(List<LogData> inputs) {
        int size = inputs.size();
        int i = 0;
        while (i < size) {
            LogData input = inputs.get(i);
            if (input != null) {
                if (this.isHeapMemoryOverflow()) break;
                switch (this.leakDetector.runLeakDetect(input)) {
                    case 0: {
                        this.makeAllocData(input);
                        break;
                    }
                    case 1: {
                        this.makeFreeData(input);
                        break;
                    }
                }
            }
            ++i;
        }
        if (this.memoryAllocDataList.size() > 0) {
            List mList = (List)this.memoryAllocDataList.clone();
            this.memoryAllocDataList.clear();
            this.allocDBInserter.pushData(mList);
        }
        if (this.freeDataList.size() > 0) {
            List fList = (List)this.freeDataList.clone();
            this.freeDataList.clear();
            this.freeDBInserter.pushData(fList);
        }
    }

    public void makeData() {
        Map<Integer, CurrentLeakData> leaks = this.leakDetector.getLeakHash();
        ArrayList<List<Object>> leakDataList = new ArrayList<List<Object>>();
        for (Map.Entry<Integer, CurrentLeakData> entry : leaks.entrySet()) {
            CurrentLeakData input = entry.getValue();
            if (input == null) continue;
            ArrayList<Number> dbLeakData = new ArrayList<Number>();
            dbLeakData.add(input.getSequenceNumber());
            dbLeakData.add(input.getAllocatedValue());
            dbLeakData.add(input.getPid());
            leakDataList.add(dbLeakData);
        }
        if (leakDataList.size() > 0) {
            SummaryDataManager.getInstance().getLeakDataDBTable().insertData(leakDataList);
        }
    }

    private boolean isHeapMemoryOverflow() {
        boolean flag = false;
        if (this.leakDetector.getLeakHash().size() > DALimit.MAX_LEAK_CHECK_BUFFER_SIZE) {
            DALimit.stopTraceAndOpenWarningDialog();
            flag = true;
        }
        return flag;
    }

    public void makeAllocData(LogData log) {
        ArrayList<Object> dbAllocData = new ArrayList<Object>();
        switch (log.getMsgID()) {
            case 257: {
                MemoryData mData = (MemoryData)log;
                dbAllocData.add(mData.getSeq());
                dbAllocData.add(mData.getPid());
                dbAllocData.add(mData.getApiId());
                dbAllocData.add(mData.getMemoryApiType());
                dbAllocData.add(mData.getAddress());
                dbAllocData.add(mData.getTime());
                dbAllocData.add(mData.getCallerPcAddr());
                dbAllocData.add(String.valueOf(mData.getArgs()));
                dbAllocData.add(String.valueOf(mData.getReturn()));
                dbAllocData.add(String.valueOf(mData.getLibName()));
                dbAllocData.add(mData.getMsgID());
                dbAllocData.add(mData.getTid());
                dbAllocData.add(mData.getSize());
                break;
            }
        }
        this.memoryAllocDataList.add(dbAllocData);
    }

    public void makeFreeData(LogData log) {
        ArrayList<Number> dbFreeData = new ArrayList<Number>();
        switch (log.getMsgID()) {
            case 257: {
                MemoryData mData = (MemoryData)log;
                dbFreeData.add(mData.getSeq());
                dbFreeData.add(mData.getPid());
                dbFreeData.add(mData.getMsgID());
                dbFreeData.add(mData.getTime());
                dbFreeData.add(mData.getAddress());
                break;
            }
        }
        this.freeDataList.add(dbFreeData);
    }

    public void clear() {
        this.memoryAllocDataList.clear();
        this.freeDataList.clear();
    }

    private List<List<Object>> executeQuery(String where) {
        DBTable table = SummaryDataManager.getInstance().getMemoryAllocationDataDBTable();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(MemoryAllocationDataDBTable.COLUMN.SEQUENCE_NUMBER.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.PID.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.API_ID.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.API_TYPE.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.ALLOCATED_ADDRESS.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.ALLOCATED_TIME.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.CALLER_PC_ADDRESS.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.ARGUMENT.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.RETURN_VALUE.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.CALLER_LIBRARY_NAME.name);
        columns.add(MemoryAllocationDataDBTable.COLUMN.MESSAGE_ID.name);
        return table.selectData(columns, where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getLong(1));
                    row.add(rs.getInt(2));
                    row.add(rs.getInt(3));
                    row.add(rs.getInt(4));
                    row.add(rs.getLong(5));
                    row.add(rs.getLong(6));
                    row.add(rs.getLong(7));
                    row.add(rs.getString(8));
                    row.add(rs.getString(9));
                    row.add(rs.getString(10));
                    row.add(rs.getInt(11));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }

    public List<List<Object>> getAllocationDataFromDB(Long seq) {
        String where = String.format(query_withSeq, MemoryAllocationDataDBTable.COLUMN.SEQUENCE_NUMBER.name, seq);
        return this.executeQuery(where);
    }

    public List<List<Object>> getLeakDataFromDB() {
        DBTable table = SummaryDataManager.getInstance().getLeakDataDBTable();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(LeakDataDBTable.COLUMN.SEQUENCE_NUMBER.name);
        columns.add(LeakDataDBTable.COLUMN.ALLOCATED_VALUE.name);
        columns.add(LeakDataDBTable.COLUMN.PID.name);
        return table.selectData(columns, null, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getLong(1));
                    row.add(rs.getLong(2));
                    row.add(rs.getInt(3));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }

    public List<List<Object>> getLeakDataWithSeq(List<Long> leakSequenceNumbers, List<String> whereQueryList) {
        StringBuilder where = new StringBuilder();
        where.append(String.format(query_withSeqList, MemoryAllocationDataDBTable.COLUMN.SEQUENCE_NUMBER.name));
        int size = leakSequenceNumbers.size();
        int i = 0;
        while (i < size - 1) {
            where.append(String.valueOf(leakSequenceNumbers.get(i)));
            where.append(",");
            where.append(" ");
            ++i;
        }
        where.append(String.valueOf(leakSequenceNumbers.get(size - 1)));
        where.append(")");
        if (whereQueryList != null && !whereQueryList.isEmpty()) {
            i = 0;
            while (i < whereQueryList.size()) {
                where.append(" and ");
                where.append(whereQueryList.get(i));
                ++i;
            }
        }
        return this.executeQuery(where.toString());
    }

    public List<List<Object>> getLeakDataForRange() {
        return this.rangeDataList;
    }

    public void clearLeakDataForRange() {
        if (!this.rangeDataList.isEmpty()) {
            this.rangeDataList.clear();
        }
    }

    public void makeLeakDataForRange(Long startTime, Long endTime, int selectedPid) {
        block6: {
            block5: {
                List<List<Object>> freeDataList;
                List<List<Object>> allocDataList;
                block7: {
                    this.clearLeakDataForRange();
                    if (selectedPid == 0) break block5;
                    allocDataList = this.getAllocationDataWithPidFromDBForRange(startTime, endTime, selectedPid);
                    freeDataList = this.getFreeDataWithPidFromDBForRange(startTime, endTime, selectedPid);
                    if (allocDataList == null) break block6;
                    if (freeDataList != null) break block7;
                    this.rangeDataList.addAll(allocDataList);
                    break block6;
                }
                List<List<Object>> result = this.makeSubLeakDataForRange(allocDataList, freeDataList);
                if (result == null || result.isEmpty()) break block6;
                this.rangeDataList.addAll(result);
                break block6;
            }
            int[] pids = Global.getProject().getProcessIDs();
            int i = 0;
            while (i < pids.length) {
                List<List<Object>> allocDataList = this.getAllocationDataWithPidFromDBForRange(startTime, endTime, pids[i]);
                List<List<Object>> freeDataList = this.getFreeDataWithPidFromDBForRange(startTime, endTime, pids[i]);
                if (allocDataList != null) {
                    if (freeDataList == null) {
                        this.rangeDataList.addAll(allocDataList);
                    } else {
                        List<List<Object>> result = this.makeSubLeakDataForRange(allocDataList, freeDataList);
                        if (result != null && !result.isEmpty()) {
                            this.rangeDataList.addAll(result);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private List<List<Object>> makeSubLeakDataForRange(List<List<Object>> allocData, List<List<Object>> freeData) {
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            long address = (Long)iFreeData.get(2);
            long freeTime = (Long)iFreeData.get(1);
            int allocDataSize = allocData.size();
            int j = 0;
            while (j < allocDataSize) {
                List<Object> iAllocData = allocData.get(j);
                long allocatedTime = (Long)iAllocData.get(MemoryAllocationDataDBTable.COLUMN.ALLOCATED_TIME.index);
                if (allocatedTime > freeTime) break;
                if (address == (Long)iAllocData.get(MemoryAllocationDataDBTable.COLUMN.ALLOCATED_ADDRESS.index)) {
                    allocData.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return allocData;
    }

    private List<List<Object>> getAllocationDataWithPidFromDBForRange(Long startTime, Long endTime, int pid) {
        String where = String.format(query_withPidAndTime, MemoryAllocationDataDBTable.COLUMN.PID.name, Integer.toString(pid), MemoryAllocationDataDBTable.COLUMN.ALLOCATED_TIME.name, startTime.toString(), MemoryAllocationDataDBTable.COLUMN.ALLOCATED_TIME.name, endTime.toString(), MemoryAllocationDataDBTable.COLUMN.ALLOCATED_TIME.name);
        return this.executeQuery(where);
    }

    private List<List<Object>> getFreeDataWithPidFromDBForRange(Long startTime, Long endTime, int pid) {
        String where = String.format(query_withPidAndTime, FreeDataDBTable.COLUMN.PID.name, Integer.toString(pid), FreeDataDBTable.COLUMN.FREE_TIME.name, startTime.toString(), FreeDataDBTable.COLUMN.FREE_TIME.name, endTime.toString(), FreeDataDBTable.COLUMN.FREE_TIME.name);
        DBTable table = SummaryDataManager.getInstance().getFreeDataDBTable();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(FreeDataDBTable.COLUMN.PID.name);
        columns.add(FreeDataDBTable.COLUMN.FREE_TIME.name);
        columns.add(FreeDataDBTable.COLUMN.ALLOCATED_ADDRESS.name);
        return table.selectData(columns, where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getInt(1));
                    row.add(rs.getLong(2));
                    row.add(rs.getLong(3));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }
}

