/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakCheckList;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakInfo;
import org.tizen.dynamicanalyzer.util.Logger;

public class LeakDetector {
    public static final int API_TYPE_OPEN = 0;
    public static final int API_TYPE_CLOSE = 1;
    public static final int API_TYPE_REALLOC = 2;
    HashMap<Long, LeakData> leakHash;
    HashMap<Long, LeakData> childHash;
    private int leakSeq = 0;

    public List<LeakData> getLeakDataList() {
        ArrayList<LeakData> leakList = new ArrayList<LeakData>();
        leakList.addAll(this.getLeakHash().values());
        return leakList;
    }

    public HashMap<Long, LeakData> getLeakHash() {
        if (this.leakHash == null) {
            this.leakHash = new HashMap();
        }
        return this.leakHash;
    }

    public HashMap<Long, LeakData> getChildHash() {
        if (this.childHash == null) {
            this.childHash = new HashMap();
        }
        return this.childHash;
    }

    private boolean isDropLog(LogData logData) {
        TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
        int id = logData.getMsgID();
        switch (id) {
            case 260: {
                if (!target.isSelectedFeature(Feature.INTERNAL_PROBE_FILE)) break;
                return true;
            }
            case 257: {
                if (!target.isSelectedFeature(Feature.INTERNAL_PROBE_MEMORY)) break;
                return true;
            }
            case 264: {
                if (!target.isSelectedFeature(Feature.INTERNAL_PROBE_THREAD)) break;
                return true;
            }
        }
        return false;
    }

    public void runLeakDectect(LogData logData) {
        ProbeCommonData log = (ProbeCommonData)logData;
        String apiName = log.getApiName();
        long errno = log.getErrno();
        if (0L != errno) {
            return;
        }
        if (this.isDropLog(logData) && log.isInternal()) {
            return;
        }
        LeakInfo chk = null;
        if (LeakCheckList.getLeakCheckList().get(apiName) == null) {
            return;
        }
        chk = LeakCheckList.getLeakCheckList().get(apiName);
        HashMap<Long, LeakData> leaks = this.getLeakHash();
        if (chk.getApiType() == 0) {
            LeakData newLeak = new LeakData(logData, this);
            leaks.put(Long.valueOf(logData.getKey()), newLeak);
        } else if (chk.getApiType() == 1) {
            int key = log.getKey();
            LeakData freeData = this.getChildHash().get(key);
            if (freeData != null) {
                LeakData parent = leaks.get(freeData.getParentKey());
                parent.removeChild(key);
                this.getChildHash().remove(key);
                if (parent.getChildren().isEmpty()) {
                    leaks.remove(parent.getKey());
                }
            } else {
                leaks.remove(key);
            }
        } else if (chk.getApiType() == 2) {
            String inputParam = log.getArgs();
            String[] splitInputParam = inputParam.split("\\,");
            String param = splitInputParam[0];
            long rmKey = -1L;
            try {
                rmKey = param.contains("0x") ? Long.decode(param) : Long.parseLong(splitInputParam[0]);
                leaks.remove(rmKey);
            }
            catch (NumberFormatException e) {
                Logger.exception((Throwable)e);
            }
            int key = log.getKey();
            leaks.put(Long.valueOf(key), new LeakData(log, this));
        }
    }

    public int getLeakSeq() {
        return this.leakSeq;
    }

    public void increaseLeakSeq() {
        ++this.leakSeq;
    }

    public void resetLeakSeq() {
        this.leakSeq = 0;
    }

    public void clear() {
        this.getLeakHash().clear();
        this.getChildHash().clear();
        this.leakSeq = 0;
    }
}

