/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.model.ColumnData;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.range.RangePage;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ColumnGroupRenderer;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfilingTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.ui.widgets.table.TreeDataComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class ProfilingTable
extends DATreeComposite {
    private boolean isRange = false;

    public ProfilingTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setComparator(new TreeDataComparator());
        this.comparator.setType(1);
        this.comparator.setColumn(0);
        this.comparator.setDirection(false);
        this.setTree(true);
        this.setSortTypes(new int[]{1, 1, 1, 1, 1, 1, 1, 1});
        this.setColumnAlignment(new int[]{16384, 131072, 16384, 131072, 131072, 16384, 131072, 131072});
        this.setColumns(this.createColumnData());
        int[] nArray = new int[8];
        nArray[0] = 260;
        int[] columnSizes = nArray;
        this.setColumnSize(columnSizes);
        this.setColumnVisibility(new boolean[]{true, true, true, true, true, true, true, true});
        this.setTableToolTipEnable(false);
        this.setTableName(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_TITLE);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, columnSizes));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = ProfilingTable.this.table.getSelection();
                String id = SummaryPage.profilingViewID;
                if (ProfilingTable.this.isRange) {
                    id = RangePage.profilingViewID;
                }
                DASelectionData selData = new DASelectionData(id, 0L, 0L, items, (Control)ProfilingTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] items = ProfilingTable.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                GridItem item = items[0];
                if (item.isExpanded()) {
                    ProfilingTable.this.setExpand(item, false);
                } else {
                    ProfilingTable.this.setExpand(item, true);
                }
                ProfilingTable.this.updateTree();
            }
        });
    }

    private List<ColumnData> createColumnData() {
        String[] tableColumnNames = new String[]{SummaryLabels.FUNCTION_USER_PROFILING_VIEW_NAME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_CPU_TIME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_CPU_RATE, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_ELAPSED_TIME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_CPU_TIME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_CPU_RATE, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_ELAPSED_TIME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_CALL_COUNT};
        int columnIndex = 0;
        ArrayList<ColumnData> columnData = new ArrayList<ColumnData>();
        ColumnData data0 = new ColumnData(tableColumnNames[columnIndex++]);
        columnData.add(data0);
        ColumnData data1 = new ColumnData(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_EXCLUSIVE);
        ColumnData data1Child1 = new ColumnData(tableColumnNames[columnIndex++]);
        ColumnData data1Child2 = new ColumnData(tableColumnNames[columnIndex++]);
        ColumnData data1Child3 = new ColumnData(tableColumnNames[columnIndex++]);
        data1.getChildren().add(data1Child1);
        data1.getChildren().add(data1Child2);
        data1.getChildren().add(data1Child3);
        columnData.add(data1);
        ColumnData data2 = new ColumnData(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_INCLUSIVE);
        ColumnData data2Child1 = new ColumnData(tableColumnNames[columnIndex++]);
        ColumnData data2Child2 = new ColumnData(tableColumnNames[columnIndex++]);
        ColumnData data2Child3 = new ColumnData(tableColumnNames[columnIndex++]);
        data2.getChildren().add(data2Child1);
        data2.getChildren().add(data2Child2);
        data2.getChildren().add(data2Child3);
        columnData.add(data2);
        ColumnData data3 = new ColumnData(tableColumnNames[columnIndex++]);
        columnData.add(data3);
        return columnData;
    }

    public void setColumns(List<ColumnData> columnData) {
        int size = columnData.size();
        int index = 0;
        int i = 0;
        while (i < size) {
            if (columnData.get(i).isParent()) {
                GridColumnGroup columnGroup = new GridColumnGroup(this.table, 0);
                columnGroup.setHeaderRenderer((GridHeaderRenderer)new ColumnGroupRenderer());
                columnGroup.setText(columnData.get(i).getText());
                List<ColumnData> children = columnData.get(i).getChildren();
                int childSize = children.size();
                int ii = 0;
                while (ii < childSize) {
                    this.createColumn(columnGroup, children.get(ii), index++);
                    ++ii;
                }
            } else {
                this.createColumn(this.table, columnData.get(i), index++);
            }
            ++i;
        }
    }

    @Override
    public List<String> getColumnsName() {
        ArrayList<String> columnsName = new ArrayList<String>();
        GridColumnGroup[] columnGroups = this.table.getColumnGroups();
        GridColumn[] columns = this.table.getColumns();
        columnsName.add(columns[0].getText());
        columnsName.add(String.valueOf(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_EXCLUSIVE_PREFIX) + columnGroups[0].getColumns()[0].getText());
        columnsName.add(String.valueOf(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_EXCLUSIVE_PREFIX) + columnGroups[0].getColumns()[1].getText());
        columnsName.add(String.valueOf(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_EXCLUSIVE_PREFIX) + columnGroups[0].getColumns()[2].getText());
        columnsName.add(String.valueOf(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_INCLUSIVE_PREFIX) + columnGroups[1].getColumns()[0].getText());
        columnsName.add(String.valueOf(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_INCLUSIVE_PREFIX) + columnGroups[1].getColumns()[1].getText());
        columnsName.add(String.valueOf(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_INCLUSIVE_PREFIX) + columnGroups[1].getColumns()[2].getText());
        columnsName.add(columns[1].getText());
        return columnsName;
    }

    @Override
    protected void applyFilterImage() {
        this.table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                GridColumnGroup[] columnGroups = ProfilingTable.this.table.getColumnGroups();
                GridColumn[] columns = ProfilingTable.this.table.getColumns();
                List<FilterProperty> filterProperties = ProfilingTable.this.getFilterPropertyList();
                int i = 0;
                while (i < filterProperties.size()) {
                    int columnIndex = filterProperties.get(i).getColumnIndex();
                    int y = 0;
                    if (columns[columnIndex].isVisible()) {
                        switch (columnIndex) {
                            case 0: 
                            case 7: {
                                y = columnGroups[0].getHeaderRenderer().getBounds().height / 2;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                y = columnGroups[0].getHeaderRenderer().getBounds().height;
                                break;
                            }
                            default: {
                                Logger.error((Object)("wrong column index - " + columnIndex));
                            }
                        }
                        gc.drawImage(filterImg, ProfilingTable.this.getFilterImagePosition(columnIndex), y);
                    }
                    ++i;
                }
            }
        });
    }

    private List<Integer> getPidsOfProfileDataMakerMap() {
        if (this.isRange) {
            return RangeDataManager.getInstance().getPidsOfProfileDataMakerMap();
        }
        return FunctionUsageProfiler.getInstance().getPidsOfProfileDataMakerMap();
    }

    private ProfileDataMaker getProfileDataMakerByPid(int pid) {
        if (this.isRange) {
            return RangeDataManager.getInstance().getProfileDataMakerByPid(pid);
        }
        return FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pid);
    }

    private void createColumn(Object parent, ColumnData data, int index) {
        GridColumn column = null;
        if (parent instanceof GridColumnGroup) {
            GridColumnGroup group = (GridColumnGroup)parent;
            column = new GridColumn(group, 0);
        } else {
            Grid table = (Grid)parent;
            column = new GridColumn(table, 0);
        }
        column.setCellRenderer((GridCellRenderer)new FunctionUsageProfilingTableCellRenderer());
        column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
        column.setText(data.getText());
        if (this.columnAlignment != null && this.columnAlignment.length > index) {
            column.setAlignment(this.columnAlignment[index]);
        }
        if (data.getWidth() == 0) {
            column.pack();
        } else {
            column.setWidth(data.getWidth());
        }
        if (this.isTree && index == 0) {
            column.setTree(true);
        }
        if (this.comparator != null && this.sortTypes != null) {
            final int type = this.sortTypes[index];
            final int columnIndex = index;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ProfilingTable.this.checkAndOpenFilterDialog(columnIndex)) {
                        return;
                    }
                    ProfilingTable.this.comparator.setType(type);
                    ProfilingTable.this.comparator.setColumn(columnIndex);
                    ProfilingTable.this.comparator.reverseDirection();
                    ProfilingTable.this.updateTree();
                }
            });
        }
    }

    private TreeInput makeInput(ProfilingData input, int pid, int inputType) {
        DATableDataFormat tableData = new DATableDataFormat(input.getProfilingDataID());
        if (input.getName().equals(FunctionUsageProfiler.APPLICATION) || input.getName().equals(FunctionUsageProfiler.DEPENDENT_LIB)) {
            tableData.setObject(String.valueOf(input.getName()) + " " + "(" + "PID : " + pid + ")");
        } else {
            tableData.setObject(input.getName());
        }
        ProfileDataMaker profiler = this.getProfileDataMakerByPid(pid);
        String exTime = "0";
        String exRate = "0.00";
        String inTime = "0";
        String inRate = "0.00";
        String callCount = "0";
        String exeTime = "0";
        String inExeTime = "0";
        try {
            exTime = profiler.getCpuTime(input, true);
            exTime = Formatter.toTimeFormat2(exTime);
            exRate = profiler.getCpuRate(input, true);
            inTime = profiler.getCpuTime(input, false);
            inTime = Formatter.toTimeFormat2(inTime);
            inRate = profiler.getCpuRate(input, false);
            callCount = input.getCallCount() == 0 ? "-" : Integer.toString(input.getCallCount());
            exeTime = 0L == input.getExclusiveElapsedTime() ? "-" : Formatter.toTimeFormat4(input.getExclusiveElapsedTime());
            inExeTime = 0L == input.getElapsedTime() ? "-" : Formatter.toTimeFormat4(input.getElapsedTime());
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
        }
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        text.add(input.getName());
        data.add(new Integer(input.getProfileDataMaker().getPid()));
        text.add(exTime);
        data.add(profiler.getCpuTime(input, true));
        text.add(String.valueOf(exRate) + " " + "%");
        data.add(profiler.getCpuTime(input, true));
        text.add(exeTime);
        data.add(new Long(input.getExclusiveElapsedTime()));
        text.add(inTime);
        data.add(profiler.getCpuTime(input, false));
        text.add(String.valueOf(inRate) + " " + "%");
        data.add(profiler.getCpuTime(input, false));
        text.add(inExeTime);
        data.add(new Long(input.getElapsedTime()));
        text.add(callCount);
        data.add(new Integer(input.getCallCount()));
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        output.setParent(input.getParent());
        return output;
    }

    public void makeChildTree(List<ProfilingData> children, TreeInput parent, String parentName, int pid, int type) {
        if (!children.isEmpty()) {
            int size = children.size();
            int i = 0;
            while (i < size) {
                ProfilingData data = children.get(i);
                TreeInput input = this.makeInput(data, pid, type);
                if (!data.getChildList().isEmpty()) {
                    this.makeChildTree(data.getChildList(), input, data.getName(), pid, type);
                }
                parent.getChildren().add(input);
                input.setParent(parentName);
                ++i;
            }
        }
    }

    public void setRangeTable(boolean isRange) {
        this.isRange = isRange;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        List<Integer> pids = this.getPidsOfProfileDataMakerMap();
        int i = 0;
        while (i < pids.size()) {
            int pid = pids.get(i);
            if (selectedPid == 0 || selectedPid == pid) {
                ProfilingData depLib;
                ProfileDataMaker profiler = this.getProfileDataMakerByPid(pid);
                ProfilingData appBin = profiler.getAppBin();
                if (appBin != null) {
                    TreeInput appBinInput = this.makeInput(appBin, pid, 1);
                    List<ProfilingData> children = appBin.getChildList();
                    this.makeChildTree(children, appBinInput, appBin.getName(), pid, 1);
                    output.add(appBinInput);
                }
                if ((depLib = profiler.getDependentLib()) != null) {
                    TreeInput depLibInput = this.makeInput(depLib, pid, 2);
                    List<ProfilingData> children = depLib.getChildList();
                    this.makeChildTree(children, depLibInput, depLib.getName(), pid, 2);
                    output.add(depLibInput);
                }
            }
            ++i;
        }
        return output;
    }
}

