/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class WebProfilingDataDBTable
extends DBTable {
    private static final String TABLENAME = "WEB_PROFILING_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public WebProfilingDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.PROFILING_DATA_ID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_LINE_NUMBER.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_NAME.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_URL.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CALL_COUNT.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.INCLUSIVE_EXECUTION_TIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.EXCLUSIVE_EXECUTION_TIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CHILD_SEQUENCE_ARRAY.name, "", "INTEGER ARRAY"));
    }

    public List<List<Object>> getWebProfilingDataFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.PROFILING_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.PROFILING_DATA_ID.index));
                prep.setInt(COLUMN.FUNCTION_LINE_NUMBER.index + 1, (Integer)rowData.get(COLUMN.FUNCTION_LINE_NUMBER.index));
                String functionStr = this.clipString((String)rowData.get(COLUMN.FUNCTION_NAME.index), 1024, rowData.get(COLUMN.PROFILING_DATA_ID.index).toString());
                prep.setString(COLUMN.FUNCTION_NAME.index + 1, functionStr);
                String functionURLStr = this.clipString((String)rowData.get(COLUMN.FUNCTION_URL.index), 1024, rowData.get(COLUMN.PROFILING_DATA_ID.index).toString());
                prep.setString(COLUMN.FUNCTION_URL.index + 1, functionURLStr);
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.CALL_COUNT.index + 1, (Integer)rowData.get(COLUMN.CALL_COUNT.index));
                prep.setLong(COLUMN.INCLUSIVE_EXECUTION_TIME.index + 1, (Long)rowData.get(COLUMN.INCLUSIVE_EXECUTION_TIME.index));
                prep.setLong(COLUMN.EXCLUSIVE_EXECUTION_TIME.index + 1, (Long)rowData.get(COLUMN.EXCLUSIVE_EXECUTION_TIME.index));
                this.setArrayToPreparedStatement(COLUMN.CHILD_SEQUENCE_ARRAY.index, "INTEGER", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getInt(2));
            row.add(rs.getString(3));
            row.add(rs.getString(4));
            row.add(rs.getInt(5));
            row.add(rs.getInt(6));
            row.add(rs.getLong(7));
            row.add(rs.getLong(8));
            row.add(this.getArrayFromResultSet(rs, 9, 0));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PROFILING_DATA_ID(0, "PROFILING_DATA_ID"),
        FUNCTION_LINE_NUMBER(1, "FUNCTION_LINE_NUMBER"),
        FUNCTION_NAME(2, "FUNCTION_NAME"),
        FUNCTION_URL(3, "FUNCTION_URL"),
        PID(4, "PID"),
        CALL_COUNT(5, "CALL_COUNT"),
        INCLUSIVE_EXECUTION_TIME(6, "INCLUSIVE_EXECUTION_TIME"),
        EXCLUSIVE_EXECUTION_TIME(7, "EXCLUSIVE_EXECUTION_TIME"),
        CHILD_SEQUENCE_ARRAY(8, "CHILD_SEQUENCE_ARRAY");

        private final int index;
        private final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

