/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class WarningDataDBTable
extends DBTable {
    private static final String TABLENAME = "WARNING_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public WarningDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.RID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MESSAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.WARNING_CASE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.WARNING_KEY.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.CALLER_PC_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_LIBRARY_NAME.name, "NOT NULL", "VARCHAR", 1024));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(COLUMN.RID.index));
                prep.setLong(2, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(3, (Integer)rowData.get(COLUMN.MESSAGE_ID.index));
                prep.setInt(4, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(5, (Integer)rowData.get(COLUMN.TID.index));
                prep.setLong(6, (Long)rowData.get(COLUMN.START_TIME.index));
                prep.setLong(7, (Long)rowData.get(COLUMN.END_TIME.index));
                prep.setInt(8, (Integer)rowData.get(COLUMN.WARNING_CASE.index));
                prep.setString(9, (String)rowData.get(COLUMN.WARNING_KEY.index));
                prep.setLong(10, (Long)rowData.get(COLUMN.CALLER_PC_ADDRESS.index));
                prep.setString(11, (String)rowData.get(COLUMN.CALLER_LIBRARY_NAME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        RID(0, "RID"),
        SEQUENCE_NUMBER(1, "SEQUENCE_NUMBER"),
        MESSAGE_ID(2, "MESSAGE_ID"),
        PID(3, "PID"),
        TID(4, "TID"),
        START_TIME(5, "START_TIME"),
        END_TIME(6, "END_TIME"),
        WARNING_CASE(7, "WARNING_CASE"),
        WARNING_KEY(8, "WARNING_KEY"),
        CALLER_PC_ADDRESS(9, "CALLER_PC_ADDRESS"),
        CALLER_LIBRARY_NAME(10, "CALLER_LIBRARY_NAME");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

