/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.TargetProcessDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ProcessesChartRenderer;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardHeightChangeableItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;

public class CPUChart
extends TimelineChart {
    private DAChartSeries appLoadSeries;
    private DAChartSeries totalLoadSeries;
    private DAChartBoard chartBoard = null;
    private DAChartBoardItem item = null;
    private DAChartBoardHeightChangeableItem processItem = null;
    private Map<Integer, DAChartSeries> childSeriesMap;

    public CPUChart(String pageID) {
        super(pageID);
        this.chartType = -101;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.CPU_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.CPU_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_CPU_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_CPU_SMALL_NOR;
        this.totalLoadSeries = new DAChartSeries(TimelineChartLabels.CPU_CHART_SERIES_NAME_TOTAL_LOAD, 3, ColorResources.CHART_SERIES_EMERALD);
        this.appLoadSeries = new DAChartSeries(TimelineChartLabels.CPU_CHART_SERIES_NAME_APP_LOAD, 3, ColorResources.CHART_SERIES_BLUE);
        this.childSeriesMap = new HashMap<Integer, DAChartSeries>();
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        this.chartBoard = board;
        this.item = super.createBoardItem(board);
        this.chart.addSeries(this.totalLoadSeries);
        this.chart.addSeries(this.appLoadSeries);
        this.chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        this.chart.getPlot().setAxisRangeY(0.0, 100.0);
        this.chart.getPlot().setAxisUnit("%");
        this.chart.getPlot().setShowAxis(true);
        return this.item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.appLoadSeries.clear();
        this.totalLoadSeries.clear();
        if (Global.getProject() == null) {
            return;
        }
        int coreSize = Global.getProject().getDeviceStatusInfo().getCpuCount();
        Collection<DAChartSeries> processSeries = this.childSeriesMap.values();
        if (processSeries != null) {
            Iterator<DAChartSeries> iter = processSeries.iterator();
            while (iter.hasNext()) {
                iter.next().clear();
            }
        }
        List systemData = (List)dataList.get(0);
        Map targetProcessDataMap = (Map)dataList.get(1);
        if (this.processItem == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (CPUChart.this.processItem != null) {
                        return;
                    }
                    CPUChart.this.processItem = new DAChartBoardHeightChangeableItem(CPUChart.this.item, "Processes");
                    CPUChart.this.processItem.useExpand(false);
                    DAChart processesChart = CPUChart.this.processItem.getChart();
                    processesChart.setChartRenderer((DAChartRenderer)new ProcessesChartRenderer());
                    DAChartPlot processChartPlot = processesChart.getPlot();
                    DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
                    processChartPlot.setBackgroundImage(ImageResources.BG_GRADIENT);
                    tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
                    processChartPlot.setTooltip(tooltip);
                    processChartPlot.setAxisFont(FontResources.CHART_AXIS_FONT);
                    processChartPlot.setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
                    processChartPlot.setAxisRangeY(0.0, 100.0);
                    processChartPlot.setAxisUnit("%");
                    processChartPlot.setShowAxis(true);
                    processChartPlot.setMarkers(CPUChart.this.chartBoard.getMarkers());
                    DAPopupMenu processChartPopupMenu = new DAPopupMenu((Composite)processesChart);
                    CPUChart.this.initPopupMenu(CPUChart.this.chartBoard, processChartPopupMenu);
                    TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(processChartPopupMenu, CPUChart.this.chartBoard.getTimeline(), CPUChart.this.pageID);
                    processesChart.addMouseListener((MouseListener)timelineChartMouseEventListener);
                    processesChart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
                    processesChart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(CPUChart.this.chartBoard.getTimeline()));
                }
            });
        }
        int prevChildSize = this.childSeriesMap.size();
        int i = 0;
        while (i < systemData.size()) {
            List row = (List)systemData.get(i);
            double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            try {
                double systemAvgLoad = ((Float)row.get(SystemDataDBTable.COLUMN.CPU_LOAD_TOTAL.ordinal())).floatValue();
                this.totalLoadSeries.addSeriesItem(new DAChartSeriesItem(time, systemAvgLoad, Formatter.toPercentageFormat(systemAvgLoad)));
                List otherPIDList = (List)row.get(SystemDataDBTable.COLUMN.PROCESS_PID_OTHER.ordinal());
                List otherProcessCpuLoadList = (List)row.get(SystemDataDBTable.COLUMN.PROCESS_LOAD_OTHER.ordinal());
                int ii = 0;
                while (ii < otherPIDList.size()) {
                    int pid = (Integer)otherPIDList.get(ii);
                    double load = (Double)otherProcessCpuLoadList.get(ii) / (double)coreSize;
                    DAChartSeries series = this.childSeriesMap.get(pid);
                    if (series == null) {
                        if (load != 0.0) {
                            DAChartSeries newSeries = new DAChartSeries(Integer.toString(pid), 0, ColorResources.SERIES_COLOR_CPU_SYSTEM);
                            newSeries.addSeriesItem(new DAChartSeriesItem(time, load, Formatter.toPercentageFormat(load)));
                            if (this.processItem != null) {
                                this.processItem.getChart().addSeries(newSeries);
                                this.childSeriesMap.put(pid, newSeries);
                            }
                        }
                    } else {
                        series.addSeriesItem(new DAChartSeriesItem(time, load, Formatter.toPercentageFormat(load)));
                    }
                    ++ii;
                }
            }
            catch (NumberFormatException ne) {
                Logger.exception((Throwable)ne);
            }
            ++i;
        }
        Iterator iter = targetProcessDataMap.keySet().iterator();
        HashMap<Long, Float> processLoadSumMap = new HashMap<Long, Float>();
        while (iter.hasNext()) {
            Integer pid = (Integer)iter.next();
            List data = (List)targetProcessDataMap.get(pid);
            int i2 = 0;
            while (i2 < data.size()) {
                List oneTime = (List)data.get(i2);
                Long time = (Long)oneTime.get(TargetProcessDBTable.COLUMN.SAMPLING_TIME.ordinal());
                Float cpuLoad = (Float)oneTime.get(TargetProcessDBTable.COLUMN.CPU_LOAD.ordinal());
                Float processLoadSum = (Float)processLoadSumMap.get(time);
                if (processLoadSum == null) {
                    processLoadSumMap.put(time, cpuLoad);
                } else {
                    processLoadSumMap.put(time, Float.valueOf(processLoadSum.floatValue() + cpuLoad.floatValue()));
                }
                ++i2;
            }
        }
        ArrayList timeSortedLoadList = new ArrayList(processLoadSumMap.keySet());
        Collections.sort(timeSortedLoadList);
        for (Long time : timeSortedLoadList) {
            Float cpuLoadSum = (Float)processLoadSumMap.get(time);
            this.appLoadSeries.addSeriesItem(new DAChartSeriesItem((double)time.longValue() / 1000000.0, cpuLoadSum.doubleValue(), Formatter.toPercentageFormat(cpuLoadSum.doubleValue())));
        }
        if (prevChildSize != this.childSeriesMap.size()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int size = CPUChart.this.childSeriesMap.size();
                    if (size > 1) {
                        CPUChart.this.processItem.getChart().getPlot().setShowAxis(false);
                    }
                    if (size > 3) {
                        CPUChart.this.processItem.setHeightRatio((double)size / 3.0);
                    }
                }
            });
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.processItem = null;
        this.childSeriesMap.clear();
    }

    public DAChartBoardHeightChangeableItem getProcessChart() {
        return this.processItem;
    }
}

