/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.annotation.UIMethod;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.ReplayManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.common.explorer.DeviceExplorerDialog;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.toolbar.AboutDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ProcessExplorerDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.RemoteDeviceDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.SaveAsDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.OpenTraceDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.PreferencesDialog;
import org.tizen.dynamicanalyzer.ui.widgets.SearchDialog;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressDialog;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;
import org.tizen.dynamicanalyzer.widgets.timer.IAlarm;
import org.tizen.dynamicanalyzer.widgets.timer.TimerClock;
import org.tizen.dynamicanalyzer.workbench.LayoutManager;
import org.tizen.sdblib.service.FileEntry;

public enum Toolbar {
    INSTANCE;

    public static final int START_BUTTON = 0;
    public static final int SAVE_BUTTON = 1;
    public static final int OPEN_BUTTON = 2;
    public static final int REPLAY_BUTTON = 3;
    public static final int SOURCE_BUTTON = 4;
    public static final int ABOUT_BUTTON = 5;
    public static final int CONFIG_BUTTON = 6;
    public static final int SETTING_BUTTON = 7;
    public static final int SCREENSHOT_BUTTON = 8;
    public static final int REPLAY_EDIT_BUTTON = 9;
    public static final int SEARCH_BUTTON = 10;
    public static final String ALL_PROCESS = "All Processes";
    public static final String PROCESS_SPLITER = " : ";
    private DAToolBarCustomCombo deviceCombo;
    private DAToolBarCustomCombo appCombo;
    private DACustomCombo processCombo;
    private DACustomButton startButton;
    private TimerClock timerClock;
    private DACustomButton saveTraceButton;
    private DACustomButton openTraceButton;
    private DACustomButton replayButton;
    private DACustomButton replayEditButton;
    private DACustomButton configButton;
    private DACustomButton screenshotButton;
    private DACustomButton aboutButton;
    private DACustomButton searchButton;
    private DACustomToggleButton viewSourceButton;
    private List<PackageInfo> oldPkgList = null;
    private List<PackageInfo> newPkgList = null;
    private Map<Integer, DACustomButton> buttons = new HashMap<Integer, DACustomButton>();
    private ProgressDialog progressDlg = null;
    private static final int TIMER_WIDTH = 118;
    private static final int DEVICE_COMBO = 0;
    private static final int APP_COMBO = 1;
    private long chartDragStart = -1L;
    private long chartDragEnd = -1L;
    private boolean dlogTimeSelection = true;
    private int scaleSelection = 2;

    public DACustomButton getStartButton() {
        return this.startButton;
    }

    public int getScaleSelection() {
        return this.scaleSelection;
    }

    public void setScaleSelection(int scale) {
        this.scaleSelection = scale;
    }

    public void create(Composite parent) {
        parent.setBackground(ColorResources.GRAY_220);
        this.createToolbar(parent);
        parent.layout(true);
    }

    public DACustomCombo getProcessCombo() {
        return this.processCombo;
    }

    public DAToolBarCustomCombo getDeviceCombo() {
        return this.deviceCombo;
    }

    public DAToolBarCustomCombo getAppCombo() {
        return this.appCombo;
    }

    private void addToolbarListeners() {
        this.deviceCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                String newDeviceName;
                String oldDeviceName = "";
                DeviceInfo oldDevInfo = Global.getCurrentDeviceInfo();
                if (oldDevInfo != null) {
                    oldDeviceName = oldDevInfo.getIDevice().getSerialNumber();
                }
                if ((newDeviceName = combo.getText()) == null || newDeviceName.isEmpty()) {
                    DeviceManager.onDeviceSelected(newDeviceName);
                    Toolbar.this.deviceCombo.setTextForce("Select Target");
                    if (DAState.isStartable()) {
                        CommonAction.configure();
                    }
                    Toolbar.this.updateAppCombo(true);
                    return;
                }
                if (newDeviceName.equals("[Remote Device]")) {
                    final String oldDevname = oldDeviceName;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                            RemoteDeviceDialog pdialog = new RemoteDeviceDialog(shell);
                            pdialog.open();
                            String newDevice = pdialog.getAddress();
                            if (newDevice == null || newDevice.isEmpty()) {
                                if (oldDevname == "" || !DeviceManager.isDeviceConnected()) {
                                    Toolbar.this.ShowDeviceComboTitle();
                                } else {
                                    Toolbar.this.selectDeviceCombo(oldDevname);
                                }
                            } else if (!Toolbar.this.updateDeviceCombo(newDevice)) {
                                Toolbar.this.updateAppCombo(true);
                            }
                        }
                    });
                } else if (DeviceManager.onDeviceSelected(newDeviceName)) {
                    if (DAState.isStartable()) {
                        CommonAction.configure();
                    }
                    Toolbar.this.updateAppCombo(true);
                } else if (!Toolbar.this.updateDeviceCombo(oldDeviceName)) {
                    Toolbar.this.updateAppCombo(true);
                }
            }
        });
        this.appCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                String appName = combo.getText();
                if (appName == null || appName.isEmpty()) {
                    Global.setCurrentApplication(null);
                    return;
                }
                DeviceInfo curDev = Global.getCurrentDeviceInfo();
                if (curDev != null) {
                    PackageInfo selectedPkg = curDev.getPkgInfoByLabel(appName);
                    if (selectedPkg != null) {
                        if (appName.equals("[Running process]")) {
                            if (curDev.isRootAvailable()) {
                                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                                ProcessExplorerDialog pdialog = new ProcessExplorerDialog(shell);
                                pdialog.setProcessList(selectedPkg.getMainApp().getRunningProcesses());
                                Object result = pdialog.open();
                                if (result != null) {
                                    Map processes = (Map)result;
                                    selectedPkg.getMainApp().setRunningProcesses(processes);
                                    selectedPkg.setPossibleToTrace(true);
                                }
                            } else {
                                UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                                selectedPkg.setPossibleToTrace(false);
                            }
                        } else if (appName.equals("[Common executable]")) {
                            if (curDev.isRootAvailable()) {
                                List files;
                                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                                DeviceExplorerDialog dialog = new DeviceExplorerDialog(shell, false);
                                dialog.setPermissionFilter("111");
                                Object result = dialog.open();
                                if (result != null && (files = (List)result).size() > 0) {
                                    String execpath = ((FileEntry)files.get(0)).getFullPath();
                                    selectedPkg.getMainApp().setInfo(AppInfo.PROPERTY.EXEC.index, execpath);
                                    selectedPkg.setPossibleToTrace(true);
                                }
                            } else {
                                UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                                selectedPkg.setPossibleToTrace(false);
                            }
                        } else if (appName.equals("[Without executable]") && !curDev.isRootAvailable()) {
                            UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                            selectedPkg.setPossibleToTrace(false);
                        }
                        Global.setCurrentApplication(selectedPkg);
                        Toolbar.this.onAppSelected(selectedPkg);
                        curDev.setSelectedPackageLabel(selectedPkg.getMainApp().getLabel());
                    } else {
                        Toolbar.this.updateAppCombo(false);
                    }
                } else {
                    Toolbar.this.updateAppCombo(false);
                }
                Toolbar.this.setStartButtonState(true);
                Toolbar.this.setReplayButtonState(true);
            }
        });
        this.appCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!Toolbar.this.appCombo.isChildShellOpened()) {
                    Toolbar.this.updateAppCombo(false);
                }
            }
        });
        this.processCombo.addSelectionListener(new DACustomComboSelectionListener(){

            public void selectionEvent(DACustomCombo combo) {
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        this.processCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                Toolbar.this.processCombo.initCombo();
                Toolbar.this.processCombo.add(Toolbar.ALL_PROCESS);
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(Toolbar.PROCESS_SPLITER);
                    buffer.append(binName);
                    Toolbar.this.processCombo.add(buffer.toString());
                    ++i;
                }
            }
        });
        this.startButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                if (!SettingDataManager.INSTANCE.checkConnectedTargetType()) {
                    UIActionHolder.getUIAction().showWarning(button.getShell(), String.valueOf(DAResult.ErrorCode.ERR_DEVICE_TARGET_MISMATCH.getErrorMessage()) + "\nDevice type: " + SettingDataManager.INSTANCE.getConnectedTargetOrNull().getTargetName() + "\nSelected target: " + SettingDataManager.INSTANCE.getSelectedTarget());
                    Logger.info((Object)DAResult.ErrorCode.ERR_DEVICE_TARGET_MISMATCH.getErrorMessage());
                    return;
                }
                if (DAState.isStartable()) {
                    MarkerManager.INSTANCE.clearMarkerList();
                    CommandAction.startTrace(false);
                } else if (DAState.isRunning()) {
                    CommandAction.stopTrace(new DAResult(DAResult.ErrorCode.SUCCESS), false);
                } else {
                    Logger.error((Object)"Wrong action for start button");
                }
            }
        });
        this.saveTraceButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                SaveAsDialog dialog = new SaveAsDialog(shell);
                Object result = dialog.open();
                if (result != null) {
                    if (!CommandAction.save(dialog.getSaveFileName())) {
                        UIActionHolder.getUIAction().showWarning(AnalyzerLabels.SAVE_FAILED);
                    }
                    button.setButtonEnabled(false);
                }
            }
        });
        this.openTraceButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                OpenTraceDialog dialog = new OpenTraceDialog(shell);
                Object result = dialog.open();
                if (result != null) {
                    Toolbar.this.processCombo.setVisible(true);
                }
            }
        });
        this.replayButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                if (DAState.isStartable() && ReplayManager.init()) {
                    CommandAction.startTrace(false);
                }
            }
        });
        this.replayEditButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                ReplayEditDialog dialog = new ReplayEditDialog(shell);
                dialog.open();
            }
        });
        this.configButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                PreferencesDialog preferenceDialog = new PreferencesDialog(shell);
                preferenceDialog.open();
            }
        });
        this.screenshotButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                AnalyzerUtil.captureScreenshot();
            }
        });
        this.aboutButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                AboutDialog dialog = new AboutDialog(shell);
                dialog.open();
            }
        });
        this.searchButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                Composite comp = baseView.getTopPage().getTopTable();
                SearchDialog dialog = new SearchDialog(shell, comp);
                dialog.open();
            }
        });
        this.viewSourceButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
            }
        });
    }

    private void createToolbar(Composite parent) {
        this.startButton = new DACustomButton(parent, ImageResources.START, ImageResources.START_PUSH, ImageResources.START_HOVER, ImageResources.START_DISABLE);
        this.setStartButtonState(false);
        this.startButton.setToolTipText(ShortCutManager.START_TRACE);
        this.buttons.put(0, this.startButton);
        this.timerClock = new TimerClock(parent, 0);
        this.timerClock.setBgImage(ImageResources.TIMER);
        this.timerClock.setClockFont(FontResources.TIMER);
        this.timerClock.setFontColor(ColorResources.POINT);
        this.saveTraceButton = new DACustomButton(parent, ImageResources.SAVE, ImageResources.SAVE_PUSH, ImageResources.SAVE_HOVER, ImageResources.SAVE_DISABLE);
        this.saveTraceButton.setButtonEnabled(false);
        this.saveTraceButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.saveTraceButton.setToolTipText(ShortCutManager.SAVE_TRACE);
        this.buttons.put(1, this.saveTraceButton);
        this.openTraceButton = new DACustomButton(parent, ImageResources.OPEN, ImageResources.OPEN_PUSH, ImageResources.OPEN_HOVER, ImageResources.OPEN_DISABLE);
        this.openTraceButton.setToolTipText(ShortCutManager.OPEN_TRACE);
        this.openTraceButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.buttons.put(2, this.openTraceButton);
        this.replayButton = new DACustomButton(parent, ImageResources.REPLAY, ImageResources.REPLAY_PUSH, ImageResources.REPLAY_HOVER, ImageResources.REPLAY_DISABLE);
        this.replayButton.setToolTipText(ShortCutManager.REPLAY);
        this.replayButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.buttons.put(3, this.replayButton);
        this.replayEditButton = new DACustomButton(parent, ImageResources.REPLAY_EDIT, ImageResources.REPLAY_EDIT_PUSH, ImageResources.REPLAY_EDIT_HOVER, ImageResources.REPLAY_EDIT_DISABLE);
        this.replayEditButton.setToolTipText(ShortCutManager.REPLAY_EDIT);
        this.replayEditButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.buttons.put(9, this.replayEditButton);
        this.configButton = new DACustomButton(parent, ImageResources.DA_PREFERENCES_ICON_NOR, ImageResources.DA_PREFERENCES_ICON_SEL, ImageResources.DA_PREFERENCES_ICON_OVER, ImageResources.DA_PREFERENCES_ICON_DIM);
        this.configButton.setToolTipText(ShortCutManager.COOLBAR_AREA_SETTING);
        this.configButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(6, this.configButton);
        this.screenshotButton = new DACustomButton(parent, ImageResources.DA_SCREENSHOT_ICON_NOR, ImageResources.DA_SCREENSHOT_ICON_FOC, ImageResources.DA_SCREENSHOT_ICON_OVER, ImageResources.DA_SCREENSHOT_ICON_DIM);
        this.screenshotButton.setToolTipText("Capture screen");
        this.screenshotButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(8, this.screenshotButton);
        this.aboutButton = new DACustomButton(parent, ImageResources.DA_INFO_ICON_NOR, ImageResources.DA_INFO_ICON_SEL, ImageResources.DA_INFO_ICON_OVER, ImageResources.DA_INFO_ICON_DIM);
        this.aboutButton.setToolTipText(ShortCutManager.COOLBAR_AREA_ABOUT);
        this.aboutButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(5, this.aboutButton);
        this.searchButton = new DACustomButton(parent, ImageResources.SEARCH, ImageResources.SEARCH_PUSH, ImageResources.SEARCH_HOVER, ImageResources.SEARCH_DISABLE);
        this.searchButton.setToolTipText(ShortCutManager.COOLBAR_AREA_SEARCH);
        this.searchButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(10, this.searchButton);
        this.viewSourceButton = new DACustomToggleButton(parent, ImageResources.VIEW_SOURCE_NORMAL, ImageResources.VIEW_SOURCE_PUSH, ImageResources.VIEW_SOURCE_HOVER, ImageResources.VIEW_SOURCE_DISABLE, ImageResources.VIEW_SOURCE_TOGGLE, ImageResources.VIEW_SOURCE_TOGGLE_HOVER, ImageResources.VIEW_SOURCE_DISABLE, ImageResources.VIEW_SOURCE_TOGGLE_PUSH);
        this.viewSourceButton.setToolTipText(ShortCutManager.COOLBAR_AREA_VIEW_SOURCE);
        this.viewSourceButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.buttons.put(4, (DACustomButton)this.viewSourceButton);
        this.saveTraceButton.setVisible(false);
        this.openTraceButton.setVisible(false);
        this.replayButton.setVisible(false);
        this.replayEditButton.setVisible(false);
        this.viewSourceButton.setVisible(false);
        FormData data = new FormData();
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.startButton, 0);
        data.width = 118;
        data.height = 24;
        this.timerClock.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.timerClock, 4, 131072);
        data.width = 27;
        data.height = 30;
        this.saveTraceButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.saveTraceButton, 0, 131072);
        data.width = 27;
        data.height = 30;
        this.openTraceButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.openTraceButton, 0, 131072);
        data.width = 33;
        data.height = 30;
        this.replayButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.replayButton, 0, 131072);
        data.width = 0;
        data.height = 30;
        this.replayEditButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment(100, -20);
        data.width = 24;
        data.height = 24;
        this.aboutButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.aboutButton, -17);
        data.width = 24;
        data.height = 24;
        this.configButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.configButton, -17);
        data.width = 24;
        data.height = 24;
        this.screenshotButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.screenshotButton, -17);
        data.width = 24;
        data.height = 24;
        this.searchButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.searchButton, -5);
        data.width = 27;
        data.height = 30;
        this.viewSourceButton.setLayoutData((Object)data);
        this.deviceCombo = this.makeDAToolBarCustomCombo(parent, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 20);
        data.width = 168;
        data.height = 24;
        this.deviceCombo.setLayoutData(data);
        Label bracketLabel = new Label(parent, 0x41000000);
        bracketLabel.setImage(ImageResources.BIG_RIGHT_ARROW);
        bracketLabel.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.deviceCombo, 0, 131072);
        data.width = 13;
        data.height = 24;
        bracketLabel.setLayoutData((Object)data);
        this.appCombo = this.makeDAToolBarCustomCombo(parent, 1);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)bracketLabel, 0, 131072);
        data.width = 168;
        data.height = 24;
        this.appCombo.setLayoutData(data);
        this.processCombo = this.makeDACustomCombo(parent);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.replayEditButton, 15);
        data.width = 168;
        data.height = 24;
        this.processCombo.setLayoutData((Object)data);
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.appCombo, 8, 131072);
        data.width = 60;
        data.height = 24;
        this.startButton.setLayoutData((Object)data);
        this.initDeviceCombo();
        this.initProcessCombo();
        this.addToolbarListeners();
    }

    private DACustomCombo makeDACustomCombo(Composite parent) {
        DACustomCombo returnCombo = new DACustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.POINT, ColorResources.POINT, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_130, ColorResources.WHITE, ColorResources.GRAY_130, ColorResources.GRAY_130);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(130, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        return returnCombo;
    }

    private DAToolBarCustomCombo makeDAToolBarCustomCombo(Composite parent, int whatcombo) {
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_130, ColorResources.WHITE, ColorResources.GRAY_130, ColorResources.GRAY_130);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(130, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setDeviceCombo(whatcombo);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        return returnCombo;
    }

    @UIMethod
    private void initDeviceCombo() {
        this.deviceCombo.initCombo();
        this.deviceCombo.setTextForce("Select Target");
        this.deviceCombo.add("[Remote Device]");
        this.deviceCombo.select(0);
    }

    @UIMethod
    private boolean selectDeviceCombo(String deviceName) {
        boolean bret = false;
        List<String> devicelist = this.deviceCombo.getItems();
        int size = devicelist.size();
        int i = 0;
        while (i < size) {
            if (devicelist.get(i).equals(deviceName) && (bret = DeviceManager.onDeviceSelected(deviceName))) {
                this.deviceCombo.select(i);
                if (!deviceName.isEmpty()) {
                    this.deviceCombo.setToolTipText(deviceName);
                }
            }
            ++i;
        }
        return bret;
    }

    @UIMethod
    public boolean setDevice(String text) {
        if (this.selectDeviceCombo(text)) {
            this.updateAppCombo(true);
            return true;
        }
        if (!this.updateDeviceCombo(null)) {
            this.updateAppCombo(true);
        }
        return false;
    }

    @UIMethod
    public boolean updateDeviceCombo(String newSelectedDevice) {
        String oldSelectedDevice = "";
        DeviceInfo oldDev = Global.getCurrentDeviceInfo();
        if (oldDev != null) {
            oldSelectedDevice = oldDev.getIDevice().getSerialNumber();
        }
        if (newSelectedDevice == null) {
            newSelectedDevice = oldSelectedDevice;
            this.ShowDeviceComboTitle();
        }
        this.setAllControlState(false);
        List<DeviceInfo> devices = DeviceManager.getDevices();
        this.deviceCombo.initCombo();
        if (!devices.isEmpty()) {
            int numofdev = devices.size();
            int i = 0;
            while (i < numofdev) {
                this.deviceCombo.add(devices.get(i).getIDevice().getSerialNumber());
                ++i;
            }
        } else {
            this.deviceCombo.add("");
            this.ShowDeviceComboTitle();
        }
        this.deviceCombo.add("[Remote Device]");
        if (!this.selectDeviceCombo(newSelectedDevice)) {
            this.ShowDeviceComboTitle();
        }
        this.changeUIState(DAState.getCurrentState());
        String selectedFinally = this.deviceCombo.getText();
        if (selectedFinally == null) {
            return oldSelectedDevice == null || oldSelectedDevice.isEmpty();
        }
        this.ShowDeviceComboTitle();
        return selectedFinally.equals(oldSelectedDevice);
    }

    private List<PackageInfo> getAppListFromTarget() {
        Map<String, PackageInfo> pkgInfos = DACommunicator.updateAppListFromTarget();
        if (pkgInfos == null) {
            return null;
        }
        ArrayList<PackageInfo> pkgList = new ArrayList<PackageInfo>();
        for (Map.Entry<String, PackageInfo> entry : pkgInfos.entrySet()) {
            PackageInfo pkg = entry.getValue();
            AppInfo mainapp = pkg.getMainApp();
            if (mainapp == null || ApplistManager.isInBlackList(mainapp)) continue;
            String label = mainapp.getLabel();
            if (label.isEmpty()) {
                label = mainapp.getExecFileName();
                mainapp.setInfo(AppInfo.PROPERTY.LABEL.index, label);
            }
            pkgList.add(pkg);
        }
        Collections.sort(pkgList, new Comparator<PackageInfo>(){

            @Override
            public int compare(PackageInfo pkg1, PackageInfo pkg2) {
                int len2;
                AppInfo app1 = pkg1.getMainApp();
                AppInfo app2 = pkg2.getMainApp();
                String o1 = app1.getLabel();
                String o2 = app2.getLabel();
                if (o1.startsWith("[") && !o2.startsWith("[")) {
                    return 1;
                }
                if (!o1.startsWith("[") && o2.startsWith("[")) {
                    return -1;
                }
                String exe1 = app1.getExecPath();
                String exe2 = app2.getExecPath();
                if (exe1.startsWith("/opt/apps") || exe1.startsWith("/opt/usr/apps")) {
                    if (exe2.startsWith("/opt/apps") || exe2.startsWith("/opt/usr/apps")) {
                        long time2;
                        long time1 = pkg1.getInstallTime();
                        if (time1 < (time2 = pkg2.getInstallTime())) {
                            return 1;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (exe2.startsWith("/opt/apps") || exe2.startsWith("/opt/usr/apps")) {
                    return 1;
                }
                int len1 = o1.length();
                int len = len1 > (len2 = o2.length()) ? len2 : len1;
                int i = 0;
                while (i < len) {
                    if (o1.charAt(i) > o2.charAt(i)) {
                        return 1;
                    }
                    if (o1.charAt(i) < o2.charAt(i)) {
                        return -1;
                    }
                    ++i;
                }
                if (len1 > len2) {
                    return 1;
                }
                if (len1 < len2) {
                    return -1;
                }
                return 0;
            }
        });
        return pkgList;
    }

    private void redrawAppcombo() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.appCombo.redraw();
            }
        });
    }

    @UIMethod
    private void composeAppCombo(List<PackageInfo> pkglist) {
        this.appCombo.initCombo();
        if (pkglist != null && !pkglist.isEmpty()) {
            int itemsSize = pkglist.size();
            this.appCombo.add("===[App List]===");
            int i = 0;
            while (i < itemsSize) {
                String appLabel = pkglist.get(i).getMainApp().getLabel();
                this.appCombo.add(appLabel);
                ++i;
            }
        } else {
            this.ShowAppComboTitle();
        }
        this.redrawAppcombo();
    }

    @UIMethod
    private boolean selectAppCombo(int index) {
        boolean bret = false;
        List<String> pkglist = this.appCombo.getItems();
        if (index < pkglist.size()) {
            String appLabel = pkglist.get(index);
            if (appLabel.isEmpty()) {
                this.appCombo.select(index);
                Global.setCurrentApplication(null);
                DeviceInfo curDev = Global.getCurrentDeviceInfo();
                if (curDev != null) {
                    this.onAppSelected(null);
                    curDev.setSelectedPackageLabel(null);
                }
                bret = true;
            } else {
                PackageInfo pkginfo;
                DeviceInfo curDev = Global.getCurrentDeviceInfo();
                if (curDev != null && (pkginfo = curDev.getPkgInfoByLabel(appLabel)) != null) {
                    this.appCombo.select(index);
                    Global.setCurrentApplication(pkginfo);
                    this.onAppSelected(pkginfo);
                    curDev.setSelectedPackageLabel(appLabel);
                    bret = true;
                }
            }
        }
        return bret;
    }

    @UIMethod
    private boolean selectAppCombo(String appLabel) {
        boolean bret = false;
        List<String> pkglist = this.appCombo.getItems();
        int size = pkglist.size();
        int i = 0;
        while (i < size) {
            String pkgname = pkglist.get(i);
            if (pkgname.equals(appLabel)) {
                DeviceInfo curDev;
                if (pkglist.get(i).isEmpty()) {
                    this.appCombo.select(i);
                    Global.setCurrentApplication(null);
                    curDev = Global.getCurrentDeviceInfo();
                    if (curDev != null) {
                        this.onAppSelected(null);
                        curDev.setSelectedPackageLabel(null);
                    }
                    bret = true;
                } else {
                    PackageInfo pkginfo;
                    curDev = Global.getCurrentDeviceInfo();
                    if (curDev != null && (pkginfo = curDev.getPkgInfoByLabel(pkgname)) != null) {
                        this.appCombo.select(i);
                        Global.setCurrentApplication(pkginfo);
                        this.onAppSelected(pkginfo);
                        curDev.setSelectedPackageLabel(pkgname);
                        bret = true;
                    }
                }
            }
            ++i;
        }
        return bret;
    }

    @UIMethod
    public boolean setApplication(String text) {
        if (this.selectAppCombo(text)) {
            return true;
        }
        this.updateAppCombo(false);
        return false;
    }

    @UIMethod
    public void updateAppCombo(boolean deviceChanged) {
        String device = this.deviceCombo.getText();
        if (device == null || device.isEmpty() || device.equals("Select Target")) {
            this.appCombo.initCombo();
            this.selectAppCombo(0);
            this.setAppComboState(false);
            this.ShowDeviceComboTitle();
            return;
        }
        if (deviceChanged) {
            this.newPkgList = this.getAppListFromTarget();
            this.composeAppCombo(this.newPkgList);
            this.oldPkgList = this.newPkgList;
            String packageLabel = Global.getCurrentDeviceInfo().getSelectedPackageLabel();
            if (packageLabel != null) {
                int n = this.appCombo.getItems().indexOf(packageLabel);
            }
            this.ShowAppComboTitle();
            this.updateNewComboThread();
        } else {
            PackageInfo oldPackage = Global.getCurrentApplication();
            String oldPackageName = null;
            if (oldPackage != null) {
                oldPackageName = oldPackage.getMainApp().getLabel();
            }
            this.updateNewComboThread();
            this.composeAppCombo(this.getAppListFromTarget());
            this.ShowAppComboTitle();
            if (oldPackageName == null || this.appCombo.getItems().indexOf(oldPackageName) < 0) {
                this.selectAppCombo(0);
            } else {
                this.appCombo.setText(oldPackageName);
                if (this.startButton.isEnabled()) {
                    this.setAppComboState(true);
                    this.setStartButtonState(true);
                    this.setReplayButtonState(true);
                    return;
                }
            }
        }
        this.setAppComboState(true);
        this.setStartButtonState(false);
        this.setReplayButtonState(false);
    }

    private void updateNewComboThread() {
        Thread updateNewCombo = new Thread(new Runnable(){

            @Override
            public void run() {
                if (Toolbar.this.isAppListUpdated()) {
                    Toolbar.this.redrawAppcombo();
                    Toolbar.this.composeAppCombo(Toolbar.this.newPkgList);
                    System.out.println("--PkgList updated--");
                    Toolbar.this.oldPkgList = Toolbar.this.newPkgList;
                    Toolbar.this.AppComboTitleChanged();
                }
            }
        });
        updateNewCombo.start();
    }

    private void AppComboTitleChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PackageInfo oldPackage = Global.getCurrentApplication();
                String oldPackageName = null;
                if (oldPackage != null) {
                    oldPackageName = oldPackage.getMainApp().getLabel();
                }
                if (oldPackageName == null || Toolbar.this.appCombo.getItems().indexOf(oldPackageName) < 0) {
                    Toolbar.this.selectAppCombo(0);
                } else {
                    Toolbar.this.appCombo.setText(oldPackageName);
                }
            }
        });
    }

    private void onAppSelected(PackageInfo pkg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                Toolbar.this.progressDlg = new ProgressDialog(shell, LayoutManager.getBaseComposite());
                Toolbar.this.progressDlg.setProgressStyle(1);
                Toolbar.this.progressDlg.setProgressMessage(AnalyzerLabels.DLG_COPYING_BINARY);
                Toolbar.this.progressDlg.setProgressInfo(AnalyzerLabels.DLG_PLEASE_WAIT);
                Toolbar.this.progressDlg.open();
            }
        });
        this.progressDlg.setValues("Getting process information", 30);
        if (pkg != null) {
            List<String> binPaths = pkg.getProcessInformation();
            this.progressDlg.setValues("Getting binary from device", 70);
            pkg.getBinaryInformation(binPaths);
        }
        this.progressDlg.setValues("Done", 100);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.progressDlg.close();
            }
        });
    }

    public boolean isAppListUpdated() {
        this.newPkgList = this.getAppListFromTarget();
        if (this.newPkgList.size() == 0 || this.oldPkgList.size() == 0) {
            this.oldPkgList = this.newPkgList;
            return true;
        }
        int i = 0;
        while (i < this.newPkgList.size()) {
            String pkgID = this.newPkgList.get(i).getPackageId();
            if (pkgID != this.oldPkgList.get(i).getPackageId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void startTimer() {
        this.timerClock.start();
    }

    public void stopTimer() {
        this.timerClock.stop();
    }

    @UIMethod
    public void clearTimer() {
        this.timerClock.clear();
    }

    public void setTimerAlarm(long time, IAlarm alarm) {
        this.timerClock.setAlarm(time, alarm);
    }

    public void removeTimerAlarm() {
        this.timerClock.removeAlarm();
    }

    public long getTime() {
        return this.timerClock.getTimeInMicroseconds();
    }

    public void setTime(final long time) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.timerClock.setTime(time / 1000L);
            }
        });
    }

    @UIMethod
    private void initProcessCombo() {
        this.processCombo.initCombo();
        this.processCombo.add(ALL_PROCESS);
        this.processCombo.select(0);
        this.processCombo.setVisible(false);
    }

    public int getSelectedPid() {
        int index;
        String str;
        int ret = 0;
        String pid = this.processCombo.getText();
        if (pid != null && !pid.equals(ALL_PROCESS) && (str = pid.substring(0, index = pid.indexOf(PROCESS_SPLITER))) != null && !str.isEmpty()) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                Logger.exception((Throwable)e);
            }
        }
        return ret;
    }

    public void resetProcessCombo() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.initProcessCombo();
            }
        });
    }

    public void changeUIState(DAState state) {
        final DAState fState = state;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (fState == DAState.PREPARE_START) {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else if (fState == DAState.RUNNING) {
                    Toolbar.this.toggleStartButtonUI(true);
                    Toolbar.this.setStartButtonState(true);
                    Toolbar.this.setMajorControlState(false);
                    Toolbar.this.setMinorControlState(true);
                    Toolbar.this.setScreenShotButtonEnable(true);
                } else if (fState == DAState.PREPARE_STOP) {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else if (fState == DAState.PREPARE_CANCEL) {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else if (fState == DAState.DONE || fState == DAState.INIT) {
                    Toolbar.this.toggleStartButtonUI(false);
                    Toolbar.this.setAllControlState(true);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                }
            }
        });
    }

    public void setAllControlState(boolean enabled) {
        final boolean fEnabled = enabled;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.setStartButtonState(fEnabled);
                Toolbar.this.setMajorControlState(fEnabled);
                Toolbar.this.setMinorControlState(fEnabled);
            }
        });
    }

    private void toggleStartButtonUI(boolean isStarted) {
        if (isStarted) {
            this.startButton.setImages(ImageResources.STOP, ImageResources.STOP_PUSH, ImageResources.STOP_HOVER, ImageResources.START_DISABLE);
            this.startButton.setToolTipText(ShortCutManager.STOP_TRACE);
        } else {
            this.startButton.setImages(ImageResources.START, ImageResources.START_PUSH, ImageResources.START_HOVER, ImageResources.START_DISABLE);
            this.startButton.setToolTipText(ShortCutManager.START_TRACE);
        }
    }

    private void setAppComboState(boolean enabled) {
        DeviceInfo device;
        if (enabled && (device = Global.getCurrentDeviceInfo()) != null) {
            this.appCombo.setEnabled(true);
            return;
        }
        this.appCombo.setEnabled(false);
    }

    private void setStartButtonState(boolean enabled) {
        DeviceInfo device;
        if (enabled && (device = Global.getCurrentDeviceInfo()) != null) {
            PackageInfo curApp;
            String selDev = this.deviceCombo.getText();
            String curDev = device.getIDevice().getSerialNumber();
            if (curDev != null && !curDev.isEmpty() && curDev.equals(selDev) && (curApp = Global.getCurrentApplication()) != null && curApp.isPossibleToTrace()) {
                if (curApp.getMainApp().getLabel().equals("[Running process]")) {
                    if (curApp.getMainApp().getRunningProcesses() != null) {
                        this.startButton.setButtonEnabled(true);
                        return;
                    }
                } else if (curApp.getMainApp().getLabel().equals("[Common executable]")) {
                    if (curApp.getMainApp().getExecPath() != null && !curApp.getMainApp().getExecPath().isEmpty()) {
                        this.startButton.setButtonEnabled(true);
                        return;
                    }
                } else {
                    this.startButton.setButtonEnabled(true);
                    return;
                }
            }
        }
        this.startButton.setButtonEnabled(false);
    }

    public void setSaveButtonState(boolean enabled) {
        Project curProject;
        if (enabled && (curProject = Global.getProject()) != null && curProject.isValid()) {
            this.saveTraceButton.setButtonEnabled(true);
            return;
        }
        this.saveTraceButton.setButtonEnabled(false);
    }

    private void setReplayButtonState(boolean enabled) {
        if (enabled) {
            DeviceInfo curDev;
            if (!SettingDataManager.INSTANCE.isOptionsSelectedFeature(Feature.RECORDING)) {
                this.replayButton.setButtonEnabled(false);
                this.replayEditButton.setButtonEnabled(false);
                return;
            }
            Project curProject = Global.getProject();
            if (curProject != null && curProject.isValid() && (curDev = Global.getCurrentDeviceInfo()) != null) {
                String sDeviceName = curDev.getIDevice().getSerialNumber();
                String pDeviceName = curProject.getDevice();
                String appName = curProject.getAppName();
                String appComboText = this.appCombo.getText();
                if (!(pDeviceName == null || pDeviceName.isEmpty() || !pDeviceName.equals(sDeviceName) || appName == null || appName.isEmpty() || !appName.equals(appComboText) || appName.equals("[Running process]") || appName.equals("[Common executable]") || appName.equals("[Without executable]"))) {
                    this.replayButton.setButtonEnabled(true);
                    this.replayEditButton.setButtonEnabled(true);
                    return;
                }
            }
        }
        this.replayButton.setButtonEnabled(false);
        this.replayEditButton.setButtonEnabled(false);
    }

    private void setMajorControlState(boolean enabled) {
        this.deviceCombo.setEnabled(enabled);
        this.setAppComboState(enabled);
        this.setSaveButtonState(enabled);
        this.openTraceButton.setButtonEnabled(enabled);
        this.setReplayButtonState(enabled);
    }

    private void setMinorControlState(boolean enabled) {
        this.processCombo.setEnabled(enabled);
        this.viewSourceButton.setButtonEnabled(enabled);
        this.configButton.setButtonEnabled(enabled);
        this.aboutButton.setButtonEnabled(enabled);
        this.searchButton.setButtonEnabled(enabled);
    }

    private void setScreenShotButtonEnable(boolean enabled) {
        this.screenshotButton.setButtonEnabled(enabled);
    }

    public boolean isSourceViewEnabled() {
        return this.viewSourceButton.isToggled();
    }

    public void toggleSourceView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.viewSourceButton.setToggled(!Toolbar.this.viewSourceButton.isToggled());
            }
        });
    }

    public boolean getButtonEnabled(int id) {
        DACustomButton button = this.buttons.get(id);
        return button.isButtonEnabled();
    }

    public void ShowDeviceComboTitle() {
        this.deviceCombo.setTextForce("Select Target");
    }

    public void ShowAppComboTitle() {
        this.appCombo.setTextForce("Select Application");
    }

    public void setChartDragStartTime(long time) {
        this.chartDragStart = time;
    }

    public void setChartDragEndTime(long time) {
        this.chartDragEnd = time;
    }

    public long getChartDragStartTime() {
        return this.chartDragStart;
    }

    public long getChartDragEndTime() {
        return this.chartDragEnd;
    }

    public boolean getDlogSelection() {
        return this.dlogTimeSelection;
    }

    public void setDlogSelection(boolean dlogSelection) {
        this.dlogTimeSelection = dlogSelection;
    }
}

