/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.control.UIControlListView;
import org.tizen.dynamicanalyzer.ui.userinterface.profiling.UIFunctionProfilingView;
import org.tizen.dynamicanalyzer.ui.userinterface.scene.UISceneListView;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class UIPage
extends DAPageComposite {
    public static final String pageID = UIPage.class.getName();
    public static final String controlListViewID = UIControlListView.class.getName();
    public static final String sceneListViewID = UISceneListView.class.getName();
    public static final String profilingViewID = UIFunctionProfilingView.class.getName();
    SashForm baseForm;
    SashForm upperForm;
    SashForm bottomForm;

    public UIPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_UI);
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_UI_TOOLTIP);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        ((FillLayout)this.getLayout()).marginHeight = 15;
        ((FillLayout)this.getLayout()).marginWidth = 5;
        this.upperForm = new SashForm((Composite)this.baseForm, 256);
        UIControlListView topLeftFirst = new UIControlListView((Composite)this.upperForm, 0);
        this.addView((DABaseComposite)topLeftFirst);
        UISceneListView topLeftSencond = new UISceneListView((Composite)this.upperForm, 0);
        this.addView((DABaseComposite)topLeftSencond);
        this.upperForm.setWeights(new int[]{40, 60});
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        UIFunctionProfilingView bottomLeftFirst = new UIFunctionProfilingView((Composite)this.bottomForm, 0);
        this.addView((DABaseComposite)bottomLeftFirst);
        TimelineTableView tabView = new TimelineTableView((Composite)this.upperForm, 0);
        this.addView((DABaseComposite)tabView);
        this.bottomForm.setWeights(new int[]{77, 23});
        this.baseForm.setSashWidth(2);
        this.upperForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        DataManagerRegistry.registerPageDataManager(UIDataManager.getInstance());
    }

    protected void onResized(int width, int height) {
        int wrate = (int)(25000.0 / (double)width);
        int hrate = (int)(23500.0 / (double)height);
        wrate = wrate > 100 ? 100 : wrate;
        int n = hrate = hrate > 100 ? 100 : hrate;
        if (wrate > 63 || hrate > 100) {
            return;
        }
        this.upperForm.setWeights(new int[]{100 - wrate, wrate});
        this.baseForm.setWeights(new int[]{100 - hrate, hrate});
    }

    public void clear() {
        super.clear();
        UIDataManager.getInstance().clear();
    }
}

