/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;

public class TableColumnSizePackListener
implements ControlListener {
    DATableComposite tableComp = null;
    private int[] defaultColumnSizes = null;

    public TableColumnSizePackListener(DATableComposite table, int[] defaultSize) {
        this.tableComp = table;
        this.defaultColumnSizes = defaultSize;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        Composite contents = (Composite)e.widget;
        Rectangle rect = contents.getClientArea();
        int width = 0;
        GridColumn[] columns = this.tableComp.getTable().getColumns();
        int size = columns.length;
        int[] columnSizes = new int[size];
        int i = 0;
        while (i < size) {
            columnSizes[i] = columns[i].getWidth();
            if (columns[i].isVisible()) {
                width += columns[i].getWidth();
            }
            ++i;
        }
        int index = -1;
        int i2 = size - 1;
        while (i2 >= 0) {
            if (columns[i2].isVisible()) {
                index = i2;
                break;
            }
            --i2;
        }
        if (index < 0) {
            return;
        }
        if (rect.width - width > 0) {
            int n = index;
            columnSizes[n] = columnSizes[n] + (rect.width - width);
        } else {
            width = 0;
            i2 = 0;
            while (i2 < size) {
                if (columns[i2].isVisible()) {
                    if (this.defaultColumnSizes[i2] == 0) {
                        columns[i2].pack();
                        width += columns[i2].getWidth();
                    } else {
                        width += this.defaultColumnSizes[i2];
                    }
                }
                ++i2;
            }
            int columnSize = 0;
            columnSize = this.defaultColumnSizes[index] == 0 ? columns[index].getWidth() : this.defaultColumnSizes[index];
            columnSizes[index] = rect.width - width > 0 ? rect.width - width + columnSize : columnSize;
        }
        this.tableComp.setColumnSize(columnSizes);
    }
}

