/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.IEventListener;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerEvent;

public class AnalyzerUtil {
    private static TimelineChartView timelineComposite;
    private static Map<String, Boolean> latestTraceModeMap;

    static {
        latestTraceModeMap = new HashMap<String, Boolean>();
        MarkerManager.INSTANCE.addEventListener(new IEventListener(){

            public void handleEvent(MarkerEvent event) {
                AnalyzerUtil.getMainTab().getTopComposite().updateView();
            }
        });
    }

    public static TimelineChartView getTimelineComposite() {
        return timelineComposite;
    }

    public static void setTimelineComposite(TimelineChartView timelineComposite) {
        AnalyzerUtil.timelineComposite = timelineComposite;
    }

    /*
     * Loose catch block
     */
    public static boolean copyFile(String srcPath, String destPath) {
        boolean success;
        block9: {
            success = false;
            FileInputStream fi = null;
            FileOutputStream fo = null;
            try {
                File src = new File(srcPath);
                File dest = new File(destPath);
                fi = new FileInputStream(src);
                fo = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                int readCount = 0;
                while ((readCount = fi.read(buffer)) != -1) {
                    fo.write(buffer, 0, readCount);
                }
                success = true;
            }
            catch (NullPointerException e) {
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{fi, fo});
                break block9;
            }
            catch (FileNotFoundException e) {
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{fi, fo});
                break block9;
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
                {
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{fi, fo});
                        throw throwable;
                    }
                }
                CommonUtil.tryClose((Object[])new Object[]{fi, fo});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{fi, fo});
        }
        return success;
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) {
        block11: {
            if (sourceLocation.isDirectory()) {
                if (!targetLocation.exists() && !targetLocation.mkdir()) {
                    Logger.debug((Object)"Copy Failed : target directory create failed..");
                    return;
                }
                String[] children = sourceLocation.list();
                int i = 0;
                while (i < children.length) {
                    AnalyzerUtil.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                    ++i;
                }
            } else {
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    int len;
                    in = new FileInputStream(sourceLocation);
                    out = new FileOutputStream(targetLocation);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                catch (FileNotFoundException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{in, out});
                    break block11;
                }
                catch (IOException e) {
                    try {
                        Logger.exception((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{in, out});
                        throw throwable;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{in, out});
                    break block11;
                }
                CommonUtil.tryClose((Object[])new Object[]{in, out});
            }
        }
    }

    public static Integer executeCommand(String commandId) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(commandId, new Event());
            return 1;
        }
        catch (ExecutionException e) {
            Logger.exception((Throwable)e);
        }
        catch (NotEnabledException e) {
            Logger.exception((Throwable)e);
        }
        catch (NotHandledException e) {
            Logger.exception((Throwable)e);
        }
        catch (NotDefinedException e) {
            Logger.exception((Throwable)e);
        }
        return -2;
    }

    public static List<String> getDirs(String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return null;
        }
        String[] fileList = file.list();
        ArrayList<String> list = new ArrayList<String>();
        int fileListLength = fileList.length;
        int i = 0;
        while (i < fileListLength) {
            File dir = new File(String.valueOf(path) + File.separator + fileList[i]);
            if (dir.isDirectory()) {
                list.add(fileList[i]);
            }
            ++i;
        }
        return list;
    }

    public static List<String> getFiles(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return null;
        }
        String[] fileList = dir.list();
        ArrayList<String> list = new ArrayList<String>();
        int fileListLength = fileList.length;
        int i = 0;
        while (i < fileListLength) {
            File file = new File(String.valueOf(dirPath) + File.separator + fileList[i]);
            if (!file.isDirectory()) {
                list.add(fileList[i]);
            }
            ++i;
        }
        return list;
    }

    public static List<String> getFiles(String path, String filterString) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return null;
        }
        String[] fileList = file.list();
        ArrayList<String> list = new ArrayList<String>();
        int fileListLength = fileList.length;
        int i = 0;
        while (i < fileListLength) {
            if (fileList[i].endsWith(filterString)) {
                list.add(fileList[i]);
            }
            ++i;
        }
        return list;
    }

    public static void saveTraceImage(String sourceFolderPath, String targetFolderPath) {
        List<String> imageFileList = AnalyzerUtil.getFiles(sourceFolderPath, ".png");
        if (imageFileList != null && imageFileList.size() != 0) {
            String srcName = null;
            String destName = null;
            int imageFileListSize = imageFileList.size();
            int i = 0;
            while (i < imageFileListSize) {
                srcName = String.valueOf(sourceFolderPath) + File.separator + imageFileList.get(i);
                destName = String.valueOf(targetFolderPath) + File.separator + imageFileList.get(i);
                AnalyzerUtil.copyFile(srcName, destName);
                ++i;
            }
        }
    }

    public static void setFontSize(Label label, int size) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || label == null) {
            return;
        }
        FontData[] fd = label.getFont().getFontData();
        int i = 0;
        while (i < fd.length) {
            fd[i].setHeight(size);
            ++i;
        }
        final Font newFont = new Font((Device)display, fd);
        label.setFont(newFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            int i = 0;
            while (i < children.length) {
                boolean success = AnalyzerUtil.deleteFile(new File(file, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return file.delete();
    }

    public static void setCenter(Shell shell) {
        Shell parent = shell.getParent().getShell();
        Rectangle pRect = parent.getBounds();
        Rectangle pChild = shell.getBounds();
        int deltaX = pRect.width - pChild.width;
        int deltaY = pRect.height - pChild.height;
        int childX = pRect.x + deltaX / 2;
        int childY = pRect.y + deltaY / 2;
        shell.setLocation(childX, childY);
    }

    public static void setCenter(Shell shell, Shell parent) {
        Rectangle pRect = parent.getBounds();
        Rectangle pChild = shell.getBounds();
        int deltaX = pRect.width - pChild.width;
        int deltaY = pRect.height - pChild.height;
        int childX = pRect.x + deltaX / 2;
        int childY = pRect.y + deltaY / 2;
        shell.setLocation(childX, childY);
    }

    public static void changePage(final String pageId) {
        final BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DATabComposite tabView = baseView.getMainTab();
                tabView.selectTab(pageId);
            }
        });
    }

    public static Composite getTabPage(String pageId) {
        return AnalyzerUtil.getMainTab().getView(pageId);
    }

    public static DATabComposite getMainTab() {
        BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
        return baseView.getMainTab();
    }

    public static DAPageComposite getTopPage() {
        BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
        return baseView.getTopPage();
    }

    public static DABaseComposite getView(String pageId, String viewId) {
        DAPageComposite page = (DAPageComposite)AnalyzerUtil.getTabPage(pageId);
        if (page == null) {
            return null;
        }
        return page.getView(viewId);
    }

    public static void checkLogs(String path, String prefix, int limitCount) {
        List<String> logFiles = AnalyzerUtil.getFiles(path);
        if (logFiles == null) {
            return;
        }
        ArrayList<String> daLogFiles = new ArrayList<String>();
        for (String name : logFiles) {
            if (!name.contains(prefix)) continue;
            daLogFiles.add(name);
        }
        if (daLogFiles.size() > 3) {
            Collections.sort(daLogFiles);
            int to = daLogFiles.size() - limitCount;
            int i = 0;
            while (i < to) {
                File deleteFile = new File(String.valueOf(path) + File.separator + (String)daLogFiles.get(i));
                if (deleteFile != null) {
                    AnalyzerUtil.deleteFile(deleteFile);
                }
                ++i;
            }
        }
    }

    public static long addrToLong(String hexStr) {
        if (hexStr == null || hexStr.isEmpty()) {
            return 0L;
        }
        hexStr = hexStr.replaceFirst("^0x", "");
        long num = 0L;
        try {
            num = Long.parseLong(hexStr.toString(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return num;
    }

    public static String toHexdecimal(Object value) {
        String retStr = null;
        if (value instanceof Long) {
            retStr = "0x" + Long.toHexString((Long)value).toUpperCase();
        } else if (value instanceof Integer) {
            retStr = "0x" + Integer.toHexString((Integer)value).toUpperCase();
        } else if (value instanceof String) {
            long lValue = Long.parseLong((String)value);
            retStr = "0x" + Long.toHexString(lValue).toUpperCase();
        } else {
            Logger.error((Object)"Input type error!!");
            retStr = value.toString();
        }
        return retStr;
    }

    public static String getProcessLocalBinaryPath(int pid, long time) {
        ProcessMemoryMap pmap = Global.getProject().getProcessInformation(pid).getProcessMemoryMap(time);
        if (pmap != null) {
            return Global.getProject().getDeviceStatusInfo().getBinaryInfo(pmap.getMainbinary().getBinaryID()).getTargetBinaryPath();
        }
        return null;
    }

    public static String getBinarySourcePath(int pid, long time) {
        ProcessMemoryMap pmap = Global.getProject().getProcessInformation(pid).getProcessMemoryMap(time);
        if (pmap != null) {
            return Global.getProject().getDeviceStatusInfo().getBinaryInfo(pmap.getMainbinary().getBinaryID()).getTempBinaryPath();
        }
        return null;
    }

    public static boolean isPieBuild(int pid, long time) {
        ProcessMemoryMap pmap = Global.getProject().getProcessInformation(pid).getProcessMemoryMap(time);
        if (pmap == null) {
            return false;
        }
        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(pmap.getMainbinary().getBinaryID());
        return binInfo != null && binInfo.getType() == 1;
    }

    public static String getTargetPathKey(String targetPath) {
        String returnStr = null;
        String[] splitPath = targetPath.split("/");
        if (splitPath.length < 3) {
            returnStr = targetPath;
        } else {
            int index = targetPath.indexOf(splitPath[splitPath.length - 3]);
            returnStr = targetPath.substring(index, targetPath.length());
        }
        return returnStr;
    }

    public static long translateSecToMicroSec(double sec) {
        return (long)(sec * 1000000.0);
    }

    public static String getProcessName(int pid) {
        Project project = Global.getProject();
        if (project == null) {
            return null;
        }
        ProcessInformation process = project.getProcessInformation(pid);
        if (process != null) {
            String binName = process.getProcessName();
            if (binName == null || binName.isEmpty()) {
                ProcessMemoryMap map = process.getLastProcessMemoryMap();
                if (map != null) {
                    int bid = map.getMainbinary().getBinaryID();
                    BinaryInfo binfo = project.getDeviceStatusInfo().getBinaryInfo(bid);
                    String binPath = binfo.getTargetBinaryPath();
                    if (binPath != null && !binPath.isEmpty()) {
                        int index = binPath.lastIndexOf("/");
                        binName = binPath.substring(index + 1, binPath.length());
                    }
                } else {
                    Logger.error((Object)("Process map of pid " + pid + " does not exist"));
                    return null;
                }
            }
            return binName;
        }
        Logger.error((Object)("Process information of pid " + pid + " does not exist"));
        return null;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String[] splitFilePath(String filePath, String separator) {
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        return filePath.split(separator);
    }

    public static boolean isLatestTraceMode(String pageID) {
        Boolean isLatestTraceMode = latestTraceModeMap.get(pageID);
        if (isLatestTraceMode != null) {
            return isLatestTraceMode;
        }
        return false;
    }

    public static void setLatestTraceMode(String pageID, boolean isOn) {
        latestTraceModeMap.put(pageID, isOn);
    }

    public static void setPlatformSDK() {
        AnalyzerManager.setPlatformSDK(SettingDataManager.INSTANCE.isPlatformDA());
    }

    public static void captureScreenshot() {
        if (!DAState.isRunning()) {
            return;
        }
        SettingDataManager.INSTANCE.enableScreenshotFeature(true);
        try {
            if (!DACommunicator.captureScreenshot().isSuccess()) {
                Logger.error((Object)"Failed to capture screenshot");
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.warning((Object)"Interrupted during send screenshot message");
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            Logger.warning((Object)"Message to capture screenshot is not supported by communicator");
        }
    }
}

