/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.CConfigBasedDescriptor;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCExtensionProxy
implements ICProjectDescriptionListener {
    private IProject fProject;
    private String fExtId;
    private boolean fIsNewStyle;
    private boolean fInited;
    private String fExtPointId;
    private Object fProvider;

    public AbstractCExtensionProxy(IProject project, String extPointId) {
        this.fProject = project;
        this.fExtPointId = extPointId;
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 5);
    }

    protected final void providerRequested() {
        if (!this.fInited) {
            this.checkUpdateProvider(CProjectDescriptionManager.getInstance().getProjectDescription(this.fProject, false), false, false);
        }
    }

    public void updateProject(IProject project) {
        IProject oldProj = this.fProject;
        this.fProject = project;
        if (oldProj == null || !oldProj.equals((Object)this.fProject)) {
            this.fInited = false;
        }
    }

    private ICExtensionReference getRef(ICConfigurationDescription cfg, boolean update) {
        if (this.fExtPointId != null) {
            try {
                CConfigBasedDescriptor dr = new CConfigBasedDescriptor(cfg, false);
                ICExtensionReference[] cextensions = dr.get(this.fExtPointId, update);
                if (cextensions.length > 0) {
                    return cextensions[0];
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUpdateProvider(ICProjectDescription des, boolean recreate, boolean rescan) {
        Object newProvider = null;
        Object oldProvider = null;
        AbstractCExtensionProxy abstractCExtensionProxy = this;
        synchronized (abstractCExtensionProxy) {
            if (recreate || rescan || !this.fInited) {
                ICExtensionReference ref = null;
                boolean newStyle = true;
                ICConfigurationDescription cfg = null;
                if (des != null && (cfg = des.getDefaultSettingConfiguration()) != null) {
                    ref = this.getRef(cfg, false);
                    newStyle = CProjectDescriptionManager.getInstance().isNewStyleCfg(cfg);
                }
                if (ref != null && (recreate || !ref.getID().equals(this.fExtId))) {
                    try {
                        newProvider = ref.createExtension();
                        if (!this.isValidProvider(newProvider)) {
                            newProvider = null;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (newProvider == null && (recreate || this.fProvider == null || newStyle != this.fIsNewStyle)) {
                    newStyle = this.isNewStyleCfg(cfg);
                    newProvider = this.createDefaultProvider(cfg, newStyle);
                }
                if (newProvider != null) {
                    if (this.fProvider != null) {
                        this.deinitializeProvider(this.fProvider);
                        oldProvider = this.fProvider;
                    }
                    this.fProvider = newProvider;
                    if (ref != null) {
                        this.fExtId = ref.getID();
                    }
                    this.fIsNewStyle = newStyle;
                    this.initializeProvider(this.fProvider);
                }
                this.fInited = true;
            }
        }
        if (newProvider != null) {
            this.postProcessProviderChange(newProvider, oldProvider);
            return true;
        }
        return false;
    }

    protected boolean isNewStyleCfg(ICConfigurationDescription des) {
        return CProjectDescriptionManager.getInstance().isNewStyleCfg(des);
    }

    protected abstract boolean isValidProvider(Object var1);

    protected abstract void initializeProvider(Object var1);

    protected abstract void deinitializeProvider(Object var1);

    protected abstract Object createDefaultProvider(ICConfigurationDescription var1, boolean var2);

    protected void postProcessProviderChange(Object newProvider, Object oldProvider) {
    }

    public void close() {
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
        if (this.fProvider != null) {
            this.deinitializeProvider(this.fProvider);
        }
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        if (!this.fProject.equals((Object)event.getProject())) {
            return;
        }
        this.doHandleEvent(event);
    }

    protected boolean doHandleEvent(CProjectDescriptionEvent event) {
        boolean force = false;
        switch (event.getEventType()) {
            case 1: {
                force = true;
            }
            case 4: {
                ICProjectDescription des = event.getNewCProjectDescription();
                if (des == null) break;
                this.updateProject(des.getProject());
                return this.checkUpdateProvider(des, force, true);
            }
        }
        return false;
    }
}

