/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.resources;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.tizen.dynamicanalyzer.util.CommonUtil;

public class FontResources {
    private static FontRegistry fontRegistry = new FontRegistry();
    private static final Font defaultFont = FontResources.getDADefaultFont();
    private static final Font systemFont = PlatformUI.getWorkbench().getDisplay().getSystemFont();
    public static final Font COMBO = FontResources.getFont("combo", FontResources.resizeDefaultFont(8, 3));
    public static final Font DROPDOWN = FontResources.getFont("dropdown", FontResources.resizeDefaultFont(8, 3));
    public static final Font FRAME_RATE_COMBO = FontResources.getFont("frame_rate_combo", FontResources.resizeDefaultFont(8, 3));
    public static final Font FRAME_RATE_DROPDOWN = FontResources.getFont("frame_rate_dropdown", FontResources.resizeDefaultFont(8, 3));
    public static final Font TIMER = FontResources.getFont("timer", FontResources.resizeDefaultFont(10, 3));
    public static final Font TAB_BUTTON_FONT = FontResources.getFont("tab_button_font", FontResources.resizeDefaultFont(10, 3));
    public static final Font TAB_BUTTON_LARGE_FONT = FontResources.getFont("tab_button_large_font", FontResources.resizeDefaultFont(9, 2));
    public static final Font TAB_BUTTON_BOLD_FONT = FontResources.getFont("tab_button_bold_font", FontResources.resizeBoldFont(11, 3));
    public static final Font ADDITEM_BUTTON_FONT = FontResources.getFont("additem_button_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font VIEW_TITLE = FontResources.getFont("view_title", FontResources.resizeDefaultFont(10, 1));
    public static final Font IMAGE_VIEWER_LABEL = FontResources.getFont("image_viewer_label", FontResources.resizeDefaultFont(11, 3));
    public static final Font TIMELINE_UIEVENT_FONT = FontResources.getFont("timeline_uievent_font", FontResources.resizeDefaultFont(7, 3));
    public static final Font OPEN_TRACE_INNER_TITLE = FontResources.getFont("open_trace_inner_title", FontResources.resizeDefaultFont(9, 2));
    public static final Font EDIT_CHART_DLG_TITLE = FontResources.getFont("edit_chart_dlg_title", FontResources.resizeDefaultFont(9, 0));
    public static final Font EDIT_CHART_DLG_BUTTON = FontResources.getFont("edit_chart_dlg_button", FontResources.resizeDefaultFont(9, 2));
    public static final Font EDIT_CHART_DLG_ITEM_NAME = FontResources.getFont("edit_chart_item_name", FontResources.resizeDefaultFont(9, 2));
    public static final Font EDIT_CHART_DLG_ITEM_SUB_NAME = FontResources.getFont("edit_chart_item_sub_name", FontResources.resizeDefaultFont(8, 3));
    public static final Font TABLE_HEADER_FONT = FontResources.getFont("table_header_font", FontResources.resizeBoldFont(8, 3));
    public static final Font TABLE_CELL_FONT = FontResources.getFont("table_cell_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font EXPLORER_CELL_FONT = FontResources.getFont("table_cell_font", FontResources.resizeDefaultFont(15, 3));
    public static final Font DETAIL_INFO_FONT = FontResources.getFont("detail_info_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font ABOUT_TEXT = FontResources.getFont("about_text", FontResources.resizeDefaultFont(9, 2));
    public static final Font LICENSE_TEXT = FontResources.getFont("license_text", FontResources.resizeDefaultFont(8, 3));
    public static final Font DIALOG_BUTTON_FONT = FontResources.getFont("dialog_button_font", FontResources.resizeDefaultFont(9, 2));
    public static final Font STOP_PROGRESS_FONT = FontResources.getFont("stop_progress_font", FontResources.resizeSystemFont(9));
    public static final Font PROGRESS_FONT = FontResources.getFont("progress_font", FontResources.resizeSystemFont(9));
    public static final Font PROGRESS_PERCENTAGE_FONT = FontResources.getFont("progress_percentage_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font TOOLTIP = FontResources.getFont("tooltip", FontResources.resizeDefaultFont(10, 1));
    public static final Font CIRCULAR_GRAPH_VALUE_FONT = FontResources.getFont("circular_graph_value_font", FontResources.resizeDefaultFont(13, 5));
    public static final Font CIRCULAR_GRAPH_MEASURE_FONT = FontResources.getFont("circular_graph_measure_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font CIRCULAR_LABEL_FONT = FontResources.getFont("circular_label_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font BAR_GRAPH_LABEL_FONT = FontResources.getFont("bar_graph_label_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font BAR_GRAPH_FONT = FontResources.getFont("bar_graph_font", FontResources.resizeDefaultFont(6, 5));
    public static final Font LOCK_LABEL_FONT = FontResources.getFont("lock_label_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font SCORE_TITLE_FONT = FontResources.getFont("score_title_font", FontResources.setDefaultFontStyleAndSize(1, 10));
    public static final Font CHART_TOOLTIP_FONT = FontResources.getFont("chart_tootip_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font CHART_AXIS_FONT = FontResources.getFont("chart_axis_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font CHART_ARROW_TID_FONT = FontResources.getFont("chart_arrow_tid_font", FontResources.resizeDefaultFont(7, 3));
    public static final Font CHART_NAME_FONT = FontResources.getFont("chart_name_font", FontResources.resizeDefaultFont(10, 3));
    public static final Font CHART_CHILD_ITEM_NAME_FONT = FontResources.getFont("chart_child_item_name_font", FontResources.resizeDefaultFont(8));
    public static final Font CONTEXT_MENU_TITLE_FONT = FontResources.getFont("context_menu_title_font", FontResources.resizeDefaultFont(9, 3));
    public static final Font CONTEXT_MENU_ITEM_FONT = FontResources.getFont("context_menu_item_font", FontResources.resizeDefaultFont(9, 3));
    public static final Font CONFIGURATION_TABLE_TITLE_FONT = FontResources.getFont("configuration_table_title_font", FontResources.resizeDefaultFont(9, 3));
    public static final Font TIMELINE_FONT = FontResources.getFont("timeline_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font TIMELINE_TICK_FONT = FontResources.getFont("time_tick", FontResources.resizeDefaultFont(8, 3));
    public static final Font TIMELINE_BALLOON_FONT = FontResources.getFont("time_balloon", FontResources.resizeDefaultFont(8, 3));
    public static final Font SETTING_BUTTON_FONT = FontResources.getFont("setting_button_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font SETTING_TITLE_FONT = FontResources.getFont("setting_title_font", FontResources.resizeDefaultFont(10, -1));
    public static final Font SETTING_DESCRIPTION_FONT = FontResources.getFont("setting_description_font", FontResources.resizeDefaultFont(8, -1));
    public static final Font UIHIERARCHY_TREE_NODE_TYPE_FONT = FontResources.getFont("uihierarchy_tree_node_type_font", FontResources.resizeDefaultFont(12, 3));
    public static final Font UIHIERARCHY_TREE_NODE_RENDER_FONT = FontResources.getFont("uihierarchy_tree_node_render_font", FontResources.resizeDefaultFont(9, 3));
    public static final Font UIHIERARCHY_TREE_NODE_INFO_NAME_FONT = FontResources.getFont("uihierarchy_tree_node_info_name_font", FontResources.resizeDefaultFont(12, 3));
    public static final Font UIHIERARCHY_TREE_NODE_INFO_DESCRIPT_FONT = FontResources.getFont("uihierarchy_tree_node_info_descript_font", FontResources.resizeDefaultFont(10, 3));
    public static final Font UIHIERARCHY_TOOLBAR_FONT = FontResources.getFont("uihierarchy_toolbar_font", FontResources.resizeDefaultFont(9, 3));
    public static final Font DIALOG_CONTENTS_BOLD_FONT = FontResources.getFont("dialog_contents_bold_font", FontResources.resizeBoldFont(8, 3));
    public static final Font DIALOG_CONTENTS_NORMAL_FONT = FontResources.getFont("dialog_contents_normal_font", FontResources.resizeDefaultFont(8, 3));
    public static final Font ABOUT_DIALOG_TITLE_BIG_FONT = FontResources.getFont("about_dialog_title_big_font", new FontData[]{new FontData("BreezeS", 23, 1)});
    public static final Font ABOUT_DIALOG_TITLE_BIG_FONT_MAC = FontResources.getFont("about_dialog_title_big_font_mac", new FontData[]{new FontData("BreezeS", 23, 1)});
    public static final Font ABOUT_DIALOG_TITLE_MIDDLE_FONT = FontResources.getFont("about_dialog_title_middle_font", new FontData[]{new FontData("BreezeS", 12, 0)});
    public static final Font ABOUT_DIALOG_TITLE_MIDDLE_FONT_MAC = FontResources.getFont("about_dialog_title_middle_font_mac", new FontData[]{new FontData("BreezeS", 13, 0)});
    public static final Font ABOUT_DIALOG_TITLE_SMALL_FONT = FontResources.getFont("about_dialog_title_small_font", new FontData[]{new FontData("Arial", 10, 1)});

    private static Font getFont(String fontName, FontData[] fontData) {
        if (!fontRegistry.hasValueFor(fontName)) {
            fontRegistry.put(fontName, fontData);
        }
        return fontRegistry.get(fontName);
    }

    public static FontData[] resizeDefaultFont(int size, int mac) {
        if (CommonUtil.isMac()) {
            return FontResources.resizeDefaultFont(size + mac);
        }
        return FontResources.resizeDefaultFont(size);
    }

    public static FontData[] resizeDefaultFont(int size) {
        FontData[] fontData = defaultFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(size);
            ++i;
        }
        return fontData;
    }

    public static FontData[] resizeBoldFont(int size, int mac) {
        FontData[] fontData = defaultFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(CommonUtil.isMac() ? size + mac : size);
            fontData[i].setStyle(1);
            ++i;
        }
        return fontData;
    }

    public static FontData[] setDefaultFontStyle(int style) {
        FontData[] fontData = defaultFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(style);
            ++i;
        }
        return fontData;
    }

    public static FontData[] setDefaultFontStyleAndSize(int style, int size) {
        FontData[] fontData = defaultFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(style);
            fontData[i].setHeight(size);
            ++i;
        }
        return fontData;
    }

    public static FontData[] resizeSystemFont(int size) {
        FontData[] fontData = systemFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(size);
            ++i;
        }
        return fontData;
    }

    public static Font getDADefaultFont() {
        String fontName = null;
        if (CommonUtil.isLinux()) {
            fontName = "Dejavu Sans";
        } else if (CommonUtil.isWin()) {
            fontName = "Verdana";
        } else {
            return PlatformUI.getWorkbench().getDisplay().getSystemFont();
        }
        return FontResources.getFont("ex_font", new FontData[]{new FontData(fontName, 9, 0)});
    }
}

