/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.widgets.tooltip.DACustomTooltip;

public abstract class DAAbstractText {
    protected Text text = null;
    protected boolean textTooltip = false;
    protected String textTooltipMessage = null;
    protected Color boaderColor = ColorResources.TEXT_NORMAL_COLOR;
    public Listener textMouseListener = new Listener(){

        public void handleEvent(Event event) {
            int type = event.type;
            switch (type) {
                case 6: {
                    DAAbstractText.this.boaderColor = ColorResources.TEXT_HOVER_COLOR;
                    break;
                }
                case 32: {
                    DAAbstractText.this.boaderColor = ColorResources.TEXT_HOVER_COLOR;
                    break;
                }
                case 3: {
                    DAAbstractText.this.boaderColor = ColorResources.TEXT_PUSH_COLOR;
                    break;
                }
                case 7: {
                    DAAbstractText.this.boaderColor = ColorResources.TEXT_NORMAL_COLOR;
                    break;
                }
                case 4: {
                    DAAbstractText.this.boaderColor = ColorResources.TEXT_HOVER_COLOR;
                }
            }
            DAAbstractText.this.redraw();
        }
    };
    private DACustomTooltip tooltip = new DACustomTooltip(){

        public void setTooltipMessage() {
            this.tooltipMessage.clear();
            this.tooltipMessage.add(DAAbstractText.this.textTooltipMessage);
        }

        public void setTooltipMessage(String name) {
            this.tooltipMessage.clear();
            this.tooltipMessage.add(name);
        }
    };
    private Listener textTooltipListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 5) {
                DAAbstractText.this.tooltip.setHidden(false);
                DAAbstractText.this.tooltip.setSeletedItem(DAAbstractText.this.text.getText());
                DAAbstractText.this.tooltip.openAndMove(DAAbstractText.this.text.getShell());
            }
            if (event.type == 7) {
                DAAbstractText.this.tooltip.close();
            }
            if (event.type == 3 || event.type == 1) {
                DAAbstractText.this.tooltip.setHidden(true);
                DAAbstractText.this.tooltip.close();
            }
        }
    };

    abstract void redraw();

    public void setTableToolTipListener() {
        this.text.addListener(6, this.textTooltipListener);
        this.text.addListener(7, this.textTooltipListener);
        this.text.addListener(5, this.textTooltipListener);
        this.text.addListener(3, this.textTooltipListener);
        this.text.addListener(1, this.textTooltipListener);
    }

    public boolean isTextTooltip() {
        return this.textTooltip;
    }

    public void setTextTooltip(boolean textTooltip) {
        this.textTooltip = textTooltip;
        if (textTooltip) {
            this.setTableToolTipListener();
        }
    }

    public String getTextTooltipMessage() {
        return this.textTooltipMessage;
    }

    public void setTextTooltipMessage(String textTooltipMessage) {
        this.textTooltipMessage = textTooltipMessage;
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setLayoutData(Object data) {
        this.text.setLayoutData(data);
    }

    public Text getControl() {
        return this.text;
    }

    public void setBackground(Color color) {
        this.text.setBackground(color);
    }

    public void setForeground(Color color) {
        this.text.setForeground(color);
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }
}

