/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.utils.elf.Elf;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.model.AddrSymbolPair;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElfSymbolExtractor {
    private String sourcePath = null;
    private HashMap<Long, String> symbolMap = new HashMap();
    private List<AddrSymbolPair> addrSymbolPairs = new ArrayList<AddrSymbolPair>();

    public boolean makeSymbol(String path) {
        int n;
        int n2;
        Elf.PHdr[] pHdrArray;
        Elf elf;
        long baseAddr;
        block9: {
            if (path == null || path.isEmpty()) {
                return false;
            }
            this.sourcePath = path;
            if (this.symbolMap != null) {
                this.symbolMap.clear();
            } else {
                this.symbolMap = new HashMap();
            }
            baseAddr = 0L;
            try {
                Elf.PHdr[] phdrs;
                elf = new Elf(path);
                elf.loadSymbols();
                if (elf.getELFhdr().e_type != 2) break block9;
                pHdrArray = phdrs = elf.getPHdrs();
                n2 = phdrs.length;
                n = 0;
                while (n < n2) {
                    Elf.PHdr phdr = pHdrArray[n];
                    if (phdr.p_type == 1L) {
                        baseAddr = phdr.p_vaddr.getValue().longValue();
                        break;
                    }
                    ++n;
                }
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
                return false;
            }
        }
        Elf.Symbol[] symbols = elf.getSymbols();
        pHdrArray = symbols;
        n2 = symbols.length;
        n = 0;
        while (n < n2) {
            Elf.PHdr symbol = pHdrArray[n];
            if (symbol.st_type() == 2 && symbol.st_shndx != 0) {
                long addr = symbol.st_value.getValue().longValue() - baseAddr;
                String symbolStr = symbol.toString();
                symbolStr = SymbolManager.demanglingFunctionName(symbolStr);
                this.symbolMap.put(addr, symbolStr);
                this.addrSymbolPairs.add(new AddrSymbolPair(addr, symbolStr));
            }
            ++n;
        }
        return true;
    }

    @Deprecated
    public Long[] getSymbolAddress() {
        if (this.symbolMap == null || this.symbolMap.size() == 0) {
            return null;
        }
        Long[] ret = new Long[this.symbolMap.size()];
        ret = this.symbolMap.keySet().toArray(ret);
        return ret;
    }

    @Deprecated
    public HashMap<Long, String> getSymbolMap() {
        return this.symbolMap;
    }

    public void setLibPath(String libPath) {
        this.sourcePath = libPath;
    }

    public String getLibPath() {
        return this.sourcePath;
    }

    public void clear() {
        this.sourcePath = null;
        if (this.symbolMap != null) {
            this.symbolMap.clear();
        }
        if (this.addrSymbolPairs != null) {
            this.addrSymbolPairs.clear();
        }
    }

    public List<AddrSymbolPair> getAddrSymbolPairs() {
        return this.addrSymbolPairs;
    }
}

