/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.database.DBTable;

public class DBTableRegistry {
    private static boolean registerSwitch = true;
    private static Map<String, DBTable> tables = null;

    static {
        tables = new HashMap<String, DBTable>();
    }

    public static synchronized void registerEnabled(boolean enabled) {
        registerSwitch = enabled;
    }

    public static synchronized void registerDBTable(DBTable table) {
        if (registerSwitch) {
            tables.put(table.getTableName(), table);
        }
    }

    public static void createDBTables(Set<String> tableNames) {
        if (tableNames == null) {
            for (Map.Entry<String, DBTable> entry : tables.entrySet()) {
                DBTable table = entry.getValue();
                table.createTable();
                table.createIndexTable();
            }
        } else {
            for (Map.Entry<String, DBTable> entry : tables.entrySet()) {
                String tableName = entry.getKey();
                if (!tableNames.contains(tableName)) continue;
                DBTable table = entry.getValue();
                table.createTable();
                table.createIndexTable();
            }
        }
    }

    public static DBTable getDBTable(String tablename) {
        return tables.get(tablename);
    }
}

