/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.listeners;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.network.NetworkPage;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class SummaryMouseDoubleClickListener
implements MouseListener {
    boolean doubleClicked = false;
    LogData data = null;
    String pageId = null;
    String sourceViewID = null;

    public SummaryMouseDoubleClickListener(String sourceview) {
        this.sourceViewID = sourceview;
    }

    public void mouseUp(MouseEvent e) {
        if (this.doubleClicked) {
            this.doubleClicked = false;
            if (this.pageId != null && this.data != null) {
                AnalyzerUtil.changePage(this.pageId);
                DAPageComposite page = (DAPageComposite)AnalyzerUtil.getTabPage(this.pageId);
                page.updateView((DAViewData)new DASelectionData(this.sourceViewID, this.data));
            }
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (MenuBar.getInstance().getSourceView() || !(e.widget instanceof Grid)) {
            return;
        }
        Grid grid = (Grid)e.widget;
        GridItem item = grid.getItem(new Point(e.x, e.y));
        if (item == null) {
            return;
        }
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        this.data = tableData.getLogData();
        switch (this.data.getMsgID()) {
            case 260: {
                this.pageId = FilePage.pageID;
                break;
            }
            case 264: {
                this.pageId = ThreadPage.pageID;
                break;
            }
            case 273: {
                this.pageId = NetworkPage.pageID;
                break;
            }
            case 274: {
                this.pageId = GLPage.pageID;
                break;
            }
            default: {
                return;
            }
        }
        this.doubleClicked = true;
    }
}

