/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.util.Logger;

public class PackageInfo {
    public static final String PKGTYPE = "pkg_type";
    public static final String PKGID = "pkgid";
    public static final String VERSION = "version";
    public static final String PRELOAD = "preload";
    public static final String INSTALLTIME = "installed_time";
    private String id = null;
    private String pkgType = null;
    private String version = null;
    private int preload = 0;
    private long installTime = 0L;
    private boolean isPossibleToTrace = true;
    private List<AppInfo> appInfos = new ArrayList<AppInfo>();

    public PackageInfo() {
    }

    public PackageInfo(String pkgId) {
        this.id = pkgId;
    }

    public void addAppInfo(AppInfo appInfo) {
        for (AppInfo app : this.appInfos) {
            if (!app.getAppID().equals(appInfo.getAppID())) continue;
            return;
        }
        this.appInfos.add(appInfo);
    }

    public AppInfo getAppInfo(String appId) {
        for (AppInfo info : this.appInfos) {
            if (!appId.equals(info.getInfo(AppInfo.PROPERTY.APPID.index))) continue;
            return info;
        }
        return null;
    }

    public String getPackageId() {
        return this.id;
    }

    public void setPackageId(String pkgid) {
        this.id = pkgid;
    }

    public List<AppInfo> getAppInfos() {
        return this.appInfos;
    }

    public AppInfo getMainApp() {
        if (this.appInfos.size() == 0) {
            System.err.println("The empty package. ID: " + this.id.toString());
            return null;
        }
        return this.appInfos.get(0);
    }

    public String getPkgType() {
        return this.pkgType;
    }

    public void setPkgType(String pkgType) {
        this.pkgType = pkgType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getPreload() {
        return this.preload;
    }

    public void setPreload(int preload) {
        this.preload = preload;
    }

    public long getInstallTime() {
        return this.installTime;
    }

    public void setInstallTime(long installTime) {
        this.installTime = installTime;
    }

    public boolean isPossibleToTrace() {
        return this.isPossibleToTrace;
    }

    public void setPossibleToTrace(boolean isPossibleToTrace) {
        this.isPossibleToTrace = isPossibleToTrace;
    }

    public List<String> getProcessInformation() {
        ArrayList<String> binPaths = new ArrayList<String>();
        String packageID = this.getPackageId();
        if ("_Running process_".equals(packageID)) {
            Map<Integer, String> selProcess = this.getMainApp().getRunningProcesses();
            if (selProcess == null) {
                Logger.warning((Object)"There is no selected process");
                this.setPossibleToTrace(false);
            } else {
                for (Map.Entry<Integer, String> entry : selProcess.entrySet()) {
                    binPaths.add(entry.getValue());
                }
                this.setPossibleToTrace(true);
            }
        } else if (!"_Without executable_".equals(packageID)) {
            if ("_Common executable_".equals(packageID)) {
                String executablePath = this.getMainApp().getExecBinaryPath();
                if (executablePath == null || executablePath.isEmpty()) {
                    Logger.warning((Object)"There is no application in selected package");
                    this.setPossibleToTrace(false);
                } else {
                    binPaths.add(executablePath);
                    this.setPossibleToTrace(true);
                }
            } else {
                List<AppInfo> apps = this.getAppInfos();
                if (apps == null) {
                    Logger.warning((Object)"There is no application in selected package");
                    this.setPossibleToTrace(false);
                } else {
                    for (AppInfo app : apps) {
                        binPaths.add(app.getExecBinaryPath());
                    }
                    this.setPossibleToTrace(true);
                }
            }
        }
        return binPaths;
    }

    public DAResult.ErrorCode getBinaryInformation(List<String> binPaths) {
        if (!binPaths.isEmpty()) {
            DAResult hr = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
            try {
                hr = DACommunicator.getBinaryInformation(binPaths);
            }
            catch (InterruptedException interruptedException) {
                Logger.warning((Object)"Interrupted during getting binary information about application binary");
            }
            catch (UnsupportedProtocolException unsupportedProtocolException) {
                Logger.warning((Object)"Message to get binary information is not supported by communicator");
            }
            if (hr.equals((Object)DAResult.ErrorCode.ERR_BY_SECURITY)) {
                UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                Logger.warning((Object)"Failed to get binary info by security reason");
                this.setPossibleToTrace(false);
                return DAResult.ErrorCode.ERR_BY_SECURITY;
            }
            if (!hr.isSuccess()) {
                UIActionHolder.getUIAction().showWarning(hr);
                Logger.warning((Object)("Failed to get binary info : " + hr.getMessage()));
                this.setPossibleToTrace(false);
                return hr.getErrorCode();
            }
            this.setPossibleToTrace(true);
            return DAResult.ErrorCode.SUCCESS;
        }
        return DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL;
    }
}

