/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.callstack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.callstack.BaseCallstackManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackDataDBTable;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackInserter;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackItem;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnitDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.util.Logger;

public class RuntimeCallstackManager
extends BaseCallstackManager {
    protected Map<Integer, NavigableMap<Long, Long>> seqTimeByTidMap = new ConcurrentHashMap<Integer, NavigableMap<Long, Long>>();

    public void offerCallStackData(CallStackData csd) {
        CallStackInserter.getInstance().pushData(csd);
    }

    public NavigableMap<Long, Long> getSeqTimeByTidMap(int tid, boolean isCreate) {
        NavigableMap<Long, Long> seqByTimeMap = this.seqTimeByTidMap.get(tid);
        if (isCreate && seqByTimeMap == null) {
            seqByTimeMap = new ConcurrentSkipListMap<Long, Long>();
            this.seqTimeByTidMap.put(tid, seqByTimeMap);
        }
        return seqByTimeMap;
    }

    public List<Integer> getTidsOfSeqTimeMap() {
        ArrayList<Integer> tids = new ArrayList<Integer>();
        tids.addAll(this.seqTimeByTidMap.keySet());
        return tids;
    }

    @Override
    public void clear() {
        super.clear();
        this.seqTimeByTidMap.clear();
    }

    @Override
    public void makeUserCallstack(LogData input, ProfileDataMaker profiler) {
        int eventType;
        if (!(input instanceof ProfileData)) {
            Logger.warning((Object)"failed to make user callstack : log is not profile log");
            return;
        }
        ProfileData log = (ProfileData)input;
        int pid = log.getPid();
        long time = log.getTime();
        Map<Long, CallStackUnit> addrMap = this.getCallStackApiAddrByPidMap(pid);
        long selfAddr = log.getPcAddr();
        long callerAddr = log.getCallerPcAddr();
        CallStackUnit selfCallstackUnit = addrMap.get(selfAddr);
        if (selfCallstackUnit == null) {
            String strSelfFuncName = Global.getFunctionName(log.getApiId());
            BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(log.getBinaryId());
            String strSelfSymbol = String.valueOf(binInfo.getTargetBinaryPath()) + "(" + strSelfFuncName;
            selfCallstackUnit = new CallStackUnit(selfAddr, strSelfSymbol, log.getApiId(), log);
            addrMap.put(selfAddr, selfCallstackUnit);
        }
        profiler.makeFupDataForCallTrace(selfCallstackUnit, log);
        CallStackUnit callerCallstackUnit = addrMap.get(callerAddr);
        if (callerCallstackUnit == null) {
            String strCallerSymbol = this.getCallStackSymbol(callerAddr, pid, time);
            callerCallstackUnit = new CallStackUnit(callerAddr, strCallerSymbol, log);
            addrMap.put(callerAddr, callerCallstackUnit);
        }
        if ((eventType = log.getMsgID()) == 8) {
            this.proceedEntry(log, selfCallstackUnit, addrMap);
        } else if (eventType == 9) {
            this.proceedExit(log, selfCallstackUnit, addrMap);
        }
    }

    private void proceedEntry(ProfileData log, CallStackUnit selfCallstackUnit, Map<Long, CallStackUnit> addrMap) {
        int pid = log.getPid();
        int tid = log.getTid();
        long time = log.getTime();
        long callerAddr = log.getCallerPcAddr();
        long seq = log.getSeq();
        List<CallStackItem> userCallstack = this.getUserCallstack(tid);
        int size = userCallstack.size();
        CallStackData callstackData = new CallStackData(seq);
        NavigableMap<Long, Long> seqByTimeMap = this.getSeqTimeByTidMap(tid, true);
        if (size == 0) {
            userCallstack.add(new CallStackItem(selfCallstackUnit, time));
        } else {
            if (!this.isAddrInBinaryRange(pid, time, callerAddr)) {
                CallStackUnit callbackApi = addrMap.get(0L);
                if (callbackApi == null) {
                    callbackApi = new CallStackUnit(0L, "(~~ internal library ~~", log);
                    addrMap.put(0L, callbackApi);
                }
                userCallstack.add(new CallStackItem(callbackApi));
            } else {
                CallStackUnit callerCsa = addrMap.get(callerAddr);
                if (callerCsa == null) {
                    callerCsa = userCallstack.get(size - 1).getCallStackUnit();
                    callerCsa.setFunctionStartAddr(callerCsa.getAddr());
                    callerCsa.setAddr(callerAddr);
                } else {
                    CallStackItem topCallstackItem = userCallstack.get(size - 1);
                    callerCsa.setFunctionStartAddr(topCallstackItem.getCallStackUnit().getAddr());
                    userCallstack.set(size - 1, new CallStackItem(callerCsa, topCallstackItem.getStartTime()));
                }
            }
            userCallstack.add(new CallStackItem(selfCallstackUnit, time));
        }
        size = userCallstack.size();
        int i = size - 1;
        while (i >= 0) {
            callstackData.addAddr(userCallstack.get(i).getCallStackUnit().getAddr());
            --i;
        }
        this.offerCallStackData(callstackData);
        this.getCallStackDataBySeqMap().put(seq, callstackData);
        seqByTimeMap.put(time, seq);
    }

    private void proceedExit(ProfileData log, CallStackUnit selfCallstackUnit, Map<Long, CallStackUnit> addrMap) {
        int tid = log.getTid();
        long time = log.getTime();
        long seq = log.getSeq();
        List<CallStackItem> userCallstack = this.getUserCallstack(tid);
        int size = userCallstack.size();
        CallStackData callstackData = new CallStackData(seq);
        NavigableMap<Long, Long> seqByTimeMap = this.getSeqTimeByTidMap(tid, true);
        if (size == 0) {
            return;
        }
        CallStackUnit removeCallStackUnit = userCallstack.get(size - 1).getCallStackUnit();
        if (selfCallstackUnit.getFunctionId() == removeCallStackUnit.getFunctionId()) {
            CallStackUnit checkCallStackUnit;
            userCallstack.remove(size - 1);
            size = userCallstack.size();
            if (size - 1 > 0 && (checkCallStackUnit = userCallstack.get(size - 1).getCallStackUnit()).getFunctionName().equals("~~ internal library ~~")) {
                userCallstack.remove(size - 1);
            }
            if ((size = userCallstack.size()) > 0) {
                CallStackItem prevCallstackItem = userCallstack.get(size - 1);
                long prevSelfAddr = prevCallstackItem.getCallStackUnit().getFunctionStartAddr();
                CallStackUnit callerCsa = addrMap.get(prevSelfAddr);
                if (callerCsa == null) {
                    prevCallstackItem.getCallStackUnit().setAddr(prevSelfAddr);
                } else {
                    userCallstack.set(size - 1, new CallStackItem(callerCsa, prevCallstackItem.getStartTime()));
                }
            }
            int i = size - 1;
            while (i >= 0) {
                callstackData.addAddr(userCallstack.get(i).getCallStackUnit().getAddr());
                --i;
            }
            this.offerCallStackData(callstackData);
            this.getCallStackDataBySeqMap().put(seq, callstackData);
            seqByTimeMap.put(time, seq);
        } else {
            Logger.debug((Object)"makeUserCallstack : EXIT self is not the same as top of user callstack");
        }
        String apiName = Global.getFunctionName(log.getApiId());
        if (apiName.equals("main")) {
            ProcessInformation process = Global.getProject().getProcessInformation(log.getPid());
            process.setDropLog(true);
        }
    }

    public void makeCallstackWithoutBacktrace(LogData inputData) {
        List<Long> addrsFromUserCallStack;
        if (!(inputData instanceof ProbeCommonData)) {
            Logger.warning((Object)"failed to make callstack : log is not probe log");
            return;
        }
        ProbeCommonData log = (ProbeCommonData)inputData;
        int pid = log.getPid();
        long time = log.getTime();
        Map<Long, CallStackUnit> addrMap = this.getCallStackApiAddrByPidMap(pid);
        long seq = log.getSeq();
        int tid = log.getTid();
        long callerAddr = log.getCallerPcAddr();
        if (callerAddr < 0L) {
            CallStackData callstackData = new CallStackData(seq);
            this.offerCallStackData(callstackData);
            this.getCallStackDataBySeqMap().put(seq, callstackData);
            return;
        }
        long userCallstackSeq = this.getSeqOfUserCallstackForTime(tid, time);
        ArrayList<Long> addrs = new ArrayList<Long>();
        int size = 0;
        if (-1L != userCallstackSeq && (addrsFromUserCallStack = this.getCallstackAddrListFromSeq(userCallstackSeq)) != null) {
            addrs.addAll(addrsFromUserCallStack);
            size = addrs.size();
        }
        CallStackData callstackData = new CallStackData(seq);
        if (size == 0 || !this.isAddrInBinaryRange(pid, time, callerAddr)) {
            CallStackUnit callbackApi = addrMap.get(0L);
            if (callbackApi == null) {
                callbackApi = new CallStackUnit(0L, "(~~ internal library ~~", log);
                addrMap.put(0L, callbackApi);
            }
            addrs.add(0, 0L);
        } else {
            String strCallerSymbol;
            CallStackUnit callerCallstackUnit = addrMap.get(callerAddr);
            if (callerCallstackUnit == null && (strCallerSymbol = this.getCallStackSymbol(callerAddr, pid, time)) != null) {
                callerCallstackUnit = new CallStackUnit(callerAddr, strCallerSymbol, inputData);
                CallStackUnit topUserCallstack = addrMap.get(addrs.get(0));
                if (callerCallstackUnit.getFunctionId() == topUserCallstack.getFunctionId()) {
                    callerCallstackUnit.setFunctionStartAddr(topUserCallstack.getFunctionStartAddr());
                }
                addrMap.put(callerAddr, callerCallstackUnit);
            }
            CallStackUnit topUserCallstack = addrMap.get(addrs.get(0));
            if (callerCallstackUnit.getFunctionId() == topUserCallstack.getFunctionId()) {
                addrs.set(0, callerAddr);
            } else {
                Logger.debug((Object)"probe caller is not the same as top of user callstack");
            }
        }
        size = addrs.size();
        int i = 0;
        while (i < size) {
            callstackData.addAddr((Long)addrs.get(i));
            ++i;
        }
        this.offerCallStackData(callstackData);
        this.getCallStackDataBySeqMap().put(seq, callstackData);
    }

    @Override
    public long getSeqOfUserCallstackForTime(int tid, long time) {
        Long callstackTime;
        NavigableMap<Long, Long> seqByTimeMap = this.getSeqTimeByTidMap(tid, false);
        if (seqByTimeMap != null && (callstackTime = seqByTimeMap.floorKey(time)) != null) {
            return (Long)seqByTimeMap.get(callstackTime);
        }
        return -1L;
    }

    public List<Long> getCallstackAddrListFromSeq(long seq) {
        ArrayList<Long> addrs = new ArrayList<Long>();
        CallStackData csd = (CallStackData)this.getCallStackDataBySeqMap().get(seq);
        if (csd == null) {
            List<List<Object>> callStackAddrs = CallStackInserter.getInstance().getCallStackDataTable().getCallStackAddrsFromDB(seq);
            if (callStackAddrs == null || callStackAddrs.size() == 0 || callStackAddrs.get(0) == null) {
                Logger.debug((Object)("CallStackData is not found for seq : " + seq));
                return null;
            }
            List addressList = (List)callStackAddrs.get(0).get(0);
            addrs.addAll(addressList);
        } else {
            addrs.addAll(csd.getAddrs());
        }
        return addrs;
    }

    public List<List<Long>> getArrayOfAddrListFromSeq(List<Long> seqs) {
        ArrayList<List<Long>> addrsList = null;
        if (seqs == null) {
            return null;
        }
        addrsList = new ArrayList<List<Long>>();
        int size = seqs.size();
        int i = 0;
        while (i < size) {
            List<Long> addrs = this.getCallstackAddrListFromSeq(seqs.get(i));
            if (addrs != null) {
                addrsList.add(addrs);
            }
            ++i;
        }
        return addrsList;
    }

    public boolean isPieBuild(int pid, long time) {
        ProcessMemoryMap pmap = Global.getProject().getProcessInformation(pid).getProcessMemoryMap(time);
        if (pmap == null) {
            return false;
        }
        LibraryObject obj = pmap.getMainbinary();
        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(obj.getBinaryID());
        return binInfo != null && binInfo.getType() == 1;
    }

    public void save() {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        Collection mapset = this.callstackApiAddrByPidMap.values();
        for (Map map : mapset) {
            Collection units = map.values();
            for (CallStackUnit unit : units) {
                ArrayList<Number> data = new ArrayList<Number>();
                data.add(unit.getPid());
                data.add(unit.getFunctionId());
                data.add(unit.getBinaryID());
                data.add(unit.getAddr());
                insertData.add(data);
            }
        }
        if (insertData.size() > 0) {
            CallStackInserter.getInstance().getCallStackUnitTable().insertData(insertData);
        }
    }

    public void open() {
        List<List<Object>> callStackUnits = CallStackInserter.getInstance().getCallStackUnitTable().selectAllColumnData(null);
        int size = callStackUnits.size();
        int i = 0;
        while (i < size) {
            List<Object> callStackUnit = callStackUnits.get(i);
            int pid = (Integer)callStackUnit.get(CallStackUnitDBTable.COLUMN.PID.index);
            int functionId = (Integer)callStackUnit.get(CallStackUnitDBTable.COLUMN.FUNCTION_ID.index);
            int binaryId = (Integer)callStackUnit.get(CallStackUnitDBTable.COLUMN.BINARY_ID.index);
            long addr = (Long)callStackUnit.get(CallStackUnitDBTable.COLUMN.PC_ADDRESS.index);
            CallStackUnit csa = new CallStackUnit(addr, pid, functionId, binaryId);
            this.getCallStackApiAddrByPidMap(pid).put(addr, csa);
            ++i;
        }
        List<List<Object>> callStackData = CallStackInserter.getInstance().getCallStackDataTable().selectAllColumnData(null);
        int i2 = 0;
        while (i2 < callStackData.size()) {
            List<Object> csdata = callStackData.get(i2);
            long seq = (Long)csdata.get(CallStackDataDBTable.COLUMN.SEQUENCE_NUMBER.index);
            List addrs = (List)csdata.get(CallStackDataDBTable.COLUMN.ADDRESS_ARRAY.index);
            CallStackData csd = new CallStackData(seq, addrs);
            this.getCallStackDataBySeqMap().put(seq, csd);
            ++i2;
        }
    }
}

