/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmImageProperties
extends HierarchyUIObjectProperties {
    private boolean editable;
    private boolean animatedPlay;
    private boolean smooth;
    private boolean noScale;
    private boolean animated;
    private boolean aspectFixed;
    private String orient;
    private boolean fillOutside;
    private boolean upResizable;
    private boolean downResizable;
    private boolean animatedAvailable;
    private int[] size = new int[2];

    public ElmImageProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.editable = parser.getBoolean();
        this.animatedPlay = parser.getBoolean();
        this.smooth = parser.getBoolean();
        this.noScale = parser.getBoolean();
        this.animated = parser.getBoolean();
        this.aspectFixed = parser.getBoolean();
        this.orient = this.getOrientMessage(parser.getChar());
        this.fillOutside = parser.getBoolean();
        this.upResizable = parser.getBoolean();
        this.downResizable = parser.getBoolean();
        this.animatedAvailable = parser.getBoolean();
        this.size[0] = parser.getInt();
        this.size[1] = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("editable", Boolean.toString(this.editable)));
        properties.add(new PropertyValue("size", "[" + this.size[0] + ", " + this.size[1] + "]"));
        properties.add(new PropertyValue("upResizable", Boolean.toString(this.upResizable)));
        properties.add(new PropertyValue("downResizable", Boolean.toString(this.downResizable)));
        properties.add(new PropertyValue("orient", this.orient));
        properties.add(new PropertyValue("smooth", Boolean.toString(this.smooth)));
        properties.add(new PropertyValue("noScale", Boolean.toString(this.noScale)));
        properties.add(new PropertyValue("aspectFixed", Boolean.toString(this.aspectFixed)));
        properties.add(new PropertyValue("fillOutside", Boolean.toString(this.fillOutside)));
        properties.add(new PropertyValue("animated", Boolean.toString(this.animated)));
        properties.add(new PropertyValue("animatedAvailable", Boolean.toString(this.animatedAvailable)));
        properties.add(new PropertyValue("animatedPlay", Boolean.toString(this.animatedPlay)));
        return properties;
    }

    private String getOrientMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_IMAGE_ORIENT_NONE";
            }
            case 1: {
                return "ELM_IMAGE_ORIENT_0";
            }
            case 2: {
                return "ELM_IMAGE_ROTATE_90";
            }
            case 3: {
                return "ELM_IMAGE_ORIENT_90";
            }
            case 4: {
                return "ELM_IMAGE_ROTATE_180";
            }
            case 5: {
                return "ELM_IMAGE_ORIENT_180";
            }
            case 6: {
                return "ELM_IMAGE_ROTATE_270";
            }
            case 7: {
                return "ELM_IMAGE_ORIENT_270";
            }
            case 8: {
                return "ELM_IMAGE_FLIP_HORIZONTAL";
            }
            case 9: {
                return "ELM_IMAGE_FLIP_VERTICAL";
            }
            case 10: {
                return "ELM_IMAGE_FLIP_TRANSPOSE";
            }
            case 11: {
                return "ELM_IMAGE_FLIP_TRANSVERSE";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

