/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.overview.HierarchyScaledGraphics;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;

public class HierarchyTreeNodeFigure
extends Figure {
    private static final int NODE_WIDTH = 104;
    private static final int NODE_HEIGHT = 58;
    private static final int TYPE_MARGIN = 9;
    private static final int TYPE_HEIGHT = 25;
    private static final int RENDER_HEIGHT = 16;
    private static final int RENDER_MARGIN = 3;
    private static final int ARC = 12;
    private boolean isSelected = false;
    private boolean isHovered = false;
    private boolean isSearched = false;
    private boolean hidden;
    private HierarchyUIObject uiObject;

    public HierarchyTreeNodeFigure(HierarchyUIObject uiObject) {
        this(uiObject, false);
    }

    public HierarchyTreeNodeFigure(HierarchyUIObject uiObject, boolean hidden) {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.uiObject = uiObject;
        this.hidden = hidden;
        this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                HierarchyTreeNodeFigure.this.setHovered(true);
            }

            public void mouseExited(MouseEvent me) {
                HierarchyTreeNodeFigure.this.setHovered(false);
            }
        });
    }

    public HierarchyUIObject getUIObject() {
        return this.uiObject;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.repaint();
    }

    public void setHovered(boolean isHovered) {
        this.isHovered = isHovered;
        this.repaint();
    }

    public void setSearched(boolean isSearched) {
        this.isSearched = isSearched;
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected void paintFigure(Graphics graphics) {
        boolean isOverview = graphics instanceof HierarchyScaledGraphics;
        Rectangle tempRect = this.getBounds();
        int arc = HierarchyZoomManager.INSTANCE.getScaled(12);
        int x = tempRect.x;
        int y = tempRect.y;
        int w = tempRect.width;
        int h = tempRect.height;
        if (isOverview) {
            if (this.isSelected) {
                graphics.setBackgroundColor(ColorResources.TREEVIEW_NODE_SELECT_OUTLINE);
                graphics.setForegroundColor(ColorResources.TREEVIEW_NODE_SELECT_OUTLINE);
            } else if (this.isSearched) {
                graphics.setBackgroundColor(ColorResources.TREEVIEW_SEARCH_NODE_BG_START);
                graphics.setForegroundColor(ColorResources.TREEVIEW_SEARCH_NODE_BG_END);
            } else {
                graphics.setBackgroundColor(ColorResources.TREEVIEW_NORMAL_NODE_BG_START);
                graphics.setForegroundColor(ColorResources.TREEVIEW_NORMAL_NODE_BG_END);
            }
        } else if (this.isSearched) {
            graphics.setBackgroundColor(ColorResources.TREEVIEW_SEARCH_NODE_BG_START);
            graphics.setForegroundColor(ColorResources.TREEVIEW_SEARCH_NODE_BG_END);
        } else {
            graphics.setBackgroundColor(ColorResources.TREEVIEW_NORMAL_NODE_BG_START);
            graphics.setForegroundColor(ColorResources.TREEVIEW_NORMAL_NODE_BG_END);
        }
        Path path = new Path((Device)Display.getCurrent());
        path.moveTo((float)x, (float)(y + arc));
        path.lineTo((float)x, (float)(y + h - arc));
        path.addArc((float)x, (float)(y + h - 2 * arc), (float)(2 * arc), (float)(2 * arc), 180.0f, 90.0f);
        path.lineTo((float)(x + w - arc), (float)(y + h));
        path.addArc((float)(x + w - 2 * arc), (float)(y + h - 2 * arc), (float)(2 * arc), (float)(2 * arc), -90.0f, 90.0f);
        path.lineTo((float)(x + w), (float)(y + arc));
        path.addArc((float)(x + w - 2 * arc), (float)y, (float)(2 * arc), (float)(2 * arc), 0.0f, 90.0f);
        path.lineTo((float)(x + arc), (float)y);
        path.addArc((float)x, (float)y, (float)(2 * arc), (float)(2 * arc), 90.0f, 90.0f);
        graphics.clipPath(path);
        graphics.fillGradient(tempRect, true);
        if (isOverview) {
            graphics.restoreState();
            return;
        }
        Rectangle rect = this.getBounds();
        int xr = rect.x;
        int yr = rect.y;
        int wr = rect.width - 1;
        int hr = rect.height - 1;
        if (this.isSelected) {
            graphics.setForegroundColor(ColorResources.TREEVIEW_NODE_SELECT_OUTLINE);
        } else if (this.isHovered) {
            graphics.setForegroundColor(ColorResources.TREEVIEW_NODE_HOVER_OUTLINE);
        } else {
            graphics.setForegroundColor(ColorResources.TREEVIEW_NODE_NORMAL_OUTLINE);
        }
        graphics.setAntialias(1);
        graphics.drawRoundRectangle(new Rectangle(xr, yr, wr, hr), arc * 2, arc * 2);
        String typeName = this.uiObject.getTypeName();
        HierarchyUIObject.RENDER_SPEED_GRADE renderGrade = this.uiObject.getRenderSpeedGrade();
        String renderTime = String.valueOf(String.format("%.2f", this.uiObject.getRenderTime())) + " ms";
        graphics.setForegroundColor(ColorResources.TREEVIEW_NODE_TYPE_NAME);
        FontData[] fontData = FontResources.UIHIERARCHY_TREE_NODE_TYPE_FONT.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(HierarchyZoomManager.INSTANCE.getScaled(fontData[i].getHeight()));
            ++i;
        }
        int typeMargin = HierarchyZoomManager.INSTANCE.getScaled(9);
        int typeHeight = HierarchyZoomManager.INSTANCE.getScaled(25);
        Font font = new Font((Device)Display.getCurrent(), fontData);
        graphics.setFont(font);
        Dimension textExtent = TextUtilities.INSTANCE.getStringExtents(typeName, font);
        while (textExtent.width > wr) {
            boolean breakFlag = false;
            int i2 = 0;
            while (i2 < fontData.length) {
                int height = fontData[i2].getHeight() - 1;
                if (height <= 0) {
                    breakFlag = true;
                    break;
                }
                fontData[i2].setHeight(height);
                ++i2;
            }
            if (breakFlag) break;
            font.dispose();
            font = new Font((Device)Display.getCurrent(), fontData);
            graphics.setFont(font);
            textExtent = TextUtilities.INSTANCE.getStringExtents(typeName, font);
        }
        int tx = xr + (wr - textExtent.width) / 2;
        int ty = 0;
        ty = renderGrade == HierarchyUIObject.RENDER_SPEED_GRADE.NO_MEASURE ? yr + (hr - textExtent.height) / 2 : yr + typeMargin + (typeHeight - textExtent.height) / 2;
        graphics.drawText(typeName, tx, ty);
        font.dispose();
        if (renderGrade != HierarchyUIObject.RENDER_SPEED_GRADE.NO_MEASURE) {
            Image renderImg = ImageResources.RENDERING_GREEN;
            switch (renderGrade) {
                case SLOWER: {
                    renderImg = ImageResources.RENDERING_YELLOW;
                    break;
                }
                case SLOWEST: {
                    renderImg = ImageResources.RENDERING_RED;
                    break;
                }
            }
            int imgWidth = HierarchyZoomManager.INSTANCE.getScaled(renderImg.getBounds().width);
            int imgHeight = HierarchyZoomManager.INSTANCE.getScaled(renderImg.getBounds().height);
            int renderHeight = HierarchyZoomManager.INSTANCE.getScaled(16);
            int renderMargin = HierarchyZoomManager.INSTANCE.getScaled(3);
            fontData = FontResources.UIHIERARCHY_TREE_NODE_RENDER_FONT.getFontData();
            int i3 = 0;
            while (i3 < fontData.length) {
                fontData[i3].setHeight(HierarchyZoomManager.INSTANCE.getScaled(fontData[i3].getHeight()));
                ++i3;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            graphics.setFont(font);
            textExtent = TextUtilities.INSTANCE.getStringExtents(renderTime, font);
            tx = xr + (wr - (imgWidth + renderMargin + textExtent.width)) / 2;
            ty = yr + typeMargin + typeHeight + (renderHeight - imgHeight) / 2;
            graphics.drawImage(renderImg, 0, 0, renderImg.getBounds().width, renderImg.getBounds().height, tx, ty, imgWidth, imgHeight);
            ty = yr + typeMargin + typeHeight + (renderHeight - textExtent.height) / 2;
            graphics.setForegroundColor(ColorResources.TREEVIEW_NODE_RENDER_TIME);
            graphics.drawText(renderTime, tx += imgWidth + renderMargin, ty);
            font.dispose();
        }
        graphics.restoreState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.hidden) {
            return new Dimension(0, 0);
        }
        int nodeWidth = HierarchyZoomManager.INSTANCE.getScaled(104);
        int nodeHeight = HierarchyZoomManager.INSTANCE.getScaled(58);
        return new Dimension(nodeWidth, nodeHeight);
    }
}

