/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.util.Logger;

public class CallStackUnit {
    private long address;
    private long functionStartAddress;
    private String path;
    private String functionName;
    private String offset = "";
    private String etc = "";
    private int pid;
    private long time;
    private int functionID;
    private int binaryID;

    public CallStackUnit(long addr, String symbol, LogData log) {
        this.address = addr;
        this.functionStartAddress = addr;
        this.time = log.getTime();
        this.pid = log.getPid();
        this.functionID = -2;
        this.functionName = "";
        this.makeCallstackData(symbol);
    }

    public CallStackUnit(long addr, String symbol, int functionId, LogData log) {
        this.address = addr;
        this.functionStartAddress = addr;
        this.time = log.getTime();
        this.pid = log.getPid();
        this.functionID = functionId;
        this.functionName = "";
        this.makeCallstackData(symbol);
    }

    public CallStackUnit(long addr, int pid, int functionId, int binaryID) {
        this.address = addr;
        this.functionStartAddress = addr;
        this.time = -1L;
        this.pid = pid;
        this.functionID = functionId;
        this.functionName = Global.getFunctionName(functionId);
        this.binaryID = binaryID;
        BinaryInfo bInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binaryID);
        this.path = bInfo.getTargetBinaryPath();
    }

    private void makeCallstackData(String symbol) {
        String[] splitPath = symbol.split("\\(", 2);
        this.path = splitPath[0];
        if (!(this.path.startsWith("/") || this.path.contains(FunctionUsageProfiler.APPLICATION) || this.path.contains(FunctionUsageProfiler.DEPENDENT_LIB))) {
            this.path = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_LIBRARY;
        }
        BinaryInfo bInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(this.path);
        this.binaryID = bInfo.getID();
        if (splitPath.length < 2) {
            if (!splitPath[0].equals(FunctionUsageProfiler.APPLICATION) && !splitPath[0].equals(FunctionUsageProfiler.DEPENDENT_LIB)) {
                Logger.error((Object)"Invalid function name for calltrace unit\n");
            }
            this.functionName = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION;
        } else {
            String[] splitFunc = splitPath[1].split("\\+");
            if (splitFunc.length != 0) {
                this.functionName = splitFunc[0].isEmpty() ? InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION : splitFunc[0];
                if (this.functionID == -2) {
                    this.functionID = Global.getFunctionID(this.functionName);
                }
            }
        }
    }

    public long getAddr() {
        return this.address;
    }

    public long getFunctionStartAddr() {
        return this.functionStartAddress;
    }

    public String getSymbol() {
        return String.valueOf(this.path) + "(" + this.functionName;
    }

    public void setAddr(long addr) {
        this.address = addr;
    }

    public void setFunctionStartAddr(long addr) {
        this.functionStartAddress = addr;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getFunctionId() {
        return this.functionID;
    }

    public String getOffset() {
        return this.offset;
    }

    public String getEtc() {
        return this.etc;
    }

    public String getPath() {
        return this.path;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getBinaryID() {
        return this.binaryID;
    }
}

