/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ImageViewer;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.graph.bar.FourBarGraph;
import org.tizen.dynamicanalyzer.widgets.graph.circular.CircularGraph;

public class ScreenshotView
extends DAViewComposite {
    private final int SCREENSHOT_SIZE = 218;
    public static final int SELECTION_MARKER_INDEX = 0;
    ImageViewer screenshot;
    CircularGraph processGraph;
    FourBarGraph cpuGrp;
    private String[] observingViews = null;
    private Composite bottomComp = null;
    private static List<Long> cpuUsage;
    private static long maxCpuUsage;
    private static long maxMem;
    private static long processMem;
    private long startTime = 0L;
    private long lastStartTime = 0L;
    private long selectTime = -1L;
    private String pageID = null;
    private DACustomButton latestButton = null;
    private ScreenshotDataManager dataManager = ScreenshotDataManager.getInstance();

    static {
        maxCpuUsage = 100L;
        maxMem = 100L;
        processMem = 0L;
    }

    public ScreenshotView(Composite parent, int style, boolean title, String page) {
        super(parent, style, title);
        this.pageID = page;
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InformationViewLabels.SNAPSHOT_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.VIEW_BG_COLOR);
        contents.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                FormData data = (FormData)ScreenshotView.this.screenshot.getLayoutData();
                data.left = new FormAttachment(50, -109);
                data = (FormData)ScreenshotView.this.bottomComp.getLayoutData();
                data.left = new FormAttachment(50, -109);
                data.right = new FormAttachment(50, 109);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.screenshot = new ImageViewer(contents, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.left = new FormAttachment(0, 0);
        data.width = 218;
        data.height = 218;
        this.screenshot.setLayoutData(data);
        this.screenshot.setEnable(true);
        this.bottomComp = new Composite(contents, 0);
        this.bottomComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)this.screenshot, 3);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 90;
        this.bottomComp.setLayoutData((Object)data);
        Composite processComp = new Composite(this.bottomComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.width = 90;
        data.height = 90;
        processComp.setLayoutData((Object)data);
        processComp.setBackground(ColorResources.WHITE);
        processComp.setLayout((Layout)new FillLayout());
        this.processGraph = new CircularGraph(processComp, 0, 1);
        this.processGraph.setGraphBgColor(ColorResources.PROCESS_GRAPH_BG_COLOR);
        this.processGraph.setGraphColor(ColorResources.PROCESS_GRAPH_COLOR);
        this.processGraph.setCenterColor(ColorResources.PROCESS_GRAPH_CENTER_COLOR);
        this.processGraph.setMeasure(InformationViewLabels.SNAPSHOT_VIEW_BYTE);
        this.processGraph.setGraphColor(ColorResources.PROCESS_GRAPH_COLOR);
        this.processGraph.update(maxMem, processMem);
        this.processGraph.setTextColor(ColorResources.PROCESS_GRAPH_COLOR);
        this.processGraph.setText(InformationViewLabels.SNAPSHOT_VIEW_PROCESS);
        this.processGraph.setLabelBg(ColorResources.VIEW_BG_COLOR);
        this.processGraph.setLabelFont(FontResources.CIRCULAR_LABEL_FONT);
        this.processGraph.setMeasureFont(FontResources.CIRCULAR_GRAPH_MEASURE_FONT);
        this.processGraph.setValueFont(FontResources.CIRCULAR_GRAPH_VALUE_FONT);
        this.cpuGrp = new FourBarGraph(this.bottomComp, 0, FourBarGraph.TYPE_PERCENT);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)processComp, -3);
        data.width = 90;
        data.height = 90;
        this.cpuGrp.setLayoutData((Object)data);
        this.cpuGrp.setBgColor(ColorResources.CPU_BAR_GRAPH_BG_COLOR);
        this.cpuGrp.setTextBgColor(ColorResources.VIEW_BG_COLOR);
        this.cpuGrp.setGraphColor(ColorResources.CPU_BAR_GRAPH_COLOR, ColorResources.CPU_BAR_GRAPH_GRAY_COLOR, ColorResources.CPU_BAR_GRAPH_COLOR);
        this.cpuGrp.setTextColor(ColorResources.CPU_BAR_GRAPH_COLOR);
        this.cpuGrp.setText(InformationViewLabels.SNAPSHOT_VIEW_CPU);
        cpuUsage = new ArrayList<Long>();
        this.cpuGrp.setFont(FontResources.BAR_GRAPH_LABEL_FONT);
        this.cpuGrp.setGraphFont(FontResources.BAR_GRAPH_FONT);
        Composite emptyComp = new Composite(this.bottomComp, 0);
        emptyComp.setLayout((Layout)new FormLayout());
        emptyComp.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.cpuGrp, -3);
        data.left = new FormAttachment(0, 0);
        data.height = 90;
        emptyComp.setLayoutData((Object)data);
        emptyComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getBounds();
                e.gc.setBackground(ColorResources.VIEW_BG_COLOR);
                e.gc.fillRectangle(rect.x, 75, rect.width, 15);
                String latest = InformationViewLabels.SNAPSHOT_VIEW_LATEST;
                e.gc.setFont(FontResources.LOCK_LABEL_FONT);
                Point strSize = e.gc.textExtent(latest, 8);
                e.gc.setForeground(ColorResources.SNAPSHOT_VIEW_LOCK_TEXT);
                e.gc.drawText(latest, (rect.width - strSize.x) / 2, 78);
            }
        });
        this.latestButton = new DACustomButton(emptyComp, ImageResources.LATEST_SNAPSHOT_NORMAL, ImageResources.LATEST_SNAPSHOT_PUSH, ImageResources.LATEST_SNAPSHOT_HOVER, ImageResources.LATEST_SNAPSHOT_DISABLE);
        this.setLatestMode(true);
        this.latestButton.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.height = 65;
        this.latestButton.setLayoutData((Object)data);
        this.latestButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                ScreenshotView.this.setLatestMode(true);
                long selStartTime = Toolbar.INSTANCE.getTime();
                ScreenshotView.this.setSelectTime(selStartTime);
                ScreenshotView.this.setStartTime(selStartTime);
                ScreenshotView.this.updateView(false);
                DASelectionData selData = new DASelectionData(TimelineTableView.screenshotViewID, selStartTime, Toolbar.INSTANCE.getTime(), null, (Control)ScreenshotView.this.latestButton);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                ScreenshotView.this.updateView();
            }
        });
        this.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                ScreenshotView.this.setSelectTime(-1L);
            }
        });
        this.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (ScreenshotView.this.latestButton.isButtonEnabled()) {
                    ScreenshotView.this.setTimeFromObservingView(false);
                } else if (DAState.isRunning()) {
                    ScreenshotView.this.setStartTime(ScreenshotView.this.lastStartTime);
                } else {
                    ScreenshotView.this.setTimeFromObservingView(true);
                }
            }
        });
        DataManagerRegistry.registerPageDataManager(this.dataManager);
    }

    public void setObservingViews(String[] viewIds) {
        this.observingViews = viewIds;
    }

    public String[] getObservingViews() {
        return this.observingViews;
    }

    private void computeData() {
        Object[] cpuLoadList = TimelineDataManager.getInstance().getCPULoadFromDB(this.startTime);
        if (cpuLoadList == null) {
            return;
        }
        cpuUsage.clear();
        int i = 0;
        while (i < cpuLoadList.length) {
            double cpu = (Double)cpuLoadList[i];
            long value = (long)cpu;
            cpuUsage.add(value);
            ++i;
        }
        Project project = Global.getProject();
        maxMem = project.getDeviceStatusInfo().getSystemMemorySize();
        processMem = TimelineDataManager.getInstance().getProcessMemoriesFromDB(this.startTime);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            if (selData.getViewID() == null || selData.getViewID().isEmpty() || selData.getViewID().equals(GLPage.chartViewID)) {
                return;
            }
            this.setLatestMode(false);
            long selStartTime = selData.getStartTime();
            if (selData.getViewID().equals(TimelineTableView.imageViewerID)) {
                if (selStartTime < 0L) {
                    selStartTime = 0L;
                }
                this.setSelectTime(selStartTime);
                this.setStartTime(this.selectTime);
                this.updateView(false);
            } else {
                this.setSelectTime(selStartTime);
                this.setStartTime(this.selectTime);
                this.updateView(true);
            }
        }
    }

    private void updateView(final boolean isSnapshot) {
        this.computeData();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ScreenshotView.this.processGraph.update(maxMem, processMem);
                ScreenshotView.this.cpuGrp.setMaxSize(maxCpuUsage);
                ScreenshotView.this.cpuGrp.setCurrentValue(cpuUsage);
                if (isSnapshot) {
                    ScreenshotView.this.screenshot.drawSnapshot(ScreenshotView.this.startTime);
                }
            }
        });
    }

    public void updateView() {
        if (!DAState.isRunning() && this.latestButton.isButtonEnabled()) {
            this.latestButton.setButtonEnabled(false);
        } else if (this.latestButton.isButtonEnabled()) {
            this.setStartTime(this.selectTime);
        } else {
            this.updateFromDataManager();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ScreenshotView.this.processGraph.update(maxMem, processMem);
                ScreenshotView.this.cpuGrp.setMaxSize(maxCpuUsage);
                ScreenshotView.this.cpuGrp.setCurrentValue(cpuUsage);
                ScreenshotView.this.screenshot.drawSnapshot(ScreenshotView.this.startTime);
            }
        });
    }

    private void setTimeFromObservingView(boolean isStartTime) {
        if (this.observingViews == null) {
            return;
        }
        int size = this.observingViews.length;
        int i = 0;
        while (i < size) {
            block14: {
                GridItem[] selection;
                LogData startData;
                Grid table;
                block16: {
                    Control control;
                    block17: {
                        block15: {
                            block13: {
                                DAViewComposite view = (DAViewComposite)AnalyzerManager.getCurrentPage().getView(this.observingViews[i]);
                                if (view == null) {
                                    Logger.warning((Object)"view is null.");
                                    return;
                                }
                                control = view.getControl();
                                table = null;
                                if (!(control instanceof DAChartBoard)) break block13;
                                DAChartBoard board = (DAChartBoard)control;
                                long time = (long)(((DAChartPlotIntervalMarker)board.getMarkers().get(0)).getStartVal() * 1000000.0);
                                if (time >= 0L) {
                                    if (isStartTime) {
                                        this.setStartTime(time);
                                    } else {
                                        this.setSelectTime(time);
                                    }
                                    return;
                                }
                                break block14;
                            }
                            if (!(control instanceof DATableComposite)) break block15;
                            table = ((DATableComposite)control).getTable();
                            break block16;
                        }
                        if (!(control instanceof DAWindowingTableComposite)) break block17;
                        table = ((DAWindowingTableComposite)control).getTable();
                        break block16;
                    }
                    if (!(control instanceof DATreeComposite)) break block14;
                    table = ((DATreeComposite)control).getTable();
                }
                if (table.getSelectionCount() > 0 && (startData = ((DATableDataFormat)(selection = table.getSelection())[0].getData()).getLogData()) != null) {
                    long time = startData.getTime();
                    if (isStartTime) {
                        this.setStartTime(time);
                    } else {
                        this.setSelectTime(time);
                    }
                }
            }
            ++i;
        }
    }

    private void updateFromDataManager() {
        if (this.dataManager.isThreadAlive()) {
            List<Long> cpuRates = this.dataManager.getLastCpuRate();
            int size = cpuRates.size();
            cpuUsage.clear();
            int i = 0;
            while (i < size) {
                cpuUsage.add(cpuRates.get(i));
                ++i;
            }
            Project project = Global.getProject();
            if (project != null) {
                maxMem = project.getDeviceStatusInfo().getSystemMemorySize();
            }
            processMem = this.dataManager.getLastProcessMemory();
            this.lastStartTime = this.dataManager.getLastStartTime();
            this.setStartTime(this.lastStartTime);
        }
    }

    public void clear() {
        this.dataManager.clear();
        cpuUsage.clear();
        maxMem = 100L;
        processMem = 0L;
        this.cpuGrp.clear();
        this.updateView(true);
    }

    public void setStartTime(long start) {
        this.startTime = start;
    }

    private void setSelectTime(long time) {
        this.selectTime = time;
    }

    public boolean isLatestMode() {
        return !this.latestButton.isButtonEnabled();
    }

    public void setLatestMode(boolean isOn) {
        if (DAState.isRunning()) {
            this.latestButton.setButtonEnabled(!isOn);
        } else {
            this.latestButton.setButtonEnabled(false);
        }
    }
}

