/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;

public class MemoryMapTable
extends DATreeComposite {
    int keyindex = 0;

    public MemoryMapTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.setTableName(MemoryPageLabels.MEMORY_MAP_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setTree(true);
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.setSortTypes(nArray);
        this.setColumnAlignment(new int[]{16384, 0x1000000, 131072, 131072, 131072, 16384});
        this.setColumns(new String[]{MemoryPageLabels.MEMORY_MEMORYMAP_LIBNAME, MemoryPageLabels.MEMORY_MEMORYMAP_TYPE, MemoryPageLabels.MEMORY_MEMORYMAP_SIZE, MemoryPageLabels.MEMORY_MEMORYMAP_ADDRESS_LOW, MemoryPageLabels.MEMORY_MEMORYMAP_ADDRESS_HIGH, ""});
        int[] columnSizes = new int[]{150, 40, 60, 80, 80, 5};
        this.setColumnSize(columnSizes);
        this.setColumnVisibility(new boolean[]{true, true, true, true, true, true});
        this.setTableToolTipEnable(false);
        this.comparator.setType(1);
        this.comparator.setColumn(3);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, columnSizes));
    }

    private List<Integer> getPidList() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            result.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                result.add(pids[i]);
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        this.keyindex = 0;
        Project project = Global.getProject();
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        if (project == null) {
            return output;
        }
        List<Integer> pidList = this.getPidList();
        for (Integer pid : pidList) {
            TreeInput parentInput = this.makeProcessHeaderTreeInput(pid);
            ProcessMemoryMap pmap = project.getProcessInformation(pid).getLastProcessMemoryMap();
            Map<Integer, LibraryObject> binarymap = pmap.getAllLibraryID();
            for (Map.Entry<Integer, LibraryObject> entry : binarymap.entrySet()) {
                int binId = entry.getKey();
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(binId).getTargetBinaryPath();
                TreeInput mapInput = this.makeMapEntryTreeInput(binPath, entry.getValue());
                parentInput.addChild(mapInput);
            }
            output.add(parentInput);
        }
        return output;
    }

    private TreeInput makeProcessHeaderTreeInput(int pid) {
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        String headerCaption = String.format("PID #%d", pid);
        text.add(headerCaption);
        data.add(pid);
        text.add("");
        data.add("");
        int i = 2;
        while (i < this.columnNames.length) {
            text.add("");
            data.add(new Long(0L));
            ++i;
        }
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.setData(data);
        tableData.setObject(headerCaption);
        output.setData(tableData);
        return output;
    }

    private TreeInput makeMapEntryTreeInput(String binPath, LibraryObject libObj) {
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        Long Low = libObj.getLowestAddress();
        Long High = libObj.getHighestAddress();
        Long size = High - Low;
        text.add(binPath);
        data.add(binPath);
        text.add("r-x-");
        data.add("r-x-");
        text.add(Long.toString(size));
        data.add(size);
        text.add("0x" + Long.toHexString(Low));
        data.add(Low);
        text.add("0x" + Long.toHexString(High));
        data.add(High);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.setData(data);
        tableData.setObject(binPath);
        output.setData(tableData);
        return output;
    }
}

