/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenShotDBTable;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class ScreenshotChart
extends TimelineChart {
    public static ScreenshotChart instance = null;
    private DAChartSeries screenshotSeries;
    private Map<String, Image> imageMap = new ConcurrentHashMap<String, Image>();

    public ScreenshotChart(String pageID) {
        super(pageID);
        this.chartType = -108;
        this.chartStyle = 1;
        this.probeType = 262;
        this.chartName = TimelineChartLabels.SCREENSHOT_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.SCREENSHOT_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_SNAPSHOT_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_SNAPSHOT_SMALL_NOR;
        this.screenshotSeries = new DAChartSeries(TimelineChartLabels.SCREENSHOT_CHART_TITLE, 17);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        item.useExpand(false);
        this.chart.addSeries(this.screenshotSeries);
        this.setChartStyle();
        return item;
    }

    @Override
    public DAChart getChart() {
        return this.chart;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.screenshotSeries.clear();
        ScreenshotDataManager.getInstance().clear();
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        List data = (List)dataList.get(0);
        try {
            int i = 0;
            while (i < data.size()) {
                block11: {
                    List row = (List)data.get(i);
                    double time = (double)((Long)row.get(ScreenShotDBTable.COLUMN.CAPTURE_TIME.ordinal())).longValue() / 1000000.0;
                    if (time != 0.0) {
                        String fileName;
                        block10: {
                            int separatorPos;
                            fileName = (String)row.get(ScreenShotDBTable.COLUMN.IMAGE_FILE_PATH.ordinal());
                            if (selectedPid > 0 && (separatorPos = fileName.indexOf(95)) > 0) {
                                String pidStr = fileName.substring(0, separatorPos);
                                try {
                                    if (Integer.parseInt(pidStr) == selectedPid) break block10;
                                    break block11;
                                }
                                catch (NumberFormatException e) {
                                    Logger.warning((Object)("Failed to parse PID: " + e.getMessage()));
                                }
                            }
                        }
                        if (Global.getProject() == null) {
                            return;
                        }
                        String imagePath = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + fileName;
                        if (this.imageMap.containsKey(imagePath)) {
                            Image image = this.imageMap.get(imagePath);
                            this.screenshotSeries.addSeriesItem(new DAChartSeriesItem(time, image, fileName));
                            ScreenshotDataManager.getInstance().addScreenshotData(image, fileName);
                        } else {
                            Thread createImageThread = new Thread(null, new CreateImageThread(imagePath, time), "small image getter thread");
                            createImageThread.start();
                        }
                    }
                }
                ++i;
            }
        }
        catch (NumberFormatException ne) {
            Logger.exception((Throwable)ne);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.imageMap.clear();
    }

    private String getFileName(String filePath) {
        String separator = "/";
        if (CommonUtil.isWin()) {
            separator = "\\\\";
        }
        String[] splited = filePath.split(separator);
        return splited[splited.length - 1];
    }

    private class CreateImageThread
    extends Thread {
        private String imagePath;
        private double time;

        private CreateImageThread(String imagePath, double time) {
            this.imagePath = imagePath;
            this.time = time;
        }

        @Override
        public void run() {
            Image image = null;
            for (int count = 0; count < 5; ++count) {
                try {
                    image = new Image((Device)Display.getDefault(), this.imagePath);
                    ScreenshotChart.this.imageMap.put(this.imagePath, image);
                }
                catch (SWTException sWTException) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                break;
            }
            if (image != null) {
                ScreenshotChart.this.screenshotSeries.addSeriesItem(new DAChartSeriesItem(this.time, image, ScreenshotChart.this.getFileName(this.imagePath)));
            }
        }
    }
}

