/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.memory.data.MemoryDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUCoreChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUFrequencyChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DeviceChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DiskIOChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.EnergyChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.NetworkIOChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ProcessMemoryChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ScreenshotChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.SystemMemoryChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.UIEventChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.UserCustomChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.IDAChartSeriesMaker;

public class TimelineChartManager
implements IDAChartSeriesMaker {
    private static TimelineChartManager instance = new TimelineChartManager();
    private static TimelineDataManager dataManager = TimelineDataManager.getInstance();
    private boolean newCustomChart = false;
    private List<TimelineChart> chartList;
    private ArrayList<TimelineChart> newChartList;
    private HashMap<String, TimelineChart> chartInstanceMapNameKey;
    private HashMap<Integer, TimelineChart> chartInstanceMapTypeKey;
    private HashMap<Integer, UserCustomChart> customChartMap;
    private DAChartBoard chartBoard = null;
    private List<String> savedChartListByFile = new ArrayList<String>();

    public static TimelineChartManager getInstance() {
        return instance;
    }

    private TimelineChartManager() {
        this.chartList = new ArrayList<TimelineChart>();
        this.newChartList = new ArrayList();
        this.chartInstanceMapNameKey = new HashMap();
        this.chartInstanceMapTypeKey = new HashMap();
        this.customChartMap = new HashMap();
        this.initChartMap(new CPUChart(TimelinePage.pageID));
        this.initChartMap(new CPUCoreChart(TimelinePage.pageID));
        this.initChartMap(new CPUFrequencyChart(TimelinePage.pageID));
        this.initChartMap(new SystemMemoryChart(TimelinePage.pageID));
        this.initChartMap(new ProcessMemoryChart(TimelinePage.pageID));
        this.initChartMap(new ScreenshotChart(TimelinePage.pageID));
        this.initChartMap(new UIEventChart(TimelinePage.pageID));
        this.initChartMap(new DiskIOChart(TimelinePage.pageID));
        this.initChartMap(new NetworkIOChart(TimelinePage.pageID));
        this.initChartMap(new DeviceChart(TimelinePage.pageID));
        this.initChartMap(new EnergyChart(TimelinePage.pageID));
        this.loadSavedChartList();
    }

    public void setChartTimelineChartBoard(DAChartBoard board) {
        this.chartBoard = board;
    }

    private void loadSavedChartList() {
        TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
        List<String> chartNameList = target.getAvailableChartList();
        int size = chartNameList.size();
        if (size > 1) {
            int i = 0;
            while (i < size) {
                TimelineChart chart = this.getChartInstance(chartNameList.get(i));
                if (chart != null) {
                    this.chartList.add(chart);
                }
                ++i;
            }
        } else {
            for (TimelineChart chart : this.chartInstanceMapNameKey.values()) {
                this.chartList.add(chart);
            }
        }
    }

    public void loadSelectedChartList(Collection<String> list) {
        if (list.size() > 0) {
            HashSet<String> actualSelectedChart = new HashSet<String>();
            ArrayList<Boolean> showInfo = new ArrayList<Boolean>();
            int i = 0;
            while (i < this.chartList.size()) {
                if (list.contains(this.chartList.get(i).getChartName())) {
                    actualSelectedChart.add(this.chartList.get(i).getChartName());
                    showInfo.add(true);
                } else {
                    showInfo.add(false);
                }
                ++i;
            }
            AnalyzerUtil.getTimelineComposite().reArrangeChart(null, showInfo);
            UILayoutDataManager.INSTANCE.setSelectedChartSet(actualSelectedChart);
        }
    }

    public void loadSelectedChartListByFile(Collection<String> list) {
        this.savedChartListByFile = new ArrayList<String>(list);
        if (list.size() > 0) {
            HashSet<String> actualSelectedChart = new HashSet<String>();
            ArrayList<Boolean> showInfo = new ArrayList<Boolean>();
            int i = 0;
            while (i < this.chartList.size()) {
                if (list.contains(this.chartList.get(i).getChartName())) {
                    actualSelectedChart.add(this.chartList.get(i).getChartName());
                    showInfo.add(true);
                } else {
                    showInfo.add(false);
                }
                ++i;
            }
            AnalyzerUtil.getTimelineComposite().reArrangeChart(null, showInfo);
            UILayoutDataManager.INSTANCE.setSelectedChartSet(actualSelectedChart);
        }
    }

    public void setChartList(List<TimelineChart> chartList) {
        this.chartList.clear();
        this.chartList.addAll(chartList);
    }

    public List<TimelineChart> getChartList() {
        return this.chartList;
    }

    private TimelineChart getChartInstance(String chartName) {
        return this.chartInstanceMapNameKey.get(chartName);
    }

    public TimelineChart getChartInstance(int chartType) {
        TimelineChart chart = this.chartInstanceMapTypeKey.get(chartType);
        if (chart == null) {
            chart = this.customChartMap.get(chartType);
        }
        return chart;
    }

    private void initChartMap(TimelineChart chart) {
        this.chartInstanceMapNameKey.put(chart.getChartName(), chart);
        this.chartInstanceMapTypeKey.put(chart.getChartType(), chart);
    }

    public void addCustomChart(UserCustomChart customChart) {
        int chartType = customChart.getChartType();
        if (!this.customChartMap.containsKey(chartType)) {
            this.customChartMap.put(chartType, customChart);
            this.chartList.add(customChart);
            if (!this.newCustomChart) {
                this.newChartList.clear();
            }
            this.newChartList.add(customChart);
            this.newCustomChart = true;
            TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.chartList.size()) {
                list.add(this.chartList.get(i).getChartName());
                ++i;
            }
            SettingDataManager.INSTANCE.writeAvailableChartList(target.getTargetName(), list);
        }
    }

    public void addNewCustomChart() {
        if (this.newCustomChart) {
            List newChartList = (List)this.newChartList.clone();
            this.newChartList.clear();
            this.newCustomChart = false;
            for (TimelineChart chart : newChartList) {
                DAChartBoardItem item = chart.createBoardItem(this.chartBoard);
                DAChart chartWidget = item.getChart();
                chartWidget.getPlot().setAxisRangeX(this.chartBoard.getVisibleStartTime(), this.chartBoard.getVisibleEndTime());
                chartWidget.getPlot().setMarkers(this.chartBoard.getMarkers());
                TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(chart.getPopupMenu(), this.chartBoard.getTimeline(), TimelinePage.pageID);
                chartWidget.addMouseListener((MouseListener)timelineChartMouseEventListener);
                chartWidget.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
                chartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.chartBoard.getTimeline()));
                UILayoutDataManager.INSTANCE.addSelectedChart(chart.getChartName());
            }
        }
        for (TimelineChart timelineChart : this.chartList) {
            if (timelineChart instanceof UserCustomChart) {
                UserCustomChart customChart = (UserCustomChart)timelineChart;
                ArrayList tempSeriesList = (ArrayList)customChart.getTempSeries().clone();
                ((UserCustomChart)timelineChart).getTempSeries().clear();
                for (DAChartSeries series : tempSeriesList) {
                    customChart.addSeries(series);
                }
            }
            timelineChart.update();
        }
    }

    public void clear() {
        if (this.chartList == null || this.chartList.size() == 0) {
            return;
        }
        for (TimelineChart timelineChart : this.chartList) {
            timelineChart.clear();
        }
        this.chartList.clear();
        this.loadSavedChartList();
        this.customChartMap.clear();
        this.savedChartListByFile.clear();
        dataManager.clear();
    }

    public void makeChartSeries(long startTime, long endTime) {
        TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
        Set<String> targetChartList = SettingDataManager.INSTANCE.getSelectedChartSet(target.getTargetName());
        targetChartList.addAll(this.getSelectedChartListByFile());
        List<List<Object>> systemDBData = dataManager.getSystemDataFromDB(startTime, endTime);
        List<List<Object>> uiEventDBData = dataManager.getUIEventDataFromDB(startTime, endTime);
        List<List<Object>> screenShotDBData = dataManager.getScreenShotDataFromDB(startTime, endTime);
        int selectedPID = 0;
        if (Toolbar.INSTANCE != null) {
            selectedPID = Toolbar.INSTANCE.getSelectedPid();
        }
        Map<Integer, List<List<Object>>> targetProcessDBData = dataManager.getTargetProcessDataFromDB(startTime, endTime, selectedPID);
        for (TimelineChart chart : this.chartList) {
            ArrayList<Object> dataList;
            if (!targetChartList.contains(chart.getChartName())) continue;
            if (chart.getChartType() == -105) {
                dataList = new ArrayList<Object>();
                targetProcessDBData = MemoryDataManager.getInstance().getTargetProcessDataMapFromDB(startTime, endTime, selectedPID);
                dataList.add(systemDBData);
                dataList.add(targetProcessDBData);
                chart.inputChartSeries(dataList);
                continue;
            }
            if (chart.getProbeType() == 5) {
                dataList = new ArrayList();
                dataList.add(systemDBData);
                dataList.add(targetProcessDBData);
                chart.inputChartSeries(dataList);
                continue;
            }
            if (chart.getProbeType() == 259) {
                dataList = new ArrayList();
                dataList.add(uiEventDBData);
                chart.inputChartSeries(dataList);
                continue;
            }
            if (chart.getProbeType() != 262) continue;
            dataList = new ArrayList();
            dataList.add(screenShotDBData);
            chart.inputChartSeries(dataList);
        }
    }

    public List<String> getSelectedChartListByFile() {
        return this.savedChartListByFile;
    }
}

