/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.communicator.IDECommunicator;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogTemplatePage;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class WelcomeDialog
extends DAMessageBox {
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;
    private boolean isApply = false;
    private SettingDialogTemplatePage templatesPage = null;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            WelcomeDialog.this.isApply = true;
            WelcomeDialog.this.doApply();
            WelcomeDialog.this.doRun();
            WelcomeDialog.this.shell.close();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            WelcomeDialog.this.isApply = true;
            WelcomeDialog.this.doRevert();
            WelcomeDialog.this.doRun();
            WelcomeDialog.this.shell.close();
        }
    };
    private ShellListener shellListener = new ShellListener(){

        public void shellActivated(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
            if (!WelcomeDialog.this.isApply) {
                WelcomeDialog.this.doRevert();
                WelcomeDialog.this.doRun();
            }
            WelcomeDialog.this.notifyAutoRun();
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    };

    public WelcomeDialog(Shell parentShell) {
        super(parentShell);
    }

    private void doApply() {
        if (DAState.isStartable()) {
            UIActionHolder.getUIAction().setUIElementsBySetting();
            SettingDataManager.INSTANCE.applySettingData();
        }
    }

    private void doRevert() {
        if (DAState.isStartable()) {
            SettingDataManager.INSTANCE.revertSettingData();
        }
    }

    private void doRun() {
        if (DAState.isStartable()) {
            CommonAction.configure();
        }
    }

    protected boolean run() {
        IDECommunicator.setOpenWelcomeDlg(true);
        this.shell.setSize(611, 558);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.SETTING_TITLE);
        this.shell.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        Label banner = new Label((Composite)this.shell, 0x40000000);
        banner.setBackground(ColorResources.WINDOW_BG_COLOR);
        banner.setImage(ImageResources.WELCONE_BANNER_IMAGE);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.height = 80;
        banner.setLayoutData((Object)labelData);
        Composite contentsComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        contentsComp.setLayout((Layout)compLayout);
        contentsComp.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)banner, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, -49);
        contentsComp.setLayoutData((Object)compData);
        if (!SettingDataManager.INSTANCE.isParsingSuccess()) {
            Label label = new Label(contentsComp, 0);
            label.setForeground(ColorResources.DEFAULT_FONT_COLOR);
            label.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
            label.setFont(FontResources.SETTING_TITLE_FONT);
            label.setText(ConfigureLabels.SETTING_WARNING_MESSAGE_FILE_NOT_FOUND);
            this.shell.addShellListener(this.shellListener);
            this.shell.open();
            return true;
        }
        this.templatesPage = new SettingDialogTemplatePage(contentsComp, 0);
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.templatesPage.setLayoutData(compData);
        Composite buttonContentsComp = new Composite((Composite)this.shell, 0);
        compLayout = new FormLayout();
        buttonContentsComp.setLayout((Layout)compLayout);
        buttonContentsComp.setBackground(ColorResources.CONFIGURATION_BUTTON_COVER_BACKGROUND_COLOR);
        compData = new FormData();
        compData.top = new FormAttachment((Control)contentsComp, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonContentsComp.setLayoutData((Object)compData);
        buttonContentsComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_1);
                e.gc.drawLine(0, 0, rect.width - 1, 0);
                e.gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_2);
                e.gc.drawLine(0, 1, rect.width - 1, 1);
            }
        });
        this.cancelButton = new DAButton(buttonContentsComp, 0);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, -9);
        buttonData.top = new FormAttachment(0, 11);
        buttonData.width = 100;
        buttonData.height = 28;
        this.cancelButton.setLayoutData((Object)buttonData);
        this.okButton = new DAButton(buttonContentsComp, 0);
        this.okButton.addClickListener(this.okButtonListener);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.right = new FormAttachment((Control)this.cancelButton, -8);
        buttonData.top = new FormAttachment(0, 11);
        buttonData.width = 100;
        buttonData.height = 28;
        this.okButton.setLayoutData((Object)buttonData);
        this.shell.addShellListener(this.shellListener);
        this.shell.open();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAutoRun() {
        Object object = IDECommunicator.getWaitingWelcomeDlg();
        synchronized (object) {
            IDECommunicator.setOpenWelcomeDlg(false);
            IDECommunicator.getWaitingWelcomeDlg().notifyAll();
        }
    }
}

