/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.app;

import java.io.IOException;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.app.ApplicationCheckException;
import org.tizen.sdblib.app.IApplication;
import org.tizen.sdblib.app.IApplicationListener;
import org.tizen.sdblib.daemon.AbstractServer;
import org.tizen.sdblib.util.ApplicationUtil;
import org.tizen.sdblib.util.ArrayUtil;

public class ApplicationMonitor
extends AbstractServer {
    private SmartDevelopmentBridge sdb;

    public ApplicationMonitor(SmartDevelopmentBridge sdb) {
        this.sdb = sdb;
    }

    @Override
    protected void process() {
        IApplication[] apps;
        IApplication[] iApplicationArray = apps = this.getMonitoringApplications();
        int n = apps.length;
        int n2 = 0;
        while (n2 < n) {
            IApplication app = iApplicationArray[n2];
            try {
                boolean isRunningOldCheck = app.isRunning();
                boolean isRunningNewCheck = this.isRunning(app);
                app.setRunning(isRunningNewCheck);
                if (isRunningOldCheck && !isRunningNewCheck) {
                    this.fireTerminated(app);
                } else if (!isRunningOldCheck && isRunningNewCheck) {
                    this.fireDetected(app);
                }
            }
            catch (ApplicationCheckException applicationCheckException) {}
            ++n2;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void fireTerminated(IApplication app) {
        IApplicationListener[] listeners = app.getListeners();
        if (ArrayUtil.isEmpty(listeners)) {
            return;
        }
        IApplicationListener[] iApplicationListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IApplicationListener listener = iApplicationListenerArray[n2];
            listener.onTerminated(app);
            ++n2;
        }
    }

    private void fireDetected(IApplication app) {
        IApplicationListener[] listeners = app.getListeners();
        if (ArrayUtil.isEmpty(listeners)) {
            return;
        }
        IApplicationListener[] iApplicationListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IApplicationListener listener = iApplicationListenerArray[n2];
            listener.onDetected(app);
            ++n2;
        }
    }

    private boolean isRunning(IApplication application) throws ApplicationCheckException {
        int pid = -1;
        try {
            pid = ApplicationUtil.getPid(application.getDevice(), application.getAppId());
        }
        catch (IOException e) {
            throw new ApplicationCheckException(e.getLocalizedMessage());
        }
        if (pid < 1) {
            throw new ApplicationCheckException("Could not check the application is running or not.");
        }
        return true;
    }

    private IApplication[] getMonitoringApplications() {
        return this.sdb.getInterestingApplications();
    }
}

