/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.control.ResourceMonitor;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.MenuBarLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.communicator.DataChannelThread;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.swap.logparser.MessageParser;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackInserter;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotTimer;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.page.UpdateViewTimer;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class StopTraceManager
implements Runnable {
    private static final long LSAN_MESSAGE_TIMEOUT = TimeUnit.SECONDS.toNanos(30L);
    private DAResult error;
    private boolean stopFromTarget = false;
    private Thread stopThread = null;

    public StopTraceManager(DAResult err, boolean stopFromTarget) {
        this.error = err;
        this.stopFromTarget = stopFromTarget;
    }

    @Override
    public void run() {
        try {
            block21: {
                ResourceMonitor.stop();
                try {
                    if (!this.stopFromTarget) {
                        DACommunicator.stopTrace();
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)"Failed : Stop Trace");
                    e.printStackTrace();
                }
                Thread stopTimers = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (Global.isGUIMode()) {
                            Toolbar.INSTANCE.stopTimer();
                        }
                        ScreenshotTimer.stop();
                        UpdateViewTimer.stop();
                    }
                }, "StopTimersThread");
                stopTimers.start();
                AnalyzerUtil.getLSanLock().lock();
                if (Global.isLSanInitialized()) {
                    try {
                        try {
                            long remainedTime = LSAN_MESSAGE_TIMEOUT;
                            Condition cond = AnalyzerUtil.getLSanCondition();
                            while (Global.isLSanInitialized()) {
                                if (remainedTime <= 0L) {
                                    Logger.warning((Object)"LeakSanitizer message timeout!");
                                    break;
                                }
                                remainedTime = cond.awaitNanos(remainedTime);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.warning((Object)"Interrupted while waiting for message from LeakSanitizer");
                            Global.setLSanInitialized(false);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        Global.setLSanInitialized(false);
                        throw throwable;
                    }
                    Global.setLSanInitialized(false);
                }
            }
            AnalyzerUtil.getLSanLock().unlock();
            if (this.error.equals((Object)DAResult.ErrorCode.ERR_BY_USER_CANCEL)) {
                this.stopThread = new ForcedStopThread();
            } else {
                this.stopThread = new NormalStopThread();
                Project project = Global.getProject();
                if (project != null && project.isValid()) {
                    if (Global.isGUIMode()) {
                        project.setTotalStopTime(Toolbar.INSTANCE.getTime());
                    }
                } else {
                    Logger.error((Object)"project is not valid to save");
                }
            }
            this.stopThread.start();
            UIActionHolder.getUIAction().applyStopTraceUI();
            DLogDataManager.getInstance().stopDlog();
            if (Global.isGUIMode()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                        baseView.getTopComposite().updateView();
                    }
                });
            }
        }
        finally {
            this.updateDAState();
            if (Global.isGUIMode()) {
                this.startUpdateHeapDataManager();
            }
        }
    }

    private void startUpdateHeapDataManager() {
        if (SettingDataManager.INSTANCE.getSelectedFlatFeatureSet().contains((Object)FlatFeature.MEMORY_ALLOC)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Logger.info((Object)"Calculating allocation data in HeapDataManager");
                    if (SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER)) {
                        HeapDataManager.getInstance().makeWholePersistentAllocsData(true);
                    }
                    if (MenuBar.getInstance().getPersistentAllocationsSelection()) {
                        HeapDataManager.getInstance().makeWholePersistentAllocsData(false);
                    }
                    HeapDataManager.getInstance().makeStatisticsData(0L, 0L);
                    BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                    baseView.getTopComposite().updateView();
                }
            });
        }
    }

    private void updateDAState() {
        if (this.stopThread != null) {
            try {
                this.stopThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.stopThread = null;
        }
        DAState.changeCurrentState(DAState.DONE);
        if (Global.isGUIMode()) {
            ShortCutManager.getInstance().setEnabled(true);
            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_SAVE, true);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_NEW, true);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_LOAD, true);
                    AnalyzerManager.getCurrentPage().updateView();
                }
            });
        }
    }

    private static class ForcedStopThread
    extends Thread {
        public ForcedStopThread() {
            super(ForcedStopThread.class.getSimpleName());
        }

        @Override
        public void run() {
            DataChannelThread.getInstance().stopForced();
            MessageParser.getInstance().stopForced();
            LogParser.getInstance().stopForced();
            DataManagerRegistry.stopThreadsForced();
            CallStackInserter.getInstance().stopForced();
        }
    }

    private static class NormalStopThread
    extends Thread {
        public NormalStopThread() {
            super(NormalStopThread.class.getSimpleName());
        }

        @Override
        public void run() {
            DataChannelThread.getInstance().stopNormal();
            MessageParser.getInstance().stopNormal();
            LogParser.getInstance().stopNormal();
            DataManagerRegistry.stopThreadsNormal();
            CallStackInserter.getInstance().stopNormal();
        }
    }
}

