/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.callstack;

import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.callstack.BaseCallstackManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackItem;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.util.Logger;

public class RangeCallstackManager
extends BaseCallstackManager {
    @Override
    public void makeUserCallstack(LogData log, ProfileDataMaker profiler) {
        int eventType;
        if (!(log instanceof ProfileData)) {
            Logger.warning((Object)"failed to make user callstack : log is not profile log");
            return;
        }
        ProfileData pData = (ProfileData)log;
        int pid = pData.getPid();
        long time = pData.getTime();
        Map<Long, CallStackUnit> addrMap = this.getCallStackApiAddrByPidMap(pid);
        int tid = pData.getTid();
        long selfAddr = pData.getPcAddr();
        long callerAddr = pData.getCallerPcAddr();
        CallStackUnit selfCallstackUnit = addrMap.get(selfAddr);
        if (selfCallstackUnit == null) {
            String strSelfFuncName = Global.getFunctionName(pData.getApiId());
            BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(pData.getBinaryId());
            String strSelfSymbol = String.valueOf(binInfo.getTargetBinaryPath()) + "(" + strSelfFuncName;
            selfCallstackUnit = new CallStackUnit(selfAddr, strSelfSymbol, pData.getApiId(), pData);
            addrMap.put(selfAddr, selfCallstackUnit);
        }
        profiler.makeFupDataForCallTrace(selfCallstackUnit, pData);
        List<CallStackItem> userCallstack = this.getUserCallstack(tid);
        int size = userCallstack.size();
        CallStackUnit callerCallstackUnit = addrMap.get(callerAddr);
        if (callerCallstackUnit == null) {
            String strCallerSymbol = this.getCallStackSymbol(callerAddr, pid, time);
            callerCallstackUnit = new CallStackUnit(callerAddr, strCallerSymbol, pData);
            addrMap.put(callerAddr, callerCallstackUnit);
        }
        if ((eventType = pData.getMsgID()) == 8) {
            if (size == 0) {
                userCallstack.add(new CallStackItem(selfCallstackUnit, time));
            } else {
                if (this.isAddrInBinaryRange(pid, time, callerAddr)) {
                    CallStackUnit callerCsa = addrMap.get(callerAddr);
                    if (callerCsa == null) {
                        callerCsa = userCallstack.get(size - 1).getCallStackUnit();
                        callerCsa.setFunctionStartAddr(callerCsa.getAddr());
                        callerCsa.setAddr(callerAddr);
                    } else {
                        CallStackItem topCallstackItem = userCallstack.get(size - 1);
                        callerCsa.setFunctionStartAddr(topCallstackItem.getCallStackUnit().getAddr());
                        userCallstack.set(size - 1, new CallStackItem(callerCsa, topCallstackItem.getStartTime()));
                    }
                }
                userCallstack.add(new CallStackItem(selfCallstackUnit, time));
            }
        } else if (eventType == 9) {
            if (size == 0) {
                return;
            }
            CallStackUnit removeCallStackUnit = userCallstack.get(size - 1).getCallStackUnit();
            if (selfCallstackUnit.getFunctionId() == removeCallStackUnit.getFunctionId()) {
                userCallstack.remove(size - 1);
                size = userCallstack.size();
                if (size > 0) {
                    CallStackItem prevCallstackItem = userCallstack.get(size - 1);
                    long prevSelfAddr = prevCallstackItem.getCallStackUnit().getFunctionStartAddr();
                    CallStackUnit callerCsa = addrMap.get(prevSelfAddr);
                    if (callerCsa == null) {
                        prevCallstackItem.getCallStackUnit().setAddr(prevSelfAddr);
                    } else {
                        userCallstack.set(size - 1, new CallStackItem(callerCsa, prevCallstackItem.getStartTime()));
                    }
                }
            } else {
                Logger.debug((String)"exit self function : %s, user callstack function : %s", (Object[])new Object[]{Global.getFunctionName(selfCallstackUnit.getFunctionId()), Global.getFunctionName(removeCallStackUnit.getFunctionId())});
            }
        }
    }

    @Override
    public long getSeqOfUserCallstackForTime(int tid, long time) {
        Logger.error((Object)"Should not be called in range callstack manager");
        return 0L;
    }
}

