/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.swap.model.data.AppStartupData;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDBTable;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDataManager;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class AppStartupTable
extends DATableComposite {
    public static final int START_TIME = 2;
    public static final int END_TIME = 3;
    private String[] columnNames = new String[]{InformationViewLabels.APP_STARTUP_VIEW_PID, InformationViewLabels.APP_STARTUP_VIEW_STAGE, InformationViewLabels.APP_STARTUP_VIEW_START_TIME, InformationViewLabels.APP_STARTUP_VIEW_END_TIME};
    private int[] columnSizes = new int[]{40, 145, 70, 70};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true};
    private int[] sortTypes = new int[]{1, 2, 1, 1};

    public AppStartupTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setTableName(InformationViewLabels.APP_STARTUP_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(this.sortTypes);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AnalyzerManager.getCurrentPage().updateView(new DAViewData(TimelineTableView.tabID, null));
                GridItem[] sels = AppStartupTable.this.table.getSelection();
                if (sels.length > 0) {
                    AppStartupTable.this.table.setFocusItem(sels[0]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<List<Object>> datas = AppStartupDataManager.getInstance().getAppStartupDBTable().getObjectDataFromDB(selectedPid);
        int rowsize = datas.size();
        int i = 0;
        while (i < rowsize) {
            List<Object> rowData = datas.get(i);
            ArrayList<String> contentText = new ArrayList<String>();
            ArrayList<String> contentData = new ArrayList<String>();
            Integer pid = (Integer)rowData.get(AppStartupDBTable.COLUMN.PID.getIndex());
            contentText.add(Integer.toString(pid));
            contentData.add(Integer.toString(pid));
            Integer stageid = (Integer)rowData.get(AppStartupDBTable.COLUMN.STAGE_ID.getIndex());
            contentText.add(AppStartupDBTable.STAGE.getName(stageid));
            contentData.add(AppStartupDBTable.STAGE.getName(stageid));
            long startTime = (Long)rowData.get(AppStartupDBTable.COLUMN.START_TIME.getIndex());
            contentText.add(Formatter.toTimeFormat(startTime));
            contentData.add(Long.toString(startTime));
            long endTime = (Long)rowData.get(AppStartupDBTable.COLUMN.END_TIME.getIndex());
            contentText.add(Formatter.toTimeFormat(endTime));
            contentData.add(Long.toString(endTime));
            DATableDataFormat tableData = new DATableDataFormat((Long)rowData.get(AppStartupDBTable.COLUMN.SEQUENCE_NUMBER.getIndex()));
            tableData.setLogData(this.makeAppStartupData(rowData));
            tableData.getData().addAll(contentData);
            tableData.setType(256);
            TableInput tableInput = new TableInput();
            tableInput.setText(contentText);
            tableInput.setData(tableData);
            input.add(tableInput);
            if (RangeDataManager.getInstance().isBeingAnalyzed()) {
                long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
                long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
                if (startTime >= analysisStartTime && startTime <= analysisEndTime) {
                    tableInput.setInRange(true);
                }
            }
            ++i;
        }
        return input;
    }

    public void setSelectionByTime(long selectionStartTime, long selectionEndTime) {
        ArrayList<Integer> selectionList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            GridItem gridItem = this.table.getItem(i);
            DATableDataFormat gridData = (DATableDataFormat)gridItem.getData();
            if (gridData != null) {
                long startTime = Long.parseLong((String)gridData.getData().get(2));
                long endTime = Long.parseLong((String)gridData.getData().get(3));
                if (selectionStartTime <= startTime && startTime <= selectionEndTime || selectionStartTime <= endTime && endTime <= selectionEndTime) {
                    selectionList.add(i);
                }
            }
            ++i;
        }
        int[] sels = new int[selectionList.size()];
        int i2 = 0;
        while (i2 < selectionList.size()) {
            sels[i2] = (Integer)selectionList.get(i2);
            ++i2;
        }
        this.table.setSelection(sels);
    }

    private AppStartupData makeAppStartupData(List<Object> rowData) {
        AppStartupData logData = new AppStartupData();
        logData.setSeq((Long)rowData.get(AppStartupDBTable.COLUMN.SEQUENCE_NUMBER.getIndex()));
        return logData;
    }
}

