/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.nl.InteractivePageLabels;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class InteractiveChartRenderer
extends DAChartRenderer {
    private final int SERIES_DISTANCE_MARGIN = 20;

    protected void drawToGc(GC gc, DAChart chart) {
        if (!this.preDraw(gc, chart)) {
            return;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            this.drawSeries(gc, (DAChartSeries)this.seriesList.get(i), i);
            ++i;
        }
    }

    private void drawSeries(GC gc, DAChartSeries series, int seriesIndex) {
        int seriesSize = this.seriesList.size();
        Rectangle rect = new Rectangle(this.r.x, this.r.y + this.r.height * seriesIndex / seriesSize, this.r.width, this.r.height / seriesSize);
        if (seriesIndex != 0) {
            gc.setForeground(ColorResources.CHART_SEPERATE_LINE);
            gc.drawLine(rect.x, this.r.height * seriesIndex / seriesSize, rect.width, this.r.height * seriesIndex / seriesSize);
        }
        Font oriFont = gc.getFont();
        gc.setForeground(ColorResources.CHART_INFO);
        gc.setFont(FontResources.CHART_INFO_FONT);
        gc.drawImage(ImageResources.CHART_INFO, rect.x + 3, rect.y + rect.height / 2 - gc.stringExtent((String)series.getName()).y / 2);
        gc.drawText(series.getName(), rect.x + 18, rect.y + rect.height / 2 - gc.stringExtent((String)series.getName()).y / 2, true);
        gc.setFont(oriFont);
        List seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        gc.setLineStyle(1);
        gc.setAntialias(1);
        int i = index;
        while (i < seriesItemSize) {
            double currentX = ((DAChartSeriesItem)seriesItems.get(i)).getX();
            int pixcelStartX = this.plot.getXPixelFromX(currentX, this.r);
            int pixcelStartY = rect.y + 4;
            gc.setBackground(series.getColor());
            gc.fillRectangle(pixcelStartX, pixcelStartY, 2, rect.height - 4);
            if (currentX > this.plot.getVisibleEndX()) {
                return;
            }
            ++i;
        }
    }

    protected void drawTooltip(GC gc) {
        DAChartPlotTooltip tooltip = this.plot.getTooltip();
        if (tooltip == null || !tooltip.shouldBeDrawn() || tooltip.getStartVal() == -1.0) {
            return;
        }
        gc.setFont(tooltip.getFont());
        ArrayList<String> tooltipTexts = new ArrayList<String>();
        ArrayList<String> tooltipTimes = new ArrayList<String>();
        ArrayList<Color> tooltipColor = new ArrayList<Color>();
        int textWidthMax = 0;
        int textHeightMax = 0;
        double realXVal = tooltip.getStartVal();
        int tooltipSize = 0;
        int i = 0;
        while (i < this.seriesList.size()) {
            Color color;
            DAChartSeries series = (DAChartSeries)this.seriesList.get(i);
            ++tooltipSize;
            int index = series.getPrevIndexByXvalue(realXVal);
            String text = "";
            String time = "";
            if (index >= 0) {
                double xVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX();
                time = String.valueOf(time) + this.toTimeFormat(xVal);
                text = series.isSummarizeTooltip() && this.checkOverlapFromPrevItem(series, index) ? String.valueOf(text) + series.getSummarizeString() : String.valueOf(text) + ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getTooltipText();
                gc.setForeground(tooltip.getLineColor());
                gc.setLineStyle(3);
                gc.setLineWidth(1);
                gc.drawLine(this.plot.getXPixelFromX(xVal), 0, this.plot.getXPixelFromX(xVal), this.r.height);
                gc.setLineStyle(6);
                color = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getColor();
            } else {
                text = InteractivePageLabels.INTERACTIVE_CHART_INVALID_CHECK_LOCATION;
                color = null;
            }
            tooltipTexts.add(text);
            tooltipTimes.add(time);
            tooltipColor.add(color);
            int textWidth = gc.textExtent((String)text).x + 20 + gc.textExtent((String)time).x;
            int textHeight = gc.textExtent((String)text).y;
            if (textWidthMax < textWidth) {
                textWidthMax = textWidth;
            }
            if (textHeightMax < textHeight) {
                textHeightMax = textHeight;
            }
            ++i;
        }
        int preTextWidthMargin = 14;
        int startX = this.getTooltipStartX(realXVal, textWidthMax + preTextWidthMargin, 4);
        int totalHeight = tooltipSize * textHeightMax + 4 + 4 + (tooltipSize - 1) * 20;
        int startY = this.r.y + this.r.height / 2 - totalHeight / 2;
        gc.setAlpha(180);
        gc.setBackground(tooltip.getBackgroundColor());
        gc.setForeground(tooltip.getForegroundColor());
        gc.fillGradientRectangle(startX, startY, preTextWidthMargin + textWidthMax + 4, totalHeight, true);
        gc.setAlpha(255);
        gc.setForeground(tooltip.getLineColor());
        gc.drawRoundRectangle(startX, startY, preTextWidthMargin + textWidthMax + 4, totalHeight, 5, 5);
        gc.setFont(tooltip.getFont());
        tooltipSize = -1;
        int i2 = 0;
        while (i2 < this.seriesList.size()) {
            DAChartSeries series = (DAChartSeries)this.seriesList.get(i2);
            if (!series.isDisableTooltip()) {
                ++tooltipSize;
                int yPosition = this.r.y + this.r.height * i2 / this.seriesList.size() + this.r.height / this.seriesList.size() / 2 - textHeightMax / 2;
                Color col = (Color)tooltipColor.get(i2);
                if (col == null) {
                    gc.setBackground(series.getColor());
                } else {
                    gc.setBackground(col);
                }
                gc.fillRectangle(startX + 4, yPosition + textHeightMax / 2 - 3, 6, 6);
                gc.setBackground(tooltip.getBackgroundColor());
                gc.setForeground(tooltip.getTextColor());
                gc.drawText((String)tooltipTexts.get(i2), startX + 4 + 6 + 4, yPosition, 3);
                gc.setForeground(tooltip.getTimeColor());
                String timeStr = (String)tooltipTimes.get(i2);
                gc.drawText((String)tooltipTimes.get(i2), startX + 4 + 6 + 4 + textWidthMax - 4 - gc.textExtent((String)timeStr).x, yPosition, 3);
            }
            ++i2;
        }
    }

    protected int getTooltipStartX(double startVal, int width, int margin) {
        int ret = this.plot.getXPixelFromX(startVal);
        if (ret + width > this.r.x + this.r.width) {
            if ((ret = ret - width - margin) < 0) {
                ret = 50;
            }
        } else {
            ret = ret < this.r.x ? this.r.x + margin : (ret += margin);
        }
        return ret;
    }
}

