/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.KernelPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.kernel.CallFlowChart;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChartView;
import org.tizen.dynamicanalyzer.ui.kernel.KernelPage;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelSelectionData;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class CallFlowChartView
extends DAViewComposite {
    private final Composite contents;
    private CallFlowChart callflowChart;
    private DACustomCombo callflowCombo;
    private final StackLayout stackLayout;
    private final RangeDataManager rangeDataManager = RangeDataManager.getInstance();

    public CallFlowChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(KernelPageLabels.CALL_FLOW_CHART_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.callflowChart = new CallFlowChart(this.contents, KernelPageLabels.CALL_FLOW_CHART_TITLE, ContextSwitchingChartView.kernelScaleValue);
        this.callflowChart.setNameFont(FontResources.CHART_NAME_FONT);
        this.callflowChart.addSelectionListener(new DAChartBoardSelectionListener(){

            public void handleSelectionEvent(DAChartBoardItem item) {
                AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(KernelPage.callflowViewID, (long)(((DAChartPlotIntervalMarker)CallFlowChartView.this.callflowChart.getMarkers().get(0)).getStartVal() * 1000000.0), (long)(((DAChartPlotIntervalMarker)CallFlowChartView.this.callflowChart.getMarkers().get(0)).getEndVal() * 1000000.0), new Integer(0), null));
            }
        });
        ScrollBar hScrollBar = this.callflowChart.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CallFlowChartView.this.callflowChart.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(KernelPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(KernelPage.pageID, false);
                }
            }
        });
        this.initIntervalMarkers(this.callflowChart);
        this.stackLayout.topControl = this.callflowChart;
        this.callflowCombo = new DACustomCombo(this.callflowChart.getTitleComp(), 0);
        this.callflowCombo.setComboGradation(ColorResources.FRAME_RATE_COMBO_NORMAL_START, ColorResources.FRAME_RATE_COMBO_NORMAL_END, ColorResources.FRAME_RATE_COMBO_PUSH_START, ColorResources.FRAME_RATE_COMBO_PUSH_END, ColorResources.FRAME_RATE_COMBO_HOVER_START, ColorResources.FRAME_RATE_COMBO_HOVER_END, ColorResources.FRAME_RATE_COMBO_DISABLE_START, ColorResources.FRAME_RATE_COMBO_DISABLE_END);
        this.callflowCombo.setOutlineColors(ColorResources.FRAME_RATE_COMBO_OUTLINE_NORMAL, ColorResources.FRAME_RATE_COMBO_OUTLINE_PUSH, ColorResources.FRAME_RATE_COMBO_OUTLINE_HOVER, ColorResources.FRAME_RATE_COMBO_OUTLINE_DISABLE);
        this.callflowCombo.add(KernelPageLabels.CALL_FLOW_CHART_TITLE);
        this.callflowCombo.select(0);
        this.callflowCombo.setEnabled(false);
        this.callflowCombo.setTextAlign(16384);
        this.callflowCombo.setComboFont(FontResources.FRAME_RATE_COMBO);
        this.callflowCombo.setFontColors(ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR);
        this.callflowCombo.setItemFont(FontResources.FRAME_RATE_DROPDOWN);
        this.callflowCombo.setItemFontColor(ColorResources.ADD_CHART_FONT_COLOR);
        this.callflowCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        DATimeline timeline = this.callflowChart.getTimeline();
        timeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        timeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.callflowChart.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(timeline);
    }

    public void updateView() {
        this.callflowChart.updateChart();
        if (AnalyzerUtil.isLatestTraceMode(KernelPage.pageID)) {
            this.callflowChart.updateVisibleStartTime();
            this.callflowChart.setTotalEndTime(Toolbar.INSTANCE.getTime(), true);
        } else {
            this.callflowChart.setTotalEndTime(Toolbar.INSTANCE.getTime(), false);
        }
        RangeDataManager rangeDataManager = RangeDataManager.getInstance();
        if (rangeDataManager.isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.callflowChart.getMarkers().get(1)).setInterval((double)rangeDataManager.getAnalysisStartTime() / 1000000.0, (double)rangeDataManager.getAnalysisEndTime() / 1000000.0);
        } else {
            ((DAChartPlotIntervalMarker)this.callflowChart.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        ((DAChartPlotIntervalMarker)this.callflowChart.getMarkers().get(2)).setInterval((double)rangeDataManager.getMarkerStartTime() / 1000000.0, (double)rangeDataManager.getMarkerEndTime() / 1000000.0);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            Object odata = selData.getData();
            if (!(odata instanceof KernelSelectionData)) {
                long selectionStartTime = selData.getStartTime();
                long selectionEndTime = selData.getEndTime();
                double startTime = (double)selectionStartTime / 1000000.0;
                double endTime = (double)selectionEndTime / 1000000.0;
                DAChartBoard chartBoard = (DAChartBoard)this.stackLayout.topControl;
                DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)chartBoard.getMarkers().get(0);
                intervalMarker.setInterval(startTime, endTime);
            } else {
                KernelSelectionData sdata = (KernelSelectionData)odata;
                this.callflowChart.setSelectedData(sdata.getData());
                this.callflowChart.updateChart();
            }
        }
    }

    public void clear() {
        this.callflowChart.clear();
        this.initIntervalMarkers(this.callflowChart);
    }

    public Control getControl() {
        return this.callflowChart;
    }

    private void initIntervalMarkers(DAChartBoard board) {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.RED);
        rangeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }
}

