/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.swap.model.data.ContextSwitchData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.kernel.data.ContextDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.FunctionDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataManager;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataPerThread;
import org.tizen.dynamicanalyzer.util.Logger;

public class KernelDataMaker {
    private static final String queryto_withTime = "where %s < %s and %s > %s order by %s";
    private static final String queryto_withTidAndTime = "where %s = %s and %s < %s and %s > %s order by %s";
    private static final String queryto_withTid = "where %s = %s group by %s";
    public static final int START_TYPE_START = 10;
    public static final int START_TYPE_RESUME = 20;
    public static final int START_TYPE_RETURNED = 30;
    public static final int END_TYPE_END = 1;
    public static final int END_TYPE_PAUSED = 2;
    public static final int END_TYPE_CALL = 3;
    private List<KernelDataPerThread> threads = new ArrayList<KernelDataPerThread>();
    private DBInserter contextDBInserter = null;
    private DBInserter functionDBInserter = null;

    public KernelDataMaker(DBInserter cDBInserter, DBInserter fDBInserter) {
        this.contextDBInserter = cDBInserter;
        this.functionDBInserter = fDBInserter;
    }

    private KernelDataPerThread findKernelData(int tid) {
        int size = this.threads.size();
        int i = 0;
        while (i < size) {
            KernelDataPerThread kdata = this.threads.get(i);
            if (kdata.getTid() == tid) {
                return kdata;
            }
            ++i;
        }
        return null;
    }

    public void makeData(List<LogData> inputs) {
        ArrayList contextDataList = new ArrayList();
        ArrayList functionDataList = new ArrayList();
        int size = inputs.size();
        int i = 0;
        while (i < size) {
            LogData input = inputs.get(i);
            switch (input.getMsgID()) {
                case 17: {
                    ContextSwitchData csdata = (ContextSwitchData)input;
                    int tid = csdata.getTid();
                    KernelDataPerThread kdata = this.findKernelData(tid);
                    if (kdata == null) {
                        kdata = new KernelDataPerThread(csdata.getPid(), tid, csdata);
                        this.threads.add(kdata);
                        break;
                    }
                    if (kdata.getCorelog() != null) {
                        Logger.error((Object)"context switch entry log is coming without exit log of previous context");
                        break;
                    }
                    kdata.setCorelog(csdata);
                    Stack<ProfileData> prefunc = kdata.getFunclog();
                    Stack<Integer> prefunc_type = kdata.getFunclogType();
                    if (prefunc == null) break;
                    ProfileData pfdata = prefunc.peek();
                    pfdata.setTime(csdata.getTime());
                    pfdata.setPcAddr(csdata.getPcAddr());
                    pfdata.setCpuNum(csdata.getCpuNum());
                    prefunc_type.pop();
                    prefunc_type.push(20);
                    break;
                }
                case 16: {
                    ContextSwitchData csdata = (ContextSwitchData)input;
                    int tid = csdata.getTid();
                    KernelDataPerThread kdata = this.findKernelData(tid);
                    if (kdata == null) {
                        Logger.error((Object)"context switch exit log is coming without any entry log");
                        break;
                    }
                    ContextSwitchData precore = kdata.getCorelog();
                    if (precore == null) {
                        Logger.error((Object)"context switch exit log is coming without corresponding entry log");
                        break;
                    }
                    if (precore.getCpuNum() != csdata.getCpuNum()) {
                        Logger.error((Object)"context switch exit log is coming with different cpu num");
                        break;
                    }
                    kdata.setCorelog(null);
                    ArrayList<Number> dbdata = new ArrayList<Number>();
                    dbdata.add(new Long(precore.getSeq()));
                    dbdata.add(new Integer(precore.getPid()));
                    dbdata.add(new Integer(precore.getTid()));
                    dbdata.add(new Integer(precore.getCpuNum()));
                    dbdata.add(new Long(precore.getTime()));
                    dbdata.add(new Long(precore.getPcAddr()));
                    dbdata.add(new Long(csdata.getTime()));
                    dbdata.add(new Long(csdata.getPcAddr()));
                    contextDataList.add(dbdata);
                    kdata.incCoreFragmentCount();
                    Stack<ProfileData> prefunc = kdata.getFunclog();
                    Stack<Integer> prefunc_type = kdata.getFunclogType();
                    if (prefunc == null) break;
                    if (prefunc.isEmpty() || prefunc_type.isEmpty()) {
                        Logger.warning((Object)"context switch exit log is coming but there is no function in stack");
                        break;
                    }
                    ProfileData lastfunc = prefunc.peek();
                    int lastfunc_type = prefunc_type.peek();
                    ArrayList<Number> dbfuncdata = new ArrayList<Number>();
                    dbfuncdata.add(new Long(csdata.getSeq()));
                    dbfuncdata.add(new Integer(csdata.getPid()));
                    dbfuncdata.add(new Integer(csdata.getTid()));
                    dbfuncdata.add(new Integer(csdata.getCpuNum()));
                    dbfuncdata.add(new Long(lastfunc.getTime()));
                    dbfuncdata.add(new Integer(lastfunc_type));
                    dbfuncdata.add(new Long(lastfunc.getPcAddr()));
                    dbfuncdata.add(new Long(csdata.getTime()));
                    dbfuncdata.add(new Integer(2));
                    dbfuncdata.add(new Long(csdata.getPcAddr()));
                    dbfuncdata.add(new Integer(lastfunc.getApiId()));
                    functionDataList.add(dbfuncdata);
                    kdata.incFuncFragmentCount();
                    break;
                }
                case 8: {
                    ProfileData fndata = null;
                    try {
                        fndata = (ProfileData)input.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        Logger.exception((Throwable)e);
                        break;
                    }
                    int tid = fndata.getTid();
                    KernelDataPerThread kdata = this.findKernelData(tid);
                    if (kdata == null) break;
                    assert (kdata.getCorelog() != null);
                    if (kdata.getFunclog() == null) {
                        kdata.createFunctionStack();
                    }
                    Stack<ProfileData> prefunc = kdata.getFunclog();
                    Stack<Integer> prefunc_type = kdata.getFunclogType();
                    assert (prefunc != null && prefunc_type != null);
                    if (prefunc.isEmpty()) {
                        assert (prefunc_type.isEmpty());
                        prefunc.push(fndata);
                        prefunc_type.push(10);
                        break;
                    }
                    ProfileData lastfunc = prefunc.peek();
                    int lastfunc_type = prefunc_type.peek();
                    ArrayList<Number> dbfuncdata = new ArrayList<Number>();
                    dbfuncdata.add(new Long(fndata.getSeq()));
                    dbfuncdata.add(new Integer(fndata.getPid()));
                    dbfuncdata.add(new Integer(fndata.getTid()));
                    dbfuncdata.add(new Integer(fndata.getCpuNum()));
                    dbfuncdata.add(new Long(lastfunc.getTime()));
                    dbfuncdata.add(new Integer(lastfunc_type));
                    dbfuncdata.add(new Long(lastfunc.getPcAddr()));
                    dbfuncdata.add(new Long(fndata.getTime()));
                    dbfuncdata.add(new Integer(3));
                    dbfuncdata.add(new Long(fndata.getPcAddr()));
                    dbfuncdata.add(new Integer(lastfunc.getApiId()));
                    functionDataList.add(dbfuncdata);
                    kdata.incFuncFragmentCount();
                    prefunc.push(fndata);
                    prefunc_type.push(10);
                    break;
                }
                case 9: {
                    ProfileData fndata = (ProfileData)input;
                    int tid = fndata.getTid();
                    KernelDataPerThread kdata = this.findKernelData(tid);
                    if (kdata == null) break;
                    assert (kdata.getCorelog() != null);
                    if (kdata.getFunclog() == null) {
                        kdata.createFunctionStack();
                    }
                    Stack<ProfileData> prefunc = kdata.getFunclog();
                    Stack<Integer> prefunc_type = kdata.getFunclogType();
                    assert (prefunc != null && prefunc_type != null);
                    if (prefunc.isEmpty() || prefunc_type.isEmpty()) {
                        Logger.error((Object)"function exit log is coming without function entry log");
                        break;
                    }
                    ProfileData lastfunc = prefunc.pop();
                    int lastfunc_type = prefunc_type.pop();
                    assert (lastfunc.getApiId() == fndata.getApiId());
                    ArrayList<Number> dbfuncdata = new ArrayList();
                    dbfuncdata.add(new Long(fndata.getSeq()));
                    dbfuncdata.add(new Integer(fndata.getPid()));
                    dbfuncdata.add(new Integer(fndata.getTid()));
                    dbfuncdata.add(new Integer(fndata.getCpuNum()));
                    dbfuncdata.add(new Long(lastfunc.getTime()));
                    dbfuncdata.add(new Integer(lastfunc_type));
                    dbfuncdata.add(new Long(lastfunc.getPcAddr()));
                    dbfuncdata.add(new Long(fndata.getTime()));
                    dbfuncdata.add(new Integer(1));
                    dbfuncdata.add(new Long(fndata.getPcAddr()));
                    dbfuncdata.add(new Integer(lastfunc.getApiId()));
                    functionDataList.add(dbfuncdata);
                    kdata.incFuncFragmentCount();
                    if (prefunc.isEmpty() || prefunc_type.isEmpty()) break;
                    prefunc.peek().setTime(fndata.getTime());
                    prefunc.peek().setPcAddr(fndata.getPcAddr());
                    prefunc_type.pop();
                    prefunc_type.push(30);
                    break;
                }
            }
            ++i;
        }
        if (!contextDataList.isEmpty()) {
            this.contextDBInserter.pushData(contextDataList);
        }
        if (!functionDataList.isEmpty()) {
            this.functionDBInserter.pushData(functionDataList);
        }
    }

    public void clear() {
        this.threads.clear();
    }

    public List<List<Object>> getContextDataFromDB(long start, long end) {
        String where = String.format(queryto_withTime, ContextDataDBTable.COLUMN.STARTTIME.name, end, ContextDataDBTable.COLUMN.ENDTIME.name, start, ContextDataDBTable.COLUMN.STARTTIME.name);
        DBTable table = KernelDataManager.getInstance().getContextDataTable();
        return table.selectAllColumnData(where);
    }

    public List<List<Object>> getFunctionDataFromDB(long start, long end, int tid) {
        String where = tid >= 0 ? String.format(queryto_withTidAndTime, FunctionDataDBTable.COLUMN.TID.name, tid, FunctionDataDBTable.COLUMN.STARTTIME.name, end, FunctionDataDBTable.COLUMN.ENDTIME.name, start, FunctionDataDBTable.COLUMN.STARTTIME.name) : String.format(queryto_withTime, FunctionDataDBTable.COLUMN.STARTTIME.name, end, FunctionDataDBTable.COLUMN.ENDTIME.name, start, FunctionDataDBTable.COLUMN.STARTTIME.name);
        DBTable table = KernelDataManager.getInstance().getFunctionDataTable();
        return table.selectAllColumnData(where);
    }

    public List<List<Object>> getFuncnameFromDB(int tid) {
        String where = String.format(queryto_withTid, FunctionDataDBTable.COLUMN.TID.name, tid, FunctionDataDBTable.COLUMN.FUNCID.name);
        ArrayList<String> selectColumn = new ArrayList<String>();
        selectColumn.add(FunctionDataDBTable.COLUMN.FUNCID.name);
        DBTable table = KernelDataManager.getInstance().getFunctionDataTable();
        return table.selectData(selectColumn, where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getInt(1));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }

    public List<KernelDataPerThread> getThreadData() {
        return this.threads;
    }

    public void addThreadData(KernelDataPerThread data) {
        this.threads.add(data);
    }
}

