/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemFreeDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemLSanTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class HeapDataManager
extends PageDataManager {
    private static HeapDataManager instance = new HeapDataManager();
    private final int TOTAL_PID = -1;
    private final int MEM_API_TYPE_ALLOC = 0;
    private final int MEM_API_TYPE_FREE = 1;
    private final int PRESISTENT_SIZE_INDEX = 0;
    private final int PRESISTENT_COUNT_INDEX = 1;
    private final int FREE_COUNT_INDEX = 2;
    private final int TOTAL_SIZE_INDEX = 3;
    private final int MAX_LIBRARIES_PER_PID = 500;
    private int REALLOC_ID;
    private MemAllocDBTable allocateDBTable = new MemAllocDBTable();
    private MemFreeDBTable freeDBTable = new MemFreeDBTable();
    private MemLSanTable lsanDBTable = new MemLSanTable();
    private DBInserter allocateDBInserter = this.makeInserter(this.allocateDBTable);
    private DBInserter freeDBInserter = this.makeInserter(this.freeDBTable);
    private DBInserter lsanDBInserter = this.makeInserter(this.lsanDBTable);
    private ArrayList<List<Object>> memoryAllocDataList = new ArrayList();
    private ArrayList<List<Object>> memoryfreeDataList = new ArrayList();
    private volatile List<TableInput> persistentAllocsTableInput = new ArrayList<TableInput>();
    private volatile List<TableInput> leaksTableInput = new ArrayList<TableInput>();
    private volatile List<TreeInput> statisticsTreeInput = new ArrayList<TreeInput>();
    private List<List<Object>> preAllocDataList = new ArrayList<List<Object>>();
    private List<List<Object>> preFreeDataList = new ArrayList<List<Object>>();
    private List<List<Object>> preLeaksAllocDataList = new ArrayList<List<Object>>();
    private List<List<Object>> preLeaksFreeDataList = new ArrayList<List<Object>>();
    private HashSet<Long> addressMap = new HashSet();
    private Query lastFullAllocsQuery = new Query();
    private Query lastLeaksQuery = new Query();

    public static HeapDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.memoryAllocDataList.clear();
        this.memoryfreeDataList.clear();
        this.addressMap.clear();
        this.persistentAllocsTableInput.clear();
        this.leaksTableInput.clear();
        this.statisticsTreeInput.clear();
        this.preAllocDataList.clear();
        this.preFreeDataList.clear();
        this.preLeaksAllocDataList.clear();
        this.preLeaksFreeDataList.clear();
        this.lastFullAllocsQuery.clear();
        this.lastLeaksQuery.clear();
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.REALLOC_ID = Global.getFunctionID("realloc");
        Logs allocatedlogs = this.getLogsFromLogPackage(pack, 257);
        this.makeHeapData(allocatedlogs);
    }

    public List<Object> getAllocationRowBySeqFromDB(long seqNum) {
        String where = "WHERE SEQUENCE_NUMBER = " + Long.toString(seqNum);
        List<List<Object>> queryResult = this.allocateDBTable.selectRequiredColumns(where);
        if (queryResult.size() != 1) {
            Logger.error((Object)"Stored data was corrupted!");
            return null;
        }
        return queryResult.get(0);
    }

    public Long getAllocatorAddrBySeqFromDB(long seqNum) {
        if (!this.isAllocatorAddrSupported()) {
            return 0L;
        }
        String where = "WHERE SEQUENCE_NUMBER = " + Long.toString(seqNum);
        String columnName = MemAllocDBTable.COLUMN.ALLOCATOR_ADDRESS.name;
        List<List<Object>> queryResult = this.allocateDBTable.selectData(new ArrayList<String>(Arrays.asList(columnName)), where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    if (rs.getMetaData().getColumnCount() > 0) {
                        row.add(rs.getLong(1));
                    } else {
                        row.add(0L);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                }
                return row;
            }
        });
        if (queryResult.size() != 1) {
            Logger.warning((Object)("Could't extract " + columnName + " for seq#" + seqNum + " from " + "MEM_ALLOC_DB"));
            return 0L;
        }
        return (Long)queryResult.get(0).get(0);
    }

    private List<List<Object>> getAllocationDataFromDB(Query query, boolean onlyLeaks) {
        String where = this.getTimeWhereQuery(query, MemAllocDBTable.COLUMN.ALLOCATED_TIME.name, onlyLeaks);
        ArrayList queryResult = this.allocateDBTable.selectBasicColumns(where = String.valueOf(where) + " ORDER BY " + MemAllocDBTable.COLUMN.SEQUENCE_NUMBER.name);
        return queryResult != null ? queryResult : new ArrayList();
    }

    private List<List<Object>> getFreeDataFromDB(Query query, boolean onlyLeaks) {
        String where = this.getTimeWhereQuery(query, MemFreeDBTable.COLUMN.FREE_TIME.name, onlyLeaks);
        ArrayList queryResult = this.freeDBTable.selectBasicColumns(where = String.valueOf(where) + " ORDER BY " + MemFreeDBTable.COLUMN.SEQUENCE_NUMBER.name);
        return queryResult != null ? queryResult : new ArrayList();
    }

    public void makeWholePersistentAllocsData(boolean onlyLeaks) {
        if (DAState.isRunning()) {
            return;
        }
        List<List<Object>> allocDataList = null;
        allocDataList = this.remainedAllocatedListForRange(0L, 0L, onlyLeaks);
        if (allocDataList == null || allocDataList.size() == 0) {
            return;
        }
        int index = 0;
        int size = allocDataList.size();
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        int j = 0;
        while (j < size) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput input = this.makePersistentAllocsTableInput(iAllocData, index++, onlyLeaks);
            if (input != null) {
                output.add(input);
            }
            ++j;
        }
        if (onlyLeaks) {
            this.leaksTableInput = output;
        } else {
            this.persistentAllocsTableInput = output;
        }
    }

    public void makeStatisticsData(long startTime, long endTime) {
        Query query = new Query(startTime, endTime);
        Map<Integer, Map<Integer, List<Object>>> staticdatas = this.remainedAllocStaticData(query);
        int index = 0;
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        for (Map.Entry<Integer, Map<Integer, List<Object>>> elem : staticdatas.entrySet()) {
            long persistentSizeForPid = 0L;
            long persistentCountForPid = 0L;
            long freeCountForPid = 0L;
            long totalSizeForPid = 0L;
            ArrayList<TreeInput> children = new ArrayList<TreeInput>();
            index = elem.getKey() == -1 ? 0 : elem.getKey() * 500;
            int parentIndex = index++;
            for (Map.Entry<Integer, List<Object>> libEntry : elem.getValue().entrySet()) {
                String apiName = Global.getLibraryName(libEntry.getKey());
                TreeInput staticInput = this.makeTreeInputForDatas(apiName, false, libEntry.getValue(), index++);
                if (staticInput == null) continue;
                children.add(staticInput);
                persistentSizeForPid += ((Long)libEntry.getValue().get(0)).longValue();
                persistentCountForPid += ((Long)libEntry.getValue().get(1)).longValue();
                freeCountForPid += ((Long)libEntry.getValue().get(2)).longValue();
                totalSizeForPid += ((Long)libEntry.getValue().get(3)).longValue();
            }
            ArrayList<Object> total = new ArrayList<Object>();
            total.add(persistentSizeForPid);
            total.add(persistentCountForPid);
            total.add(freeCountForPid);
            total.add(totalSizeForPid);
            total.add(persistentCountForPid + freeCountForPid);
            TreeInput parent = elem.getKey() == -1 ? this.makeTreeInputForDatas("Total", false, total, parentIndex) : this.makeTreeInputForDatas(elem.getKey().toString(), true, total, parentIndex);
            if (parent == null) continue;
            parent.getChildren().addAll(children);
            output.add(parent);
        }
        this.statisticsTreeInput = output;
    }

    public List<TableInput> getPersistentAllocsTableInput() {
        return this.persistentAllocsTableInput;
    }

    public List<TableInput> getLeaksTableInput() {
        return this.leaksTableInput;
    }

    public List<TreeInput> getStatisticsTreeInput() {
        return this.statisticsTreeInput;
    }

    private Map<Integer, Map<Integer, List<Object>>> remainedAllocStaticData(Query query) {
        this.updateFullAllocCache(query);
        return this.makeRemainedAllocatedStatic(this.preAllocDataList, this.preFreeDataList);
    }

    public List<List<Object>> remainedAllocatedListForRange(long startTime, long endTime, boolean onlyLeaks) {
        Query query = new Query(startTime, endTime);
        return this.remainedAllocatedListForRange(query, onlyLeaks);
    }

    private List<List<Object>> remainedAllocatedListForRange(Query query, boolean onlyLeaks) {
        if (onlyLeaks) {
            this.updateLeaksCache(query);
            return this.makeRemainedAllocatedList(this.preLeaksAllocDataList, this.preLeaksFreeDataList);
        }
        this.updateFullAllocCache(query);
        return this.makeRemainedAllocatedList(this.preAllocDataList, this.preFreeDataList);
    }

    private void updateStatisticDataAllocs(Map<Integer, List<Object>> libStatisticMap, int binaryId, long allocSize) {
        if (libStatisticMap.containsKey(binaryId)) {
            List<Object> libstaticdata = libStatisticMap.get(binaryId);
            libstaticdata.set(0, (Long)libstaticdata.get(0) + allocSize);
            libstaticdata.set(1, (Long)libstaticdata.get(1) + 1L);
            libstaticdata.set(3, (Long)libstaticdata.get(3) + allocSize);
            libStatisticMap.put(binaryId, libstaticdata);
        } else {
            libStatisticMap.put(binaryId, Arrays.asList(allocSize, 1L, 0L, allocSize));
        }
    }

    private void updateStatisticDataFrees(Map<Integer, List<Object>> libStatisticMap, int binaryId, long freeSize) {
        if (libStatisticMap.containsKey(binaryId)) {
            List<Object> libstaticdata = libStatisticMap.get(binaryId);
            libstaticdata.set(0, (Long)libstaticdata.get(0) - freeSize);
            libstaticdata.set(1, (Long)libstaticdata.get(1) - 1L);
            libstaticdata.set(2, (Long)libstaticdata.get(2) + 1L);
            libStatisticMap.put(binaryId, libstaticdata);
        }
    }

    private Map<Integer, Map<Integer, List<Object>>> makeRemainedAllocatedStatic(List<List<Object>> allocData, List<List<Object>> freeData) {
        List onedata;
        long address;
        HashMap addressMap = new HashMap();
        HashMap<Integer, Map<Integer, List<Object>>> pidStatisticMap = new HashMap<Integer, Map<Integer, List<Object>>>();
        HashMap<Integer, List<Object>> libStatisticMapTotal = new HashMap<Integer, List<Object>>();
        pidStatisticMap.put(-1, libStatisticMapTotal);
        int allocDataSize = allocData.size();
        int j = 0;
        while (j < allocDataSize) {
            List<Object> iAllocData = allocData.get(j);
            address = (Long)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_ADDRESS.index);
            long alloctime = (Long)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_TIME.index);
            long allocSize = (Long)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_MEMORY_SIZE.index);
            int binaryId = (Integer)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.CALLER_LIBRARY_ID.index);
            int pid = (Integer)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.PID.index);
            if (!addressMap.containsKey(address)) {
                ArrayList newlist = new ArrayList();
                addressMap.put(address, newlist);
            }
            onedata = new ArrayList<Number>();
            onedata.add(alloctime);
            onedata.add(allocSize);
            onedata.add(binaryId);
            ((List)addressMap.get(address)).add(onedata);
            if (!pidStatisticMap.containsKey(pid)) {
                pidStatisticMap.put(pid, new HashMap());
            }
            this.updateStatisticDataAllocs((Map)pidStatisticMap.get(pid), binaryId, allocSize);
            this.updateStatisticDataAllocs(libStatisticMapTotal, binaryId, allocSize);
            ++j;
        }
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            address = (Long)iFreeData.get(MemFreeDBTable.BASIC_COLUMN.ALLOCATED_ADDRESS.index);
            long freetime = (Long)iFreeData.get(MemFreeDBTable.BASIC_COLUMN.FREE_TIME.index);
            int pid = (Integer)iFreeData.get(MemFreeDBTable.BASIC_COLUMN.PID.index);
            Map libStatisticMapPid = (Map)pidStatisticMap.get(pid);
            if (addressMap.containsKey(address)) {
                int size = ((List)addressMap.get(address)).size();
                int removeindex = 0;
                while (removeindex < size) {
                    onedata = (List)((List)addressMap.get(address)).get(removeindex);
                    if ((Long)onedata.get(0) <= freetime) {
                        long freeSize = (Long)onedata.get(1);
                        int binaryId = (Integer)onedata.get(2);
                        this.updateStatisticDataFrees(libStatisticMapPid, binaryId, freeSize);
                        this.updateStatisticDataFrees(libStatisticMapTotal, binaryId, freeSize);
                        ((List)addressMap.get(address)).remove(removeindex);
                        break;
                    }
                    ++removeindex;
                }
            }
            ++i;
        }
        return pidStatisticMap;
    }

    private List<List<Object>> makeRemainedAllocatedList(List<List<Object>> allocData, List<List<Object>> freeData) {
        HashMap addressMap = new HashMap();
        ArrayList<List<Object>> output = new ArrayList<List<Object>>();
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            long freetime = (Long)iFreeData.get(MemFreeDBTable.BASIC_COLUMN.FREE_TIME.index);
            long address = (Long)iFreeData.get(MemFreeDBTable.BASIC_COLUMN.ALLOCATED_ADDRESS.index);
            if (!addressMap.containsKey(address)) {
                ArrayList newlist = new ArrayList();
                addressMap.put(address, newlist);
            }
            ((List)addressMap.get(address)).add(freetime);
            ++i;
        }
        int allocDataSize = allocData.size();
        int i2 = 0;
        while (i2 < allocDataSize) {
            List<Object> iAllocData = allocData.get(i2);
            boolean live = true;
            long alloctime = (Long)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_TIME.index);
            long address = (Long)iAllocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_ADDRESS.index);
            if (addressMap.containsKey(address)) {
                int size = ((List)addressMap.get(address)).size();
                int j = 0;
                while (j < size) {
                    Long freetime = (Long)((List)addressMap.get(address)).get(j);
                    if (alloctime <= freetime) {
                        live = false;
                        ((List)addressMap.get(address)).remove(j);
                        break;
                    }
                    ++j;
                }
            }
            if (live) {
                output.add(iAllocData);
            }
            ++i2;
        }
        return output;
    }

    private String getDisplayedEntryName(String apiName, boolean isProcess) {
        if (isProcess) {
            return "PID #" + apiName;
        }
        if (apiName.equals(Global.getProject().getApplicationInfo().getExecPath())) {
            return MemoryPageLabels.MEMORY_MAIN_EXCUTABLE;
        }
        return apiName;
    }

    public TreeInput makeTreeInputForDatas(String apiName, boolean isProcess, List<Object> staticdata, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (staticdata == null) {
            Logger.error((String)"No statistics data for '%d' entry!", (Object[])new Object[]{apiName});
            return null;
        }
        String entryName = this.getDisplayedEntryName(apiName, isProcess);
        Long PByte = (Long)staticdata.get(0);
        Long PCount = (Long)staticdata.get(1);
        Long FCount = (Long)staticdata.get(2);
        Long TotalByte = (Long)staticdata.get(3);
        Long TotalCount = PCount + FCount;
        text.add(entryName);
        data.add(apiName);
        text.add(String.format("%,d", TotalCount));
        data.add(TotalCount);
        text.add(String.format("%,d", FCount));
        data.add(FCount);
        text.add(String.format("%,d", PCount));
        data.add(PCount);
        text.add(Formatter.toByteFormat(TotalByte));
        data.add(TotalByte);
        text.add(Formatter.toByteFormat(PByte));
        data.add(PByte);
        tableData.getData().addAll(data);
        tableData.setObject(entryName);
        TreeInput output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        return output;
    }

    public TableInput makePersistentAllocsTableInput(List<Object> allocData, int index, boolean onlyLeaks) {
        Project project;
        boolean isMainBinary;
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (allocData == null) {
            Logger.error((Object)"very strange case !!");
            return null;
        }
        Long seq = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.SEQUENCE_NUMBER.index);
        text.add(Long.toString(seq));
        data.add(seq);
        long time = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_TIME.index);
        data.add(time);
        try {
            text.add(Formatter.toTimeFormat(time));
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            text.add(Long.toString(time));
        }
        int pid = (Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.PID.index);
        text.add(Integer.toString(pid));
        data.add(pid);
        int tid = (Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.TID.index);
        text.add(Integer.toString(tid));
        data.add(tid);
        Long address = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_ADDRESS.index);
        text.add("0x" + Long.toHexString(address));
        data.add(address);
        Long size = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_MEMORY_SIZE.index);
        text.add(Long.toString(size));
        data.add(size);
        String libName = Global.getLibraryName((Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.CALLER_LIBRARY_ID.index));
        if (libName == null || libName.isEmpty()) {
            libName = "unknown";
        }
        boolean bl = isMainBinary = (project = Global.getProject()) != null && project.getApplicationInfo() != null && project.getApplicationInfo().getExecBinaryPath().equals(libName);
        if (onlyLeaks && !isMainBinary) {
            return null;
        }
        text.add(libName);
        data.add(libName);
        int apiId = (Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.API_ID.index);
        String apiName = Global.getFunctionName(apiId);
        text.add(apiName);
        data.add(apiName);
        if (!onlyLeaks) {
            boolean leak = false;
            if (isMainBinary && SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER)) {
                this.updateLeaksCache(new Query(0L, 0L));
                leak = this.preLeaksAllocDataList.contains(allocData);
            }
            text.add(leak ? "Yes" : "");
            data.add(leak ? "Yes" : "");
        }
        tableData.setType(4099);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }

    /*
     * Exception decompiling
     */
    public void parseLSanReportFile(String filepath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Logs getLogsFromLogPackage(LogPackage logPack, int logCenterConstants) {
        Logs logs = logPack.getLogs(logCenterConstants);
        if (logs == null || logs.getRawLogs().size() == 0) {
            return null;
        }
        return logs;
    }

    private boolean isAllocatorAddrSupported() {
        Protocol projectProtocol = Global.getCurrentProtocol();
        return projectProtocol.getVersionNum() >= Protocol.VERSION_42.getVersionNum();
    }

    private long getAllocatorAddress(MemoryData logData) {
        if (!this.isAllocatorAddrSupported()) {
            return 0L;
        }
        int reserved1 = logData.getReserved1();
        int reserved2 = logData.getReserved2();
        long allocatorAddress = (long)reserved2 << 32 | (long)reserved1 & 0xFFFFFFFFL;
        return allocatorAddress;
    }

    private void makeHeapData(Logs alloclogs) {
        List<LogData> memoryLogList;
        List<LogData> list = memoryLogList = alloclogs == null ? null : alloclogs.getRawLogs();
        if (memoryLogList == null) {
            return;
        }
        Collections.sort(memoryLogList, new AscCompare());
        int size = memoryLogList.size();
        int i = 0;
        while (i < size) {
            MemoryData logData = (MemoryData)memoryLogList.get(i);
            long errorNo = logData.getErrno();
            if (errorNo == 0L) {
                int memApiType = logData.getMemoryApiType();
                int pid = logData.getPid();
                long calleraddress = logData.getCallerPcAddr();
                int binaryid = Global.getBinaryID(pid, logData.getTime(), calleraddress);
                if (memApiType == 0) {
                    long allocatorAddr = this.getAllocatorAddress(logData);
                    this.makeAllocData(logData, binaryid, allocatorAddr);
                } else if (1 == memApiType) {
                    this.makeFreeData(logData, binaryid);
                }
            }
            ++i;
        }
        if (this.memoryAllocDataList.size() > 0) {
            List mList = (List)this.memoryAllocDataList.clone();
            this.memoryAllocDataList.clear();
            this.allocateDBInserter.pushData(mList);
        }
        if (this.memoryfreeDataList.size() > 0) {
            List fList = (List)this.memoryfreeDataList.clone();
            this.memoryfreeDataList.clear();
            this.freeDBInserter.pushData(fList);
        }
    }

    private void makeAllocData(MemoryData mData, int binaryid, long allocatorAddr) {
        ArrayList<Number> dbAllocData = new ArrayList<Number>();
        int pid = mData.getPid();
        int tid = mData.getTid();
        long address = mData.getAddress();
        long mallocsize = mData.getSize();
        if (this.REALLOC_ID == mData.getApiId()) {
            try {
                Long freeaddress = Long.parseLong(mData.getArgs().replace("0x", "").split(",")[0], 16);
                this.makeFreeData(mData, freeaddress, binaryid);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.warning((String)"realloc address invalide : %s", (Object[])new Object[]{mData.getArgs()});
            }
        }
        dbAllocData.add(mData.getSeq());
        dbAllocData.add(pid);
        dbAllocData.add(tid);
        dbAllocData.add(mData.getApiId());
        dbAllocData.add(mData.getMemoryApiType());
        dbAllocData.add(address);
        dbAllocData.add(mData.getTime());
        dbAllocData.add(mData.getCallerPcAddr());
        dbAllocData.add(binaryid);
        dbAllocData.add(mData.getMsgID());
        dbAllocData.add(mallocsize);
        dbAllocData.add(allocatorAddr == 0L ? null : Long.valueOf(allocatorAddr));
        this.memoryAllocDataList.add(dbAllocData);
    }

    private void makeFreeData(MemoryData mData, int binaryid) {
        this.makeFreeData(mData, mData.getAddress(), binaryid);
    }

    private void makeFreeData(MemoryData mData, Long address, int binaryid) {
        ArrayList<Number> dbFreeData = new ArrayList<Number>();
        int pid = mData.getPid();
        dbFreeData.add(mData.getSeq());
        dbFreeData.add(pid);
        dbFreeData.add(mData.getMsgID());
        dbFreeData.add(mData.getTime());
        dbFreeData.add(address);
        dbFreeData.add(binaryid);
        this.memoryfreeDataList.add(dbFreeData);
    }

    private String getTimeWhereQuery(Query query, String timecolumn, boolean onlyLeaks) {
        StringBuilder where = new StringBuilder();
        if (onlyLeaks) {
            String table1 = "table1";
            String table2 = "table2";
            String joinCol = MemLSanTable.COLUMN.ALLOCATED_ADDRESS.name;
            String join = String.format("%s INNER JOIN %s %s ON %s.%s = %s.%s ", table1, "MEM_LSAN_DB", table2, table1, joinCol, table2, joinCol);
            where.append(join);
        }
        where.append("WHERE ");
        if (query.startTime != 0L || query.endTime != 0L) {
            String timeRange = String.format("%s BETWEEN %s AND %s AND ", timecolumn, Long.toString(query.startTime), Long.toString(query.endTime));
            where.append(timeRange);
        }
        where.append(String.format("PID IN %s", query.pidString));
        return where.toString();
    }

    private void updateFullAllocCache(Query query) {
        if (this.lastFullAllocsQuery.equals(query)) {
            return;
        }
        this.lastFullAllocsQuery = query;
        this.preAllocDataList = this.getAllocationDataFromDB(this.lastFullAllocsQuery, false);
        this.preFreeDataList = this.getFreeDataFromDB(this.lastFullAllocsQuery, false);
    }

    private void updateLeaksCache(Query query) {
        if (this.lastLeaksQuery.equals(query)) {
            return;
        }
        this.lastLeaksQuery = query;
        this.preLeaksAllocDataList = this.getAllocationDataFromDB(this.lastLeaksQuery, true);
        this.preLeaksFreeDataList = this.getFreeDataFromDB(this.lastLeaksQuery, true);
    }

    private static class AscCompare
    implements Comparator<LogData> {
        private AscCompare() {
        }

        @Override
        public int compare(LogData arg0, LogData arg1) {
            return Long.compare(arg0.getSeq(), arg1.getSeq());
        }
    }

    private static class Query {
        public long startTime;
        public long endTime;
        public String pidString;

        public Query() {
            this.clear();
        }

        public Query(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.pidString = Query.getTargetPIDString();
        }

        public void clear() {
            this.startTime = -1L;
            this.endTime = -1L;
            this.pidString = "";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
            result = 31 * result + (this.pidString == null ? 0 : this.pidString.hashCode());
            result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Query)) {
                return false;
            }
            Query other = (Query)obj;
            if (this.endTime != other.endTime) {
                return false;
            }
            if (this.pidString == null ? other.pidString != null : !this.pidString.equals(other.pidString)) {
                return false;
            }
            return this.startTime == other.startTime;
        }

        private static String getTargetPIDString() {
            StringBuilder pidliststring = new StringBuilder();
            pidliststring.append("(");
            int targetPID = Toolbar.INSTANCE.getSelectedPid();
            if (targetPID > 0) {
                pidliststring.append(targetPID);
            } else {
                int[] nArray = Global.getProject().getProcessIDs();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int pid = nArray[n2];
                    if (pidliststring.length() != 1) {
                        pidliststring.append(",");
                    }
                    pidliststring.append(pid);
                    ++n2;
                }
            }
            pidliststring.append(")");
            return pidliststring.toString();
        }
    }
}

