/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DeviceChartRenderer;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class DeviceChart
extends TimelineChart {
    private static final String EMPTY = "";
    private static final String OFF = "Off";
    private static final String ON = "On";
    private static final String CONNECTED = "Connected";
    private static final String UNCONNECTED = "Unconnected";
    private static final String TRANSFER = "Transfer";
    private static final String VISIBLE = "Visible";
    private static final String SEARCHING = "Searching";
    private static final String NORMAL_CONNECTED = "Normal connected";
    private static final String SECURE_CONNECTED = "Secure connected";
    private static final String OPEN = "Open";
    private static final String PREVIEW = "Preview";
    private static final String RECORDING = "Recording";
    private static final String RECORDING_PAUSE = "Recording pause";
    private DAChartSeries wifiSeries;
    private DAChartSeries bluetoothSeries;
    private DAChartSeries gpsSeries;
    private DAChartSeries dnetSeries;
    private DAChartSeries cameraSeries;
    public static final String[] WIFI_STATES = new String[]{"Off", "Unconnected", "Connected", "Transfer"};
    public static final String[] BLUETOOTH_STATES = new String[]{"Off", "On", "Visible", "", "Transfer"};
    public static final String[] GPS_STATES = new String[]{"Off", "Searching", "Connected"};
    public static final String[] DNET_STATES = new String[]{"Off", "Normal connected", "Secure connected", "Transfer"};
    public static final String[] CAMERA_STATES = new String[]{"Off", "Open", "Preview", "Recording", "Recording pause"};

    public DeviceChart(String pageID) {
        super(pageID);
        this.chartType = -112;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.DEVICE_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.DEVICE_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_DEVICE_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_DEVICE_SMALL_NOR;
        this.wifiSeries = new DAChartSeries(TimelineChartLabels.DEVICE_CHART_SERIES_WIFI, 0, ColorResources.CHART_SERIES_BLUE);
        this.bluetoothSeries = new DAChartSeries(TimelineChartLabels.DEVICE_CHART_SERIES_BLUETOOTH, 0, ColorResources.CHART_SERIES_EMERALD);
        this.gpsSeries = new DAChartSeries(TimelineChartLabels.DEVICE_CHART_SERIES_GPS, 0, ColorResources.CHART_SERIES_RED);
        this.dnetSeries = new DAChartSeries(TimelineChartLabels.DEVICE_CHART_SERIES_DNET, 0, ColorResources.CHART_SERIES_YELLOW);
        this.cameraSeries = new DAChartSeries(TimelineChartLabels.DEVICE_CHART_SERIES_CAMERA, 0, ColorResources.CHART_SERIES_YELLOWGREEN);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        this.chart.addSeries(this.wifiSeries);
        this.chart.addSeries(this.bluetoothSeries);
        this.chart.addSeries(this.gpsSeries);
        this.chart.addSeries(this.dnetSeries);
        this.chart.addSeries(this.cameraSeries);
        this.chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        this.chart.getPlot().setShowAxis(false);
        this.chart.setChartRenderer((DAChartRenderer)new DeviceChartRenderer());
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.wifiSeries.clear();
        this.bluetoothSeries.clear();
        this.gpsSeries.clear();
        this.dnetSeries.clear();
        this.cameraSeries.clear();
        List data = (List)dataList.get(0);
        int i = 0;
        while (i < data.size()) {
            List row = (List)data.get(i);
            double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            List statusList = (List)row.get(SystemDataDBTable.COLUMN.DEVICE_STATUS.ordinal());
            int wifi = (Integer)statusList.get(SystemData.DEVICE_STATUS.WIFI.ordinal());
            int bluetooth = (Integer)statusList.get(SystemData.DEVICE_STATUS.BLUETOOTH.ordinal());
            int gps = (Integer)statusList.get(SystemData.DEVICE_STATUS.GPS.ordinal());
            int dnet = (Integer)statusList.get(SystemData.DEVICE_STATUS.DNET.ordinal());
            int camera = (Integer)statusList.get(SystemData.DEVICE_STATUS.CAMERA.ordinal());
            if (wifi < WIFI_STATES.length) {
                this.wifiSeries.addSeriesItem(new DAChartSeriesItem(time, (double)wifi, WIFI_STATES[wifi]));
            }
            if (bluetooth < BLUETOOTH_STATES.length) {
                this.bluetoothSeries.addSeriesItem(new DAChartSeriesItem(time, (double)bluetooth, BLUETOOTH_STATES[bluetooth]));
            }
            if (gps < GPS_STATES.length) {
                this.gpsSeries.addSeriesItem(new DAChartSeriesItem(time, (double)gps, GPS_STATES[gps]));
            }
            if (dnet < DNET_STATES.length) {
                this.dnetSeries.addSeriesItem(new DAChartSeriesItem(time, (double)dnet, DNET_STATES[dnet]));
            }
            if (camera < CAMERA_STATES.length) {
                this.cameraSeries.addSeriesItem(new DAChartSeriesItem(time, (double)camera, CAMERA_STATES[camera]));
            }
            ++i;
        }
    }
}

