/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface.profiling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceNotFoundException;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.profiling.UIFunctionProfilingData;
import org.tizen.dynamicanalyzer.ui.userinterface.profiling.UIFunctionProfilingTreeSetData;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class UIFunctionProfilingDataChecker {
    List<UIFunctionProfilingData> profilingList;
    private static TreeSet<UIFunctionProfilingTreeSetData> userInterfaceFunctionTree = new TreeSet();
    static boolean InitUIApiList = false;
    static List<String> isUiApiCheckList = new ArrayList<String>();
    static final String UI_API_TRUE = "true";
    static final String UI_API_FALSE = "false";
    static int nUserProfilingDataCount = 0;

    public boolean addProfilingData(ProfilingData input) {
        this.getUIApiListFile();
        boolean bTreeSearch = userInterfaceFunctionTree.contains(this.makeTreeSetData(input.getName()));
        if (bTreeSearch) {
            int nChangedIndex = 0;
            boolean bUpdateData = false;
            if (!this.existRootData(input)) {
                this.makeRootParentData(input);
            }
            int nListSize = this.getDataList().size();
            int i = 0;
            while (i < nListSize) {
                String apiName = this.getDataList().get(i).getAPIName();
                if (apiName != null && apiName.equals(input.getName())) {
                    this.getDataList().remove(i);
                    nChangedIndex = i;
                    bUpdateData = true;
                    break;
                }
                ++i;
            }
            UIFunctionProfilingData pd = new UIFunctionProfilingData();
            int pid = input.getProfileDataMaker().getPid();
            ProfileDataMaker profiler = FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pid);
            String exTime = "-";
            String inTime = "-";
            String exeTime = "-";
            String inExeTime = "-";
            String exAvgTime = "-";
            String inAvgTime = "-";
            String exeAvgTime = "-";
            String inExeAvgTime = "-";
            try {
                exTime = profiler.getCpuTime(input, true);
                exAvgTime = this.getAvgTime(Integer.parseInt(exTime), input.getCallCount(), 2);
                exTime = Formatter.toTimeFormat2(exTime);
                inTime = profiler.getCpuTime(input, false);
                inAvgTime = this.getAvgTime(Integer.parseInt(inTime), input.getCallCount(), 2);
                inTime = Formatter.toTimeFormat2(inTime);
                exeTime = Formatter.toTimeFormat4(input.getElapsedTime());
                exeAvgTime = this.getAvgTime(input.getElapsedTime(), input.getCallCount(), 1);
                inExeTime = Formatter.toTimeFormat4(input.getExclusiveElapsedTime());
                inExeAvgTime = this.getAvgTime(input.getExclusiveElapsedTime(), input.getCallCount(), 1);
            }
            catch (NumberFormatException e) {
                Logger.exception((Throwable)e);
            }
            pd.setPid(input.getProfileDataMaker().getPid());
            pd.setUIFunctionDataID(input.getProfilingDataID());
            pd.setKey(input.getKey());
            pd.setAPIName(input.getName());
            pd.setExclCPUTime(exTime);
            pd.setInclCPUTime(inTime);
            pd.setInclElapsedTime(exeTime);
            pd.setExclElapsedTime(inExeTime);
            pd.setExclCPUAvgTime(exAvgTime);
            pd.setInclCPUAvgTime(inAvgTime);
            pd.setInclElapsedAvgTime(exeAvgTime);
            pd.setExclElapsedAvgTime(inExeAvgTime);
            pd.setParent(input.getParent());
            if (bUpdateData) {
                this.getDataList().add(nChangedIndex, pd);
            } else {
                this.getDataList().add(pd);
            }
            return true;
        }
        return false;
    }

    public UIFunctionProfilingDataChecker() {
        this.getUIApiListFile();
    }

    public synchronized List<UIFunctionProfilingData> getDataList() {
        if (this.profilingList == null) {
            this.profilingList = new ArrayList<UIFunctionProfilingData>();
        }
        return this.profilingList;
    }

    public void updateUIApiTreeSet() {
        List<Integer> pids = FunctionUsageProfiler.getInstance().getPidsOfProfileDataMakerMap();
        int i = 0;
        while (i < pids.size()) {
            ProfileDataMaker profiler = FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pids.get(i));
            if (profiler.getAppBin() == null) {
                return;
            }
            List<ProfilingData> children = profiler.getAppBin().getChildList().get(0).getChildList();
            int size = children.size();
            this.getUIApiListFile();
            int j = 0;
            while (j < size) {
                if (j >= isUiApiCheckList.size()) {
                    isUiApiCheckList.add(j, UI_API_TRUE);
                }
                if (isUiApiCheckList.get(j).equals(UI_API_TRUE)) {
                    ProfilingData data = children.get(j);
                    if (this.addProfilingData(data)) {
                        isUiApiCheckList.add(j, UI_API_TRUE);
                    } else {
                        isUiApiCheckList.add(j, UI_API_FALSE);
                    }
                }
                ++j;
            }
            UIDataManager tManager = UIDataManager.getInstance();
            tManager.getControlDataChecker().notificationFromUserInterfaceFunctionProfilingDataChecker();
            ++i;
        }
    }

    public void cleanUIProfilingMemberData() {
        isUiApiCheckList = null;
        isUiApiCheckList = new ArrayList<String>();
        nUserProfilingDataCount = 0;
    }

    private String getAvgTime(long nTime, int nCount, int nType) {
        String strRetrun = "00.000";
        long time = -1L;
        if (nTime == 0L) {
            return strRetrun;
        }
        time = nCount == 0 ? nTime : nTime / (long)nCount;
        strRetrun = nType == 1 ? Formatter.toTimeFormat4(time) : Formatter.toTimeFormat2(time);
        return strRetrun;
    }

    public boolean existRootData(ProfilingData input) {
        boolean existRootData = false;
        for (UIFunctionProfilingData data : this.getDataList()) {
            if (!data.getAPIName().equals(input.getParent())) continue;
            existRootData = true;
            break;
        }
        return existRootData;
    }

    private void makeRootParentData(ProfilingData input) {
        UIFunctionProfilingData pd = new UIFunctionProfilingData();
        String exTime = "-";
        String inTime = "-";
        String exeTime = "-";
        String inExeTime = "-";
        String exAvgTime = "-";
        String inAvgTime = "-";
        String exeAvgTime = "-";
        String inExeAvgTime = "-";
        pd.setPid(input.getProfileDataMaker().getPid());
        pd.setUIFunctionDataID(0);
        pd.setKey(input.getKey());
        pd.setAPIName(input.getParent());
        pd.setParent("");
        pd.setExclCPUTime(exTime);
        pd.setInclCPUTime(inTime);
        pd.setInclElapsedTime(exeTime);
        pd.setExclElapsedTime(inExeTime);
        pd.setExclCPUAvgTime(exAvgTime);
        pd.setInclCPUAvgTime(inAvgTime);
        pd.setInclElapsedAvgTime(exeAvgTime);
        pd.setExclElapsedAvgTime(inExeAvgTime);
        this.getDataList().add(pd);
    }

    private UIFunctionProfilingTreeSetData makeTreeSetData(String inputData) {
        UIFunctionProfilingTreeSetData returnData = null;
        if (inputData.contains("(")) {
            String[] splitInpuDataList = inputData.split("\\(");
            String strApiName = null;
            String[] splitApiNameAndReturnValues = splitInpuDataList[0].split(" ");
            if (splitApiNameAndReturnValues[splitApiNameAndReturnValues.length - 1].contains("::")) {
                String[] apiNameList = splitApiNameAndReturnValues[splitApiNameAndReturnValues.length - 1].split("::");
                strApiName = new String(apiNameList[apiNameList.length - 1].trim());
            } else {
                strApiName = new String(splitApiNameAndReturnValues[splitApiNameAndReturnValues.length - 1].trim());
            }
            String strParameter = new String(splitInpuDataList[splitInpuDataList.length - 1].trim());
            if (strParameter.contains(",")) {
                String[] splitParameterList = strParameter.split(",");
                returnData = new UIFunctionProfilingTreeSetData(strApiName, splitParameterList);
            } else {
                String[] splitParameterList = strParameter.split("\\)");
                returnData = strParameter.contains("void") ? new UIFunctionProfilingTreeSetData(strApiName, null) : (splitParameterList.length == 0 ? new UIFunctionProfilingTreeSetData(strApiName, null) : new UIFunctionProfilingTreeSetData(strApiName, splitParameterList));
            }
        } else {
            returnData = new UIFunctionProfilingTreeSetData(inputData, null);
        }
        return returnData;
    }

    private void getUIApiListFile() {
        String platform;
        if (InitUIApiList) {
            return;
        }
        InitUIApiList = true;
        boolean isEmulator = false;
        try {
            if (!DACommunicator.isEmulator()) {
                isEmulator = true;
            }
        }
        catch (DeviceNotFoundException deviceNotFoundException) {
            Logger.warning((Object)"Device is not found");
        }
        if ((platform = SettingDataManager.INSTANCE.getPlatform()) == null) {
            return;
        }
        String sourcePath = PathManager.getTizenHeaderPath((boolean)isEmulator, (String)platform);
        File sourceFolder = new File(sourcePath);
        if (!sourceFolder.exists() && !sourceFolder.isDirectory()) {
            Logger.debug((Object)("Not Found the tizen_header_file folder : " + sourcePath));
            return;
        }
        String uiFileOptionList = null;
        String uiApiOptionList = null;
        String uiOptionList = this.getUIApiOptionList();
        if (uiOptionList == null) {
            return;
        }
        if (!uiOptionList.contains(";")) {
            return;
        }
        String[] splitInpuDataList = uiOptionList.split(";");
        int i = 0;
        while (i < splitInpuDataList.length) {
            String[] splitDataList;
            if (splitInpuDataList[i].contains("file")) {
                if (!splitInpuDataList[i].contains("::")) {
                    return;
                }
                splitDataList = splitInpuDataList[i].split("::");
                uiFileOptionList = splitDataList[splitDataList.length - 1];
            } else {
                if (!splitInpuDataList[i].contains("::")) {
                    return;
                }
                splitDataList = splitInpuDataList[i].split("::");
                uiApiOptionList = splitDataList[splitDataList.length - 1];
            }
            ++i;
        }
        if (uiFileOptionList == null) {
            return;
        }
        if (!uiFileOptionList.contains("`,")) {
            return;
        }
        String[] splitUiFileOptionList = uiFileOptionList.split("`,");
        if (uiApiOptionList == null) {
            return;
        }
        if (!uiApiOptionList.contains("`,")) {
            return;
        }
        String[] splitUiApiOptionList = uiApiOptionList.split("`,");
        File[] files = sourceFolder.listFiles();
        if (files == null) {
            return;
        }
        String filename = null;
        int filelength = files.length;
        int i2 = 0;
        while (i2 < filelength) {
            block27: {
                filename = files[i2].getName();
                if (this.isOptionValue(splitUiFileOptionList, filename)) {
                    BufferedReader in = null;
                    try {
                        String content;
                        in = new BufferedReader(new FileReader(files[i2]));
                        while ((content = in.readLine()) != null) {
                            String strInputData;
                            if (content.equals("") || !(strInputData = content.trim()).startsWith("virtual") || !this.isOptionValue(splitUiApiOptionList, strInputData)) continue;
                            userInterfaceFunctionTree.add(this.makeTreeSetData(strInputData));
                        }
                    }
                    catch (FileNotFoundException e) {
                        Logger.exception((Throwable)e);
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        break block27;
                    }
                    catch (IOException e) {
                        try {
                            Logger.exception((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            CommonUtil.tryClose((Object[])new Object[]{in});
                            throw throwable;
                        }
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        break block27;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{in});
                }
            }
            ++i2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOptionValue(String[] optionList, String strCmp) {
        boolean bSucces = true;
        int j = 0;
        while (j < optionList.length) {
            int chartIndex;
            if (optionList[j].contains("+")) {
                chartIndex = optionList[j].indexOf("+");
                String uiAddOption = optionList[j].substring(chartIndex + 1).trim();
                if (!strCmp.contains(uiAddOption)) return false;
                bSucces = true;
            } else {
                chartIndex = optionList[j].indexOf("-");
                String uiMinusOption = optionList[j].substring(chartIndex + 1).trim();
                if (strCmp.contains(uiMinusOption)) {
                    bSucces = false;
                }
            }
            ++j;
        }
        return bSucces;
    }

    private String getUIApiOptionList() {
        String uiApiOptionList;
        block9: {
            uiApiOptionList = null;
            String configFileName = "user_interface_api_list";
            File configFolder = new File(PathManager.DA_CONFIG_FOLDER_PATH);
            if (!configFolder.isDirectory()) {
                Logger.debug((Object)"Not Exist UI API List Option Path ");
                return "";
            }
            File apiListFile = new File(configFolder, configFileName);
            if (!apiListFile.isFile()) {
                Logger.debug((Object)"Not Exist UI API List Option File");
                return "";
            }
            BufferedReader in = null;
            try {
                String content;
                in = new BufferedReader(new FileReader(apiListFile));
                StringBuffer inputData = new StringBuffer();
                while ((content = in.readLine()) != null) {
                    if (content.equals("")) continue;
                    inputData.append(content);
                }
                uiApiOptionList = inputData.toString();
            }
            catch (FileNotFoundException e) {
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
        return uiApiOptionList;
    }

    private String getClassName(List<String> dataFormat) {
        String[] splitApiNameList = dataFormat.get(2).split("::");
        if (splitApiNameList.length - 2 < 0) {
            return "";
        }
        String className = new String(splitApiNameList[splitApiNameList.length - 2].trim());
        return className;
    }
}

