/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;

public abstract class DATreeComposite
extends DATableComposite {
    List<Long> selSeqs = null;
    GridItem[] selections = null;
    int[] sels = null;
    int gridItemCount = -1;
    int selIndex = 0;
    int focusIndex = -1;
    private boolean defaultExpansionState = true;
    private HashMap<Long, Boolean> expandMap = null;

    public DATreeComposite(Composite parent, int style) {
        this(parent, 0, style);
    }

    public DATreeComposite(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.applyFilterImage();
        this.table.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                GridItem item = (GridItem)event.item;
                DATreeComposite.this.setExpand(item, true);
            }
        });
        this.table.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                GridItem item = (GridItem)event.item;
                DATreeComposite.this.setExpand(item, false);
            }
        });
    }

    public boolean getDefaultExpansionState() {
        return this.defaultExpansionState;
    }

    public void setDefaultExpansionState(boolean defaultExpansionState) {
        this.defaultExpansionState = defaultExpansionState;
    }

    protected HashMap<Long, Boolean> getExpandMap() {
        if (this.expandMap == null) {
            this.expandMap = new HashMap();
        }
        return this.expandMap;
    }

    public void setExpand(GridItem item, boolean expand) {
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        long seqNum = tableData.getSelectionKey();
        this.getExpandMap().put(seqNum, expand);
    }

    private GridItem makeTreeItem(Object parent, TreeInput input) {
        GridItem gridItem = null;
        if (parent instanceof Grid) {
            gridItem = new GridItem((Grid)parent, 0);
        } else if (parent instanceof GridItem) {
            gridItem = new GridItem((GridItem)parent, 0);
        } else {
            Logger.debug((Object)"it is bug!! need debug - DATreeComposite makeTreeItem");
            return null;
        }
        DATableDataFormat gridData = (DATableDataFormat)input.getData();
        gridItem.setData((Object)gridData);
        List<String> text = input.getText();
        List<Image> images = input.getImages();
        int size = text.size();
        int i = 0;
        while (i < size) {
            gridItem.setText(i, text.get(i));
            if (images != null && !images.isEmpty()) {
                gridItem.setImage(i, images.get(i));
            }
            ++i;
        }
        if (input.isInRange() && input.isSecondSelection()) {
            gridItem.setBackground(this.intersectColor);
        } else if (input.isSecondSelection()) {
            gridItem.setBackground(this.secondSelectionColor);
        } else if (input.isInRange()) {
            gridItem.setBackground(this.rangeColor);
        }
        ++this.gridItemCount;
        int ii = 0;
        while (ii < this.selSeqs.size()) {
            if (gridData.getSelectionKey() == this.selSeqs.get(ii).longValue()) {
                this.sels[this.selIndex++] = this.gridItemCount;
                this.selSeqs.remove(ii);
            }
            ++ii;
        }
        if (-1L != this.focusSeq && gridData.getSelectionKey() == this.focusSeq) {
            this.focusIndex = this.gridItemCount;
        }
        return this.checkExpand(gridItem, gridData);
    }

    protected GridItem checkExpand(GridItem gridItem, DATableDataFormat gridData) {
        long seq = gridData.getSelectionKey();
        Boolean expand = this.getExpandMap().get(seq);
        if (expand == null) {
            gridItem.setExpanded(this.defaultExpansionState);
            this.expandMap.put(seq, this.defaultExpansionState);
        } else {
            gridItem.setExpanded(expand.booleanValue());
        }
        return gridItem;
    }

    private void createTree(List<TreeInput> input, Object parent) {
        if (this.comparator != null) {
            Collections.sort(input, this.comparator);
        }
        int rootSize = input.size();
        int i = 0;
        while (i < rootSize) {
            TreeInput treeInput = input.get(i);
            GridItem gridItem = this.makeTreeItem(parent, treeInput);
            List<TreeInput> children = treeInput.getChildren();
            if (!children.isEmpty()) {
                this.createTree(children, gridItem);
            }
            ++i;
        }
    }

    @Override
    public void updateTable() {
        this.updateTree();
    }

    public void updateTree() {
        this.selections = this.table.getSelection();
        this.selSeqs = new ArrayList<Long>();
        int i = 0;
        while (i < this.selections.length) {
            DATableDataFormat tableData = (DATableDataFormat)this.selections[i].getData();
            this.selSeqs.add(tableData.getSelectionKey());
            ++i;
        }
        this.table.removeAll();
        List<TreeInput> input = this.makeTreeInput();
        if (input == null) {
            return;
        }
        this.sels = new int[this.selSeqs.size()];
        this.gridItemCount = -1;
        this.selIndex = 0;
        this.createTree(input, this.table);
        this.table.setSelection(this.sels);
        if (this.table.isFocusControl() && this.focusIndex > 0) {
            this.table.setFocusItem(this.table.getItem(this.focusIndex));
        }
        Event event = new Event();
        event.widget = this;
        event.data = this.table.getItems();
        event.type = 1001;
        this.notifyListeners(1001, event);
    }

    @Override
    protected List<TableInput> makeTableInput() {
        this.makeTreeInput();
        return null;
    }

    public abstract List<TreeInput> makeTreeInput();

    @Override
    public void clear() {
        super.clear();
        this.getExpandMap().clear();
    }

    @Override
    protected void initFilterPopupMenu() {
    }
}

