/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TizenAbstractButtonRenderer {
    protected int buttonState = 2;
    protected Composite parentComposite = null;
    protected TizenButton parent;
    protected boolean isFocus = false;
    protected static final int MARGIN = 5;
    protected boolean isWidgetEnable = true;
    protected boolean isMouseOverButton = false;

    TizenAbstractButtonRenderer(TizenButton parent, Composite parentComposite) {
        this.parent = parent;
        this.parentComposite = parentComposite;
        this.parent.getAttribute().setFont(TizenResourceManager.NORMAL_FONT);
    }

    protected Point computeSize(TizenButton button, int wHint, int hHint, boolean changed) {
        this.parent = button;
        Point sizeOfTextAndImages = this.computeSizeOfTextAndImages();
        return new Point(10 + sizeOfTextAndImages.x, 10 + sizeOfTextAndImages.y + 2);
    }

    private Point computeSizeOfTextAndImages() {
        boolean textNotEmpty;
        int width = 0;
        int height = 0;
        boolean bl = textNotEmpty = this.parent.getText() != null && !this.parent.getText().equals("");
        if (textNotEmpty) {
            GC gc = new GC(this.parent);
            Point extent = gc.stringExtent(this.parent.getText());
            gc.dispose();
            width += extent.x;
            height = extent.y;
        }
        Point imageSize = new Point(-1, -1);
        this.computeImageSize(this.extractImage(), imageSize);
        if (imageSize.x != -1) {
            width += imageSize.x;
            height = Math.max(imageSize.y, height);
            if (textNotEmpty) {
                width += 5;
            }
        }
        return new Point(width + 5 + 5, height);
    }

    private Image extractImage() {
        if (this.parent.getImage() == null) {
            return null;
        }
        return this.parent.getImage();
    }

    private void computeImageSize(Image image, Point imageSize) {
        if (image == null) {
            return;
        }
        Rectangle imageBounds = image.getBounds();
        imageSize.x = Math.max(imageBounds.width, imageSize.x);
        imageSize.y = Math.max(imageBounds.height, imageSize.y);
    }

    protected boolean isHover() {
        Point cursorLocationOfDisplay = Display.getCurrent().getCursorLocation();
        Point cursorLocationOfWidget = this.parent.getParent().toControl(cursorLocationOfDisplay);
        return this.parent.getBounds().contains(cursorLocationOfWidget);
    }

    protected boolean isFocus() {
        return this.isFocus;
    }

    protected void drawButton(Event e) {
    }

    protected Listener getMouseListener() {
        return null;
    }

    protected void setEnabled(boolean enabled) {
        this.isWidgetEnable = enabled;
    }

    protected void setButtonState(int buttonState) {
        this.buttonState = buttonState;
    }

    protected int getButtonState() {
        return this.buttonState;
    }

    protected void setBackground(Color color) {
    }

    protected void setForeground(Color color) {
    }

    protected void setSelection(boolean selected) {
    }

    protected boolean getSelection() {
        return false;
    }

    protected boolean setFocus() {
        return false;
    }

    protected boolean removeFocus() {
        return false;
    }
}

