/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenAbstractButtonRenderer;
import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenButtonAttribute;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TizenPushButtonRenderer
extends TizenAbstractButtonRenderer {
    protected final int STATE_NORMAL = 0;
    protected final int STATE_PUSH = 1;
    protected final int STATE_HOVER = 2;
    protected final int STATE_DISABLE = 3;
    protected final int STATE_FOCUS = 4;

    TizenPushButtonRenderer(TizenButton parent, Composite parentComposite) {
        super(parent, parentComposite);
        this.setPushButtonDefaultColors();
        this.setButtonState(0);
    }

    private void setPushButtonDefaultColors() {
        this.setBackGroundColors(TizenResourceManager.PUSH_BUTTON_NORMAL_BG_COLOR, TizenResourceManager.PUSH_BUTTON_SELECT_BG_COLOR, TizenResourceManager.PUSH_BUTTON_HOVER_BG_COLOR, TizenResourceManager.PUSH_BUTTON_DISABLE_BG_COLOR, TizenResourceManager.PUSH_BUTTON_FOCUS_BG_COLOR);
        this.setforeGroundColors(TizenResourceManager.PUSH_BUTTON_NORMAL_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_PUSH_COLOR, TizenResourceManager.PUSH_BUTTON_HOVER_COLOR, TizenResourceManager.PUSH_BUTTON_DISABLE_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_FOCUS_FONT_COLOR);
        this.setlineColors(TizenResourceManager.PUSH_BUTTON_OUTLINE_NORMAL_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_PUSH_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_HOVER_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_DISABLE_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_FOCUS_COLOR);
    }

    private void setBackGroundColors(Color normal, Color push, Color hover, Color disable, Color focus) {
        this.parent.attr.setBackGroundColor(0, normal);
        this.parent.attr.setBackGroundColor(1, push);
        this.parent.attr.setBackGroundColor(2, hover);
        this.parent.attr.setBackGroundColor(3, disable);
        this.parent.attr.setBackGroundColor(4, focus);
    }

    private void setforeGroundColors(Color normal, Color push, Color hover, Color disable, Color focus) {
        this.parent.attr.setForeGroundColor(0, normal);
        this.parent.attr.setForeGroundColor(1, push);
        this.parent.attr.setForeGroundColor(2, hover);
        this.parent.attr.setForeGroundColor(3, disable);
        this.parent.attr.setForeGroundColor(4, focus);
    }

    private void setlineColors(Color normal, Color push, Color hover, Color disable, Color focus) {
        this.parent.attr.setOutlineColor(0, normal);
        this.parent.attr.setOutlineColor(1, push);
        this.parent.attr.setOutlineColor(2, hover);
        this.parent.attr.setOutlineColor(3, disable);
        this.parent.attr.setOutlineColor(4, focus);
    }

    protected void setBackground(Color color) {
        this.setBackGroundColors(color, color, color, color, color);
    }

    protected void setForeground(Color color) {
        this.setforeGroundColors(color, color, color, color, color);
    }

    protected void setSelection(boolean selected) {
        if (selected) {
            this.setButtonState(4);
        } else {
            this.setButtonState(0);
        }
    }

    protected boolean getSelection() {
        return this.buttonState == 2;
    }

    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setButtonState(0);
        } else {
            this.setButtonState(3);
        }
        this.parent.redraw();
    }

    protected boolean setFocus() {
        this.isFocus = true;
        this.setButtonState(2);
        this.parent.redraw();
        return true;
    }

    protected boolean removeFocus() {
        this.isFocus = false;
        this.setButtonState(0);
        this.parent.redraw();
        return false;
    }

    public Listener getMouseListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: 
                    case 32: {
                        if (!TizenPushButtonRenderer.this.isWidgetEnable) break;
                        TizenPushButtonRenderer.this.setButtonState(2);
                        TizenPushButtonRenderer.this.parent.redraw();
                        break;
                    }
                    case 7: {
                        if (!TizenPushButtonRenderer.this.isWidgetEnable) break;
                        TizenPushButtonRenderer.this.setButtonState(0);
                        TizenPushButtonRenderer.this.parent.redraw();
                        break;
                    }
                    case 3: {
                        if (!TizenPushButtonRenderer.this.isWidgetEnable) break;
                        TizenPushButtonRenderer.this.setButtonState(1);
                        TizenPushButtonRenderer.this.parent.redraw();
                        break;
                    }
                    case 4: {
                        if (!TizenPushButtonRenderer.this.isHover()) break;
                        TizenPushButtonRenderer.this.setButtonState(2);
                        TizenPushButtonRenderer.this.parent.redraw();
                        TizenPushButtonRenderer.this.parent.fireSelectionEvent();
                        break;
                    }
                    case 9: {
                        TizenPushButtonRenderer.this.drawButton(event);
                    }
                }
            }
        };
    }

    protected void drawButton(Event e) {
        TizenButton me = (TizenButton)e.widget;
        Rectangle rect = me.getClientArea();
        this.drawBackground(e.gc, rect, this.getButtonState(), this.parent.getAttribute());
        this.drawButtonImage(e.gc, rect, this.parent.getAttribute(), this.getButtonState());
        this.drawBorder(e.gc, rect, this.getButtonState(), this.parent.getAttribute());
        this.drawIcon(e.gc, rect, this.parent.getAttribute());
    }

    private void drawIcon(GC gc, Rectangle parentRect, TizenButtonAttribute attr) {
        Image icon = attr.getIcon();
        if (icon == null) {
            return;
        }
        gc.drawImage(icon, parentRect.x + 2, parentRect.height / 2 - icon.getBounds().height / 2);
    }

    protected void drawBackground(GC gc, Rectangle rect, int state, TizenButtonAttribute attr) {
        if (attr == null || attr.getBackGroundcolor(state) == null) {
            return;
        }
        gc.setBackground(attr.getBackGroundcolor(state));
        gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    private void drawBorder(GC gc, Rectangle rect, int state, TizenButtonAttribute attr) {
        if (attr == null) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.drawButtonText(gc, r, attr, state);
        if (attr.getOutlineColor(state) != null) {
            gc.setForeground(attr.getOutlineColor(state));
        } else {
            gc.setForeground(TizenResourceManager.WHITE_COLOR);
        }
        gc.drawRectangle(r);
    }

    private void drawButtonImage(GC gc, Rectangle rect, TizenButtonAttribute attr, int state) {
        if (attr == null || attr.getImage(state) == null) {
            return;
        }
        Image img = attr.getImage(state);
        if (img == null || img.isDisposed()) {
            return;
        }
        Point p = null;
        Rectangle imgRect = img.getBounds();
        int x = 0;
        int y = 0;
        if (attr.getButtonImagePoint() == null) {
            int width = rect.width - imgRect.width;
            int height = rect.height - imgRect.height;
            if (width > 0) {
                x = width / 2;
            }
            if (height > 0) {
                y = height / 2;
            }
        } else {
            p = attr.getButtonImagePoint();
            x = p.x;
            y = p.y;
        }
        gc.drawImage(img, x, y);
    }

    private void drawButtonText(GC gc, Rectangle rect, TizenButtonAttribute attr, int state) {
        if (attr == null || attr.getText() == null) {
            return;
        }
        String text = null;
        Point p = null;
        text = attr.getText();
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getIcon() != null) {
            Rectangle iconRect = attr.getIcon().getBounds();
            textRect.x += iconRect.width;
            textRect.width -= iconRect.width;
        }
        if (attr.getFont() != null) {
            gc.setFont(attr.getFont());
        }
        int x = 0;
        int y = 0;
        int offset = 0;
        if (attr.getFontPoint() == null) {
            p = gc.textExtent(text, 8);
            if (attr.getAlign() == 0x1000000) {
                x = (textRect.width - p.x) / 2 + textRect.x;
                x = x < 0 ? 0 : x;
                offset = 0;
            } else {
                x = textRect.x;
                offset = 2;
            }
            y = (textRect.height - p.y) / 2;
        } else {
            p = attr.getFontPoint();
            x = p.x;
            y = p.y;
        }
        if (attr.getForeGroundcolor(state) != null) {
            gc.setForeground(attr.getForeGroundcolor(state));
        } else {
            gc.setForeground(this.parent.getForeground());
        }
        if (state == 1) {
            ++x;
            ++y;
        }
        gc.drawString(text, x + offset, y, true);
    }
}

