/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class DAChartPlot {
    private double visibleStartX = 0.0;
    private double visibleEndX = 0.0;
    private double visibleStartY = 0.0;
    private double visibleEndY = 0.0;
    private double validEndX = 0.0;
    private double validEndY = 0.0;
    private AutoRangeType autoRangeType = AutoRangeType.MANUAL;
    private boolean bSeriesHeightRange = false;
    private boolean bShowAxis = false;
    private Image backgroundImage = null;
    private DAChart chart;
    private List<DAChartPlotMarker> markers = new ArrayList<DAChartPlotMarker>();
    private DAChartPlotTooltip tooltip = null;
    protected boolean hasUpdate = false;
    private Font axisFont;
    private String axisUnit;
    private String secondAxisUnit;
    private UnitType axisUnitType = UnitType.DECIMAL;
    private double boundValue = -1.0;
    private BoundType boundType;
    private boolean isBoundExpanded = false;

    public void setBoundValue(double value) {
        this.boundValue = value;
    }

    public double getBoundValue() {
        return this.boundValue;
    }

    public void setBoundType(BoundType type) {
        this.boundType = type;
    }

    public BoundType getBoundType() {
        return this.boundType;
    }

    public void setBoundExpanded(boolean boundExpanded) {
        this.isBoundExpanded = boundExpanded;
    }

    public boolean isBounddExpdanded() {
        return this.isBoundExpanded;
    }

    public DAChartPlot(DAChart chart) {
        this.chart = chart;
    }

    public DAChart getChart() {
        return this.chart;
    }

    public void clear() {
        this.visibleStartX = 0.0;
        this.visibleEndX = 0.0;
        this.visibleStartY = 0.0;
        this.visibleEndY = 0.0;
        this.validEndX = 0.0;
        this.validEndY = 0.0;
        this.removeMarkers();
        this.removeTooltip();
    }

    public void setMarker(DAChartPlotMarker marker) {
        this.markers.add(marker);
        marker.registerChart(this.chart);
    }

    public void setMarkers(List<DAChartPlotMarker> markers) {
        if (markers == null) {
            return;
        }
        int size = markers.size();
        int i = 0;
        while (i < size) {
            this.setMarker(markers.get(i));
            ++i;
        }
    }

    public void removeMarkers() {
        this.markers.clear();
    }

    public List<DAChartPlotMarker> getMarkers() {
        return this.markers;
    }

    public void setTooltip(DAChartPlotTooltip tooltip) {
        this.tooltip = tooltip;
        this.tooltip.registerChart(this.chart);
    }

    public void removeTooltip() {
        if (this.tooltip != null) {
            this.tooltip.unRegisterChart(this.chart);
            this.tooltip = null;
        }
    }

    public DAChartPlotTooltip getTooltip() {
        return this.tooltip;
    }

    public void setAxisRangeX(double startX, double endX) {
        this.setAxisStartX(startX);
        this.setAxisEndX(endX);
    }

    public void setAxisRangeY(double startY, double endY) {
        this.setAxisStartY(startY);
        this.setAxisEndY(endY);
    }

    public void setAxisStartX(double startX) {
        this.visibleStartX = startX;
        this.hasUpdate = true;
    }

    public void setAxisEndX(double endX) {
        this.visibleEndX = endX;
        this.hasUpdate = true;
    }

    public void setAxisStartY(double startY) {
        this.visibleStartY = startY;
        this.hasUpdate = true;
    }

    public void setAxisEndY(double endY) {
        this.visibleEndY = endY;
        this.hasUpdate = true;
    }

    public AutoRangeType getAutoHeightRange() {
        return this.autoRangeType;
    }

    public void setAutoHeightRange(AutoRangeType autoRangeType) {
        this.autoRangeType = autoRangeType;
        this.hasUpdate = true;
    }

    public boolean isSeriesHeightRange() {
        return this.bSeriesHeightRange;
    }

    public void setSeriesHeightRange(boolean bSeriesHeightRange) {
        this.bSeriesHeightRange = bSeriesHeightRange;
        this.hasUpdate = true;
    }

    public double getVisibleStartX() {
        return this.visibleStartX;
    }

    public double getVisibleEndX() {
        return this.visibleEndX;
    }

    public double getVisibleStartY() {
        return this.visibleStartY;
    }

    public double getVisibleEndY() {
        return this.visibleEndY;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.hasUpdate = true;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public int getXPixelFromX(double x, Rectangle r) {
        return (int)Math.round((double)r.width * (x - this.visibleStartX) / (this.visibleEndX - this.visibleStartX));
    }

    public int getXPixelFromX(double x) {
        Rectangle r = this.chart.getBounds();
        return this.getXPixelFromX(x, r);
    }

    public int getYPixelFromY(double maxY, double y, Rectangle r) {
        double pixelY = this.visibleStartY == maxY ? 0.0 : (double)r.height * (y - this.visibleStartY) / (maxY - this.visibleStartY);
        return (int)((double)r.height - pixelY);
    }

    public double getXFromXPixel(int xPixel, Rectangle r) {
        return (this.visibleEndX - this.visibleStartX) * (double)xPixel / (double)r.width + this.visibleStartX;
    }

    public double getXFromXPixel(int xPixel) {
        Rectangle r = this.chart.getBounds();
        return this.getXFromXPixel(xPixel, r);
    }

    public double getYFromYPixel(int yPixel, Rectangle r) {
        int y = yPixel + r.height + 1;
        return (this.visibleEndY - this.visibleStartY) * (double)y / (double)r.height + this.visibleStartY;
    }

    public double getYFromYPixel(int yPixel) {
        Rectangle r = this.chart.getBounds();
        return this.getYFromYPixel(yPixel, r);
    }

    public double getValidEndX() {
        return this.validEndX;
    }

    public void setValidEndX(double validEndX) {
        this.validEndX = validEndX;
        this.hasUpdate = true;
    }

    public double getValidEndY() {
        return this.validEndY;
    }

    public void setValidEndY(double validEndY) {
        this.validEndY = validEndY;
        this.hasUpdate = true;
    }

    protected boolean hasUpdate() {
        return this.hasUpdate;
    }

    protected void setUpdate(boolean bUpdate) {
        this.hasUpdate = bUpdate;
    }

    public boolean isShowAxis() {
        return this.bShowAxis;
    }

    public void setShowAxis(boolean bShowAxis) {
        this.bShowAxis = bShowAxis;
    }

    public Font getAxisFont() {
        if (this.axisFont == null) {
            this.axisFont = FontResources.CHART_AXIS_FONT;
        }
        return this.axisFont;
    }

    public void setAxisFont(Font axisFont) {
        this.axisFont = axisFont;
    }

    public String getAxisUnit() {
        return this.axisUnit;
    }

    public void setAxisUnit(String axisUnit) {
        this.axisUnit = axisUnit;
    }

    public void setAxisUnitType(UnitType type) {
        this.axisUnitType = type;
    }

    public UnitType getAxisUnitType() {
        return this.axisUnitType;
    }

    public String getSecondAxisUnit() {
        return this.secondAxisUnit;
    }

    public void setSecondAxisUnit(String secondAxisUnit) {
        this.secondAxisUnit = secondAxisUnit;
    }

    public static enum AutoRangeType {
        MANUAL,
        SEMI_AUTO,
        AUTO;

    }

    public static enum BoundType {
        UPPER,
        UNDER;

    }

    public static enum UnitType {
        DECIMAL,
        MICRO_DECIMAL,
        BINARY,
        GL_MS,
        GL_FPS;

    }
}

