/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.animation.DAAnimationIcon;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialogEnum;
import org.tizen.dynamicanalyzer.widgets.progress.Progress;

public class ProgressDialog {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 110;
    public static final int PROGRESS_STYLE_DEFAULT = 0;
    public static final int PROGRESS_STYLE_CANCEL = 1;
    public static final int PROGRESS_STYLE_WARNING = 2;
    public static final int PROGRESS_STYLE_INDETERMINATE = 3;
    public static final int DIALOG_TYPE_SMALL = 0;
    public static final int DIALOG_TYPE_MIDDLE = 1;
    public static final int DIALOG_TYPE_LARGE = 2;
    private int progressStyle = 0;
    private int dialogType = 0;
    private Shell parent = null;
    private Shell shell = null;
    private Progress progress = null;
    private Composite baseComposite = null;
    private Composite msgComp = null;
    private Composite progressComp = null;
    private String upperText = "";
    private String bottomText = "";
    private String warningText = "";
    private Image iconImage = ImageResources.DIALOG_WARNING_ICON;
    private Button cancelButton = null;
    private Button okButton = null;
    private SelectionListener okButtonListener = null;
    private SelectionListener cancelButtonListener = null;
    private DAAnimationIcon progressIcon = null;
    private Listener shellMouseListener = new Listener(){
        boolean down = false;
        Point downPoint = new Point(0, 0);

        public void handleEvent(Event event) {
            int id = event.type;
            if (event.widget instanceof Shell) {
                this.down = false;
            } else {
                switch (id) {
                    case 3: {
                        this.downPoint.x = event.x;
                        this.downPoint.y = event.y;
                        this.down = true;
                        break;
                    }
                    case 4: {
                        this.down = false;
                        break;
                    }
                    case 5: {
                        if (!this.down || ProgressDialog.this.shell == null) break;
                        Point p = ProgressDialog.this.shell.getLocation();
                        p.x += event.x - this.downPoint.x;
                        p.y += event.y - this.downPoint.y;
                        ProgressDialog.this.shell.setLocation(p);
                        break;
                    }
                }
            }
        }
    };

    public ProgressDialog(Shell parent, Composite base) {
        this.parent = parent;
        this.baseComposite = base;
    }

    public void open() {
        switch (this.progressStyle) {
            case 0: 
            case 1: {
                this.createProgress(false);
                break;
            }
            case 2: {
                this.createWarningProgress();
                break;
            }
            case 3: {
                this.createProgress(true);
            }
        }
        if (this.shell != null) {
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Rectangle rect = ProgressDialog.this.shell.getClientArea();
                    e.gc.setForeground(ColorResources.STOP_PROGRESS_LINE2_COLOR);
                    e.gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    e.gc.setForeground(ColorResources.STOP_PROGRESS_LINE1_COLOR);
                    e.gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);
                }
            });
            this.shell.getDisplay().addFilter(3, this.shellMouseListener);
            this.shell.getDisplay().addFilter(4, this.shellMouseListener);
            this.shell.getDisplay().addFilter(5, this.shellMouseListener);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 2) {
                        event.doit = false;
                    }
                }
            });
            this.shell.open();
            this.baseComposite.setEnabled(false);
        }
    }

    public void createProgress(boolean isIndeterminate) {
        this.shell = new Shell(this.parent, 65544);
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 300) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 110) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(300, 110);
        this.progressComp = new Composite((Composite)this.shell, 0);
        this.progressComp.setLayout((Layout)new FormLayout());
        this.progressComp.setBackground(ColorResources.WHITE);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        this.progressComp.setLayoutData((Object)data);
        Label upperLabel = new Label(this.progressComp, 0x40004000);
        upperLabel.setText(this.upperText);
        upperLabel.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        upperLabel.setForeground(ColorResources.BLACK);
        upperLabel.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, 0);
        upperLabel.setLayoutData((Object)data);
        Composite progressCom = new Composite(this.progressComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 44);
        data.left = new FormAttachment(0, 10);
        data.width = 276;
        data.height = 22;
        progressCom.setLayoutData((Object)data);
        progressCom.setLayout((Layout)new FillLayout());
        if (!isIndeterminate) {
            this.progress = new Progress(progressCom, 0);
            this.progress.setPercentageFont(FontResources.PROGRESS_PERCENTAGE_FONT);
            this.progress.setFontColor(ColorResources.PROGRESS_PERCENTAGE_FONT_COLOR);
        } else {
            this.progressIcon = this.createProgressIcon(progressCom);
            this.progressIcon.start();
        }
        Label bottomLabel = new Label(this.progressComp, 0x40004000);
        bottomLabel.setText(this.bottomText);
        bottomLabel.setFont(FontResources.STOP_PROGRESS_FONT);
        bottomLabel.setForeground(ColorResources.BLACK);
        bottomLabel.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.left = new FormAttachment(0, 12);
        data.top = new FormAttachment((Control)progressCom, 10);
        data.height = 20;
        bottomLabel.setLayoutData((Object)data);
        FormData cancelData = new FormData();
        cancelData.top = new FormAttachment((Control)progressCom, 10);
        cancelData.right = new FormAttachment(100, -8);
        cancelData.width = 88;
        cancelData.height = 22;
        if (this.progressStyle == 1 || this.progressStyle == 3) {
            this.cancelButton = this.createButton(this.progressComp, "Cancel", cancelData);
            this.cancelButton.setLayoutData((Object)cancelData);
            this.cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ProgressDialog.this.close();
                }
            });
            if (this.cancelButtonListener != null) {
                this.cancelButton.addSelectionListener(this.cancelButtonListener);
            }
        }
    }

    public void createWarningProgress() {
        ArrayList<Integer> sizeInfo = new ArrayList<Integer>();
        DADialogEnum.progressDialogInfo[] progressDialogInfoArray = DADialogEnum.progressDialogInfo.values();
        int n = progressDialogInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DADialogEnum.progressDialogInfo info = progressDialogInfoArray[n2];
            switch (this.dialogType) {
                case 0: {
                    sizeInfo.add(info.getSmall());
                    break;
                }
                case 1: {
                    sizeInfo.add(info.getMiddle());
                    break;
                }
                case 2: {
                    sizeInfo.add(info.getLarge());
                    break;
                }
                default: {
                    Logger.warning((Object)("Invalid dialogType:" + this.dialogType));
                }
            }
            ++n2;
        }
        this.shell = new Shell(this.parent, 65544);
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 350) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - (Integer)sizeInfo.get(0)) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(350, ((Integer)sizeInfo.get(0)).intValue());
        this.msgComp = new Composite((Composite)this.shell, 0);
        this.msgComp.setLayout((Layout)new FormLayout());
        FormData baseData = new FormData();
        baseData.top = new FormAttachment(0, 2);
        baseData.left = new FormAttachment(0, 2);
        baseData.right = new FormAttachment(100, -2);
        baseData.height = (Integer)sizeInfo.get(1);
        this.msgComp.setLayoutData((Object)baseData);
        this.msgComp.setBackground(ColorResources.WHITE);
        this.msgComp.setVisible(true);
        Label icon = new Label(this.msgComp, 0x40000000);
        icon.setImage(this.iconImage);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 15);
        formData.top = new FormAttachment(0, ((Integer)sizeInfo.get(2)).intValue());
        formData.height = 64;
        formData.width = 64;
        icon.setLayoutData((Object)formData);
        Label upperLabel = new Label(this.msgComp, 0x40004000);
        upperLabel.setText(this.upperText);
        upperLabel.setFont(FontResources.PROGRESS_FONT);
        upperLabel.setForeground(ColorResources.BLACK);
        upperLabel.setBackground(ColorResources.WHITE);
        formData = new FormData();
        formData.left = new FormAttachment(0, 92);
        formData.right = new FormAttachment(95, 0);
        formData.top = new FormAttachment(0, 15);
        upperLabel.setLayoutData((Object)formData);
        Label strMessage = new Label(this.msgComp, 0x40004040);
        strMessage.setText(this.warningText);
        strMessage.setFont(FontResources.STOP_PROGRESS_FONT);
        strMessage.setForeground(ColorResources.BLACK);
        strMessage.setBackground(ColorResources.WHITE);
        formData = new FormData();
        formData.left = new FormAttachment(0, 92);
        formData.right = new FormAttachment(95, 0);
        formData.top = new FormAttachment((Control)upperLabel, 5);
        formData.bottom = new FormAttachment(100, 0);
        strMessage.setLayoutData((Object)formData);
        this.progressComp = new Composite((Composite)this.shell, 0);
        this.progressComp.setLayout((Layout)new FormLayout());
        this.progressComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.msgComp, 0);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        this.progressComp.setLayoutData((Object)data);
        this.progress = new Progress(this.progressComp, 0);
        this.progress.setPercentageFont(FontResources.PROGRESS_PERCENTAGE_FONT);
        this.progress.setFontColor(ColorResources.PROGRESS_PERCENTAGE_FONT_COLOR);
        data = new FormData();
        data.left = new FormAttachment(0, 11);
        data.top = new FormAttachment(0, 10);
        data.width = 325;
        data.height = 22;
        this.progress.setLayoutData(data);
        this.progress.errorOccured();
        Label bottomLabel = new Label(this.progressComp, 0x40004000);
        bottomLabel.setText(this.bottomText);
        bottomLabel.setFont(FontResources.STOP_PROGRESS_FONT);
        bottomLabel.setForeground(ColorResources.BLACK);
        bottomLabel.setBackground(ColorResources.WHITE);
        formData = new FormData();
        formData.left = new FormAttachment(0, 12);
        formData.top = new FormAttachment(0, 41);
        formData.height = 20;
        bottomLabel.setLayoutData((Object)formData);
        FormData okData = new FormData();
        okData.top = new FormAttachment(0, 41);
        okData.right = new FormAttachment(100, -12);
        okData.width = 88;
        okData.height = 22;
        this.okButton = this.createButton(this.progressComp, "OK", okData);
        this.okButton.setEnabled(false);
        this.okButton.setLayoutData((Object)okData);
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ProgressDialog.this.close();
            }
        });
        if (this.okButtonListener != null) {
            this.okButton.addSelectionListener(this.okButtonListener);
        }
    }

    public void close() {
        if (this.progress != null) {
            if (!this.progress.isDisposed()) {
                this.progress.dispose();
            }
            this.progress = null;
        }
        if (this.shell != null) {
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
        this.baseComposite.setEnabled(true);
    }

    public void setIcon(Image img) {
        this.iconImage = img;
    }

    public void setProgressMessage(String message) {
        this.upperText = message;
    }

    public void setProgressInfo(String infoMessage) {
        this.bottomText = infoMessage;
    }

    public void setProgressWarningMessage(String message) {
        this.warningText = message;
    }

    public void setProgressStyle(int style) {
        this.progressStyle = style;
    }

    public void setValue(int value) {
        if (this.progress == null) {
            return;
        }
        this.progress.setValue(value);
        if (this.progressStyle == 2 && this.okButton != null && value == this.progress.getMaxSize()) {
            this.setOkEnabled(true);
        }
    }

    public void setValues(String progressMessage, int value) {
        this.upperText = progressMessage;
        this.progress.setValue(value);
    }

    public void errorOccurred(String message, String bottomMessage) {
        this.progress.errorOccured();
        this.bottomText = bottomMessage;
        this.upperText = message;
    }

    private Button createButton(Composite comp, String text, FormData data) {
        Button button = new Button(comp, 0);
        button.setText(text);
        button.setLayoutData((Object)data);
        button.setFont(FontResources.DIALOG_BUTTON_FONT);
        return button;
    }

    public void setOkEnabled(final boolean enable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.okButton.setEnabled(enable);
                ProgressDialog.this.okButton.redraw();
            }
        });
    }

    public void setCancelEnabled(final boolean enable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.cancelButton.setEnabled(enable);
                ProgressDialog.this.cancelButton.redraw();
            }
        });
    }

    public void setWarnigDialogType(int type) {
        this.dialogType = type;
    }

    public void setOkListener(SelectionListener listener) {
        this.okButtonListener = listener;
    }

    public void setCancelListener(SelectionListener listener) {
        this.cancelButtonListener = listener;
    }

    private DAAnimationIcon createProgressIcon(Composite comp) {
        ArrayList<Image> progressImage = new ArrayList<Image>();
        progressImage.add(ImageResources.INDETERMINATE_PROGRESS_01);
        progressImage.add(ImageResources.INDETERMINATE_PROGRESS_02);
        return new DAAnimationIcon(comp, 0, progressImage);
    }
}

