/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.popupMenu;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItemButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class DAPopupMenu {
    private Composite parent;
    private DAPopupMenuItem parentItem;
    private static Shell topShell;
    private Shell shell;
    private DAPopupMenu childMenu;
    private List<DAPopupMenuItem> children;
    private Font itemFont;
    private static final int MOUSE_LEFT = 1;
    private static final int MOUSE_RIGHT = 3;
    private Point contextMenuPoint = null;
    private int contextMenuHeight = 0;
    private int contextMenuWidth = 0;
    private Timer checkEnableTimer = null;
    private static final int STAUES_ITEMS_CHECK_TIME = 500;
    private Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            int eventType = event.type;
            Object obj = event.widget;
            if (!(obj instanceof DACustomButton)) {
                return;
            }
            DACustomButton button = (DACustomButton)((Object)obj);
            if (button.isDisposed()) {
                return;
            }
            obj = button.getData();
            if (!(obj instanceof DAPopupMenuItem)) {
                return;
            }
            DAPopupMenuItem item = (DAPopupMenuItem)obj;
            DAPopupMenu menu = item.getChild();
            switch (eventType) {
                case 6: {
                    if (menu != null && menu.equals(DAPopupMenu.this.childMenu)) {
                        return;
                    }
                    DAPopupMenu.this.closeChildMenu(item, menu);
                    break;
                }
                case 32: {
                    if (DAPopupMenu.this.childMenu != null) {
                        return;
                    }
                    if (item.open() == null) break;
                    DAPopupMenu.this.itemNormalColorChange(button, ColorResources.POPUP_MENU_ITEM_SELECTED, ColorResources.POPUP_MENU_TEXT_SELECTED);
                    break;
                }
                case 4: {
                    int itemType = item.getType();
                    if (itemType == 0) {
                        if (!item.isEnabled()) break;
                        item.closeParentsChildMenu();
                        item.closeParent();
                        break;
                    }
                    if (itemType != 2) break;
                    if (DAPopupMenu.this.childMenu != null) {
                        DAPopupMenu.this.closeChildMenu(item, menu);
                        break;
                    }
                    if (item.open() == null) break;
                    DAPopupMenu.this.itemNormalColorChange(button, ColorResources.POPUP_MENU_ITEM_SELECTED, ColorResources.POPUP_MENU_TEXT_SELECTED);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    };

    public DAPopupMenu(Composite parent) {
        this.parent = parent;
        this.setMouseListener();
    }

    public DAPopupMenu() {
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    public void setMouseListener() {
        this.parent.getShell().addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
                DAPopupMenu.this.closeChild();
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                DAPopupMenu.this.closeChild();
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.parent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                switch (e.button) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        Point pt = Display.getCurrent().getCursorLocation();
                        if (!DAPopupMenu.this.isInParent(pt)) break;
                        DAPopupMenu.this.open(topShell, pt.x - 5, pt.y - 5);
                    }
                }
            }

            public void mouseDown(MouseEvent event) {
                switch (event.button) {
                    case 1: {
                        DAPopupMenu.this.closeParent();
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void disposeContextMenu() {
        Point pt = Display.getCurrent().getCursorLocation();
        if (!this.isInParent(pt) && !this.isOverContextMenu()) {
            this.closeChild();
        }
    }

    private void disposeContextMenuTimer(int milliseconds) {
        this.checkEnableTimer = new Timer();
        this.checkEnableTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DAPopupMenu.this.disposeContextMenu();
                    }
                });
            }
        }, milliseconds, (long)milliseconds);
    }

    private boolean isOverContextMenu() {
        if (this.contextMenuPoint == null) {
            return false;
        }
        Point pt = Display.getCurrent().getCursorLocation();
        return this.contextMenuPoint.x <= pt.x && pt.x <= this.contextMenuPoint.x + this.contextMenuWidth && this.contextMenuPoint.y <= pt.y && pt.y <= this.contextMenuPoint.y + this.contextMenuHeight;
    }

    protected boolean isInParent(Point pt) {
        if (this.parent == null) {
            return false;
        }
        Point parentSize = this.parent.getSize();
        Point parentPt = this.parent.getLocation();
        Composite comp = this.parent.getParent();
        while (comp != null) {
            parentPt.x += comp.getLocation().x;
            parentPt.y += comp.getLocation().y;
            comp = comp.getParent();
        }
        return pt.x >= parentPt.x && pt.x <= parentPt.x + parentSize.x;
    }

    private Point getPopupPosition(int x, int y, int width, int height) {
        Rectangle rt = Display.getCurrent().getBounds();
        Point ret = new Point(x, y);
        if (x + width > rt.width) {
            ret.x -= x + width - rt.width;
        }
        if (y + height > rt.height) {
            ret.y -= y + height - rt.height;
        }
        return ret;
    }

    public DAPopupMenu(DAPopupMenuItem parent) {
        this.parentItem = parent;
        if (parent != null) {
            parent.setChild(this);
        }
    }

    public boolean makeItem(Shell shell, int x, int y) {
        Point popupPt;
        if (this.children == null) {
            return false;
        }
        shell.setLayout((Layout)new FormLayout());
        int childSize = this.children.size();
        int itemHeight = 0;
        int itemWidth = 0;
        DACustomButton oldItem = null;
        DACustomButton newItem = null;
        int i = 0;
        while (i < childSize) {
            DAPopupMenuItem child = this.children.get(i);
            if (child == null) {
                return false;
            }
            oldItem = newItem;
            FormData data = new FormData();
            data.top = oldItem == null ? new FormAttachment(0, 2) : new FormAttachment(oldItem, 0);
            if (1 == child.getType()) {
                newItem = new DACustomButton((Composite)shell, 0);
                newItem.setRenderer(new DAPopupMenuItemButtonRenderer());
                newItem.setColors(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
                newItem.setButtonEnabled(false);
                data.height = 2;
                itemHeight += 2;
            } else {
                Image icon;
                newItem = new DACustomButton((Composite)shell, child.getText());
                newItem.setRenderer(new DAPopupMenuItemButtonRenderer());
                newItem.setColors(ColorResources.WHITE, ColorResources.POINT, ColorResources.POINT, ColorResources.WHITE);
                newItem.setFontColors(ColorResources.POPUP_MENU_TEXT_NORMAL, ColorResources.POPUP_MENU_TEXT_SELECTED, ColorResources.POPUP_MENU_TEXT_SELECTED, ColorResources.POPUP_MENU_TEXT_DISABLED);
                if (this.itemFont != null) {
                    newItem.setFont(this.itemFont);
                }
                data.height = 24;
                itemHeight += 24;
                int width = this.getTextWidth((Drawable)newItem, child.getText());
                if (width > itemWidth) {
                    itemWidth = width;
                }
                if (child.getType() == 0) {
                    List<DAPopupMenuListener> listeners = child.getListeners();
                    if (listeners != null) {
                        int index = 0;
                        while (index < listeners.size()) {
                            newItem.addClickListener(listeners.get(index));
                            ++index;
                        }
                        if (!child.isEnabled()) {
                            newItem.setButtonEnabled(false);
                        }
                    }
                } else {
                    newItem.setButtonImages(ImageResources.CONTEXT_OPEN, ImageResources.CONTEXT_OPEN, ImageResources.CONTEXT_OPEN, ImageResources.CONTEXT_OPEN);
                    newItem.addListener(32, this.mouseListener);
                }
                if ((icon = child.getIcon()) != null) {
                    newItem.setIcon(icon);
                }
                newItem.addListener(4, this.mouseListener);
            }
            newItem.addListener(6, this.mouseListener);
            child.setControl(newItem);
            newItem.setData(child);
            data.left = new FormAttachment(0, 2);
            data.right = new FormAttachment(100, -2);
            newItem.setLayoutData(data);
            ++i;
        }
        shell.layout();
        int popupWidth = itemWidth + 4 + 3 + 5 + 32;
        int popupHeight = itemHeight + 4;
        this.contextMenuPoint = popupPt = this.getPopupPosition(x, y, popupWidth, popupHeight);
        this.contextMenuHeight = popupHeight;
        this.contextMenuWidth = popupWidth;
        shell.setBounds(popupPt.x, popupPt.y, popupWidth, popupHeight);
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.POPUP_MENU_OUTLINE_STORKE1);
                e.gc.drawRectangle(0, 0, e.width - 1, e.height - 1);
                e.gc.setForeground(ColorResources.POPUP_MENU_OUTLINE_STORKE2);
                e.gc.drawRectangle(1, 1, e.width - 3, e.height - 3);
            }
        });
        return true;
    }

    private int getTextWidth(Drawable drawable, String text) {
        GC gc = new GC(drawable);
        int nTextWidth = gc.textExtent((String)text).x;
        gc.dispose();
        return nTextWidth;
    }

    public boolean open(Shell shell, int x, int y) {
        if (shell != null) {
            shell.dispose();
            shell = null;
        }
        if (this.parent != null) {
            this.shell = topShell = new Shell(this.parent.getShell(), 8);
        } else if (this.parentItem != null) {
            this.shell = new Shell(this.parentItem.getControl().getShell(), 8);
        } else {
            return false;
        }
        shell = this.shell;
        if (!this.makeItem(shell, x, y)) {
            shell.dispose();
            shell = null;
            return false;
        }
        shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
                Point pt;
                if (DAPopupMenu.this.childMenu == null && !DAPopupMenu.this.isInCursorOnMenu(pt = Display.getCurrent().getCursorLocation())) {
                    DAPopupMenu.this.closeParent();
                }
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        shell.open();
        if (this.checkEnableTimer != null) {
            this.checkEnableTimer.cancel();
            this.checkEnableTimer = null;
        }
        this.disposeContextMenuTimer(500);
        return true;
    }

    protected boolean isInCursorOnShell(Shell shell) {
        Rectangle rt = shell.getBounds();
        Point pt = Display.getCurrent().getCursorLocation();
        return pt.x > rt.x && pt.x < rt.x + rt.width && pt.y > rt.y && pt.y < rt.y + rt.height;
    }

    protected boolean isInCursorOnMenu(Point pt) {
        boolean ret = false;
        Rectangle rt = this.shell.getBounds();
        if (pt.x > rt.x && pt.x < rt.x + rt.width && pt.y > rt.y && pt.y < rt.y + rt.height) {
            return true;
        }
        ret = false;
        if (this.parentItem != null) {
            return this.parentItem.isInCursorInMenu(pt);
        }
        return ret;
    }

    private void close() {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        if (topShell != null) {
            topShell.dispose();
            topShell = null;
        }
        this.childMenu = null;
        this.contextMenuPoint = null;
        if (this.checkEnableTimer != null) {
            this.checkEnableTimer.cancel();
            this.checkEnableTimer = null;
        }
    }

    protected void closeParent() {
        this.close();
        if (this.parentItem != null) {
            this.parentItem.closeParent();
        }
    }

    public void closeChild() {
        if (this.childMenu != null) {
            this.childMenu.closeChild();
        }
        this.close();
    }

    protected void addChild(DAPopupMenuItem item) {
        if (this.children == null) {
            this.children = new ArrayList<DAPopupMenuItem>();
        }
        this.children.add(item);
    }

    protected void removeChild(DAPopupMenuItem item) {
        if (this.children == null) {
            return;
        }
        int childSize = this.children.size();
        int i = 0;
        while (i < childSize) {
            if (item.equals(this.children.get(i))) {
                this.children.remove(i);
                return;
            }
            ++i;
        }
    }

    protected void removechild(int index) {
        if (this.children == null || this.children.size() <= index) {
            return;
        }
        this.children.remove(index);
    }

    public List<DAPopupMenuItem> getChildren() {
        return this.children;
    }

    protected void setChildren(List<DAPopupMenuItem> children) {
        this.children = children;
    }

    public DAPopupMenuItem getItem(int index) {
        if (this.children == null || this.children.size() <= index) {
            return null;
        }
        return this.children.get(index);
    }

    public List<DAPopupMenuItem> getItems() {
        return this.children;
    }

    public DAPopupMenu getChildMenu() {
        return this.childMenu;
    }

    public void setChildMenu(DAPopupMenu childMenu) {
        if (this.childMenu != null) {
            this.childMenu.close();
        }
        this.childMenu = childMenu;
    }

    public Composite getParent() {
        return this.parent;
    }

    public DAPopupMenuItem getParentItem() {
        return this.parentItem;
    }

    protected Shell getShell() {
        return this.shell;
    }

    public Shell getTopShell() {
        return topShell;
    }

    private void itemNormalColorChange(DACustomButton button, Color background, Color text) {
        if (button == null) {
            return;
        }
        button.setColor(0, background);
        button.setFontColor(0, text);
    }

    private void closeChildMenu(DAPopupMenuItem item, DAPopupMenu menu) {
        DAPopupMenuItem oldItem;
        if (this.childMenu != null && (oldItem = this.childMenu.getParentItem()) != null) {
            this.itemNormalColorChange(oldItem.getControl(), ColorResources.POPUP_MENU_ITEM_NORMAL, ColorResources.POPUP_MENU_TEXT_NORMAL);
        }
        item.closeParentsChildMenu();
    }

    public void setFont(Font font) {
        this.itemFont = font;
    }

    public Font getFont() {
        return this.itemFont;
    }
}

