/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.database;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTableRegistry;
import org.tizen.dynamicanalyzer.database.IPreparedStatement;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.database.RemainingDataManager;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.util.Logger;

public abstract class DBTable
implements IPreparedStatement,
IResultSet {
    protected static final String SELECT_ALL_QUERY = "select * from %s";
    private List<DBColumn> columns = new ArrayList<DBColumn>();
    protected DBInserter dbInserter = null;

    public DBTable() {
        this.registerTable();
    }

    public abstract String getTableName();

    protected final void registerTable() {
        DBTableRegistry.registerDBTable(this);
    }

    public final List<DBColumn> getColumns() {
        return this.columns;
    }

    public final int getColumnSize() {
        return this.columns.size();
    }

    public final void setDBInserter(DBInserter inserter) {
        this.dbInserter = inserter;
    }

    protected final void addColumn(DBColumn col) {
        this.columns.add(col);
    }

    protected final void setIndexColumn(int index) {
        this.columns.get(index).setIndex(true);
    }

    protected final String clipString(String colstr, int str_len, String key) {
        String retstr = colstr;
        if (colstr != null && colstr.length() > str_len) {
            retstr = colstr.substring(0, str_len);
            RemainingDataManager.addRemainingData(this.getTableName(), key, colstr.substring(str_len, colstr.length()));
        }
        return retstr;
    }

    public final boolean createTable() {
        StringBuffer query = new StringBuffer();
        query.append("create table ");
        query.append(this.getTableName());
        query.append(" (");
        int size = this.columns.size();
        int i = 0;
        while (i < size) {
            query.append(this.columns.get(i).getColumnString());
            if (i == size - 1) {
                query.append(")");
            } else {
                query.append(",");
            }
            ++i;
        }
        query.append(";");
        String queryString = query.toString();
        return SqlConnectionManager.executeUpdate(queryString);
    }

    public final void insertData(List<List<Object>> data) {
        if (data.size() > 0) {
            StringBuffer query = new StringBuffer();
            query.append("insert into ").append(this.getTableName()).append(" values( ");
            int columnsize = this.columns.size();
            int i = 0;
            while (i < columnsize) {
                if (i == columnsize - 1) {
                    query.append(" ? )");
                } else {
                    query.append("?, ");
                }
                ++i;
            }
            query.append(";");
            SqlConnectionManager.executePreparedWithInterface(query.toString(), data, this);
            this.postProcess(data);
        }
    }

    protected void postProcess(List<List<Object>> data) {
    }

    public final boolean createIndexTable() {
        int size = this.columns.size();
        StringBuffer indexColumns = new StringBuffer();
        int i = 0;
        while (i < size) {
            if (this.columns.get(i).isIndex()) {
                if (indexColumns.length() > 0) {
                    indexColumns.append(", ");
                }
                indexColumns.append(this.columns.get(i).getName());
            }
            ++i;
        }
        if (indexColumns.length() > 0) {
            String queryString = "create index " + this.getTableName() + "_index on " + this.getTableName() + "(" + indexColumns.toString() + ")";
            return SqlConnectionManager.executeUpdate(queryString);
        }
        return true;
    }

    public final List<List<Object>> selectAllObjectData() {
        return SqlConnectionManager.executeQuery(String.format(SELECT_ALL_QUERY, this.getTableName()));
    }

    public final List<List<Object>> selectAllColumnData(String option) {
        return this.selectData(null, option, this);
    }

    public final List<List<Object>> selectData(List<String> column, String option, IResultSet irs) {
        int i;
        int columnsize;
        StringBuffer query = new StringBuffer();
        query.append("select ");
        if (column != null) {
            columnsize = column.size();
            i = 0;
            while (i < columnsize) {
                query.append(column.get(i));
                if (i < columnsize - 1) {
                    query.append(", ");
                }
                ++i;
            }
        } else {
            columnsize = this.columns.size();
            i = 0;
            while (i < columnsize) {
                query.append(this.columns.get(i).getName());
                if (i < columnsize - 1) {
                    query.append(", ");
                }
                ++i;
            }
        }
        query.append(" from ").append(this.getTableName());
        if (option != null) {
            query.append(" ").append(option);
        }
        ArrayList<List<Object>> resultdata = new ArrayList<List<Object>>();
        ResultSet rs = SqlConnectionManager.executeQueryRS(query.toString());
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        List<Object> row = irs.extractDataFromResultSet(rs);
                        if (row == null || row.isEmpty()) continue;
                        resultdata.add(row);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return resultdata;
    }

    protected void setArrayToPreparedStatement(int index, String type, PreparedStatement prep, List<Object> rowData) {
        try {
            if (rowData.get(index) == null) {
                prep.setArray(index + 1, null);
            } else {
                List objectArray = (List)rowData.get(index);
                Array sqlArray = prep.getConnection().createArrayOf(type, objectArray.toArray());
                prep.setArray(index + 1, sqlArray);
                sqlArray.free();
            }
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
    }

    protected <T> List<Object> getArrayFromResultSet(ResultSet rs, int index, T type) {
        Array sqlArray;
        block4: {
            sqlArray = rs.getArray(index);
            if (sqlArray != null) break block4;
            return null;
        }
        try {
            ArrayList<Object> rlist = new ArrayList<Object>();
            Object[] objarray = (Object[])sqlArray.getArray();
            int len = objarray.length;
            int i = 0;
            while (i < len) {
                rlist.add(objarray[i]);
                ++i;
            }
            return rlist;
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        return null;
    }
}

