/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.database.compatible;

import java.util.Set;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.DBTableRegistry;
import org.tizen.dynamicanalyzer.database.compatible.IConvert;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDBTable;
import org.tizen.dynamicanalyzer.ui.info.appStartup.WebAppStartupDBTable;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveValueDBTable;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveVariableDBTable;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLBufferSizeDBTableManager;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfilingDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionExitDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

class SubConverter10to20Later {
    private static final String CHANGE_SEPERATOR = ">";
    private static final String TABLENAME_SEPERATOR = ":";
    private static final String[] drop_column = new String[]{"FUNCTIONENTRY : TYPE"};
    private static final String[] change_column_name = new String[]{"CALLSTACKDATA : SEQNUMBER > SEQUENCE_NUMBER", "CALLSTACKUNITS : FUNCTIONID > FUNCTION_ID", "CALLSTACKUNITS : BINARYID > BINARY_ID", "CALLSTACKUNITS : PCADDR > PC_ADDRESS", "FAILEDAPIDATA : PROCESS_ID > PID", "FILE_API_DB : ERRNO > ERROR_NUMBER", "FILE_API_DB : ARGUMENTS_VALUE > ARGUMENT", "FREEDATA : PROCESS_ID > PID", "FUNCTIONENTRY : SEQNUMBER > SEQUENCE_NUMBER", "FUNCTIONENTRY : FUNCTIONID > FUNCTION_ID", "FUNCTIONENTRY : BINARYID > BINARY_ID", "FUNCTIONENTRY : STARTTIME > START_TIME", "FUNCTIONENTRY : PCADDR > START_PC_ADDRESS", "FUNCTIONEXIT : ENTRYSEQNUMBER > ENTRY_SEQUENCE_NUMBER", "FUNCTIONEXIT : EXITSEQNUMBER > EXIT_SEQUENCE_NUMBER", "FUNCTIONEXIT : ENDTIME > END_TIME", "FUNCTIONSAMPLE : SEQNUMBER > SEQUENCE_NUMBER", "FUNCTIONSAMPLE : SAMPLETIME > SAMPLE_TIME", "FUNCTIONSAMPLE : PCADDR > PC_ADDRESS", "FUNCTIONSAMPLE : CPUNUM > CPU_NUMBER", "GL_API : SEQ > SEQUENCE_NUMBER", "GL_API : TIME > SATRT_TIME", "GL_API : ID > API_ID", "GL_API : ARG > ARGUMENT", "GL_API : RET > RETURN_VALUE", "GL_API : ERROR > ERROR_NUMBER", "GL_API : LIB_NAME > CALLER_LIBRARY_NAME", "GL_CONTEXT : SEQ > SEQUENCE_NUMBER", "GL_PROGRAM : ID > PROGRAM_ID", "GL_REDUNDANT : PARAMETER > ARGUMENT", "GL_TEXTURE : CHANGE_SEQ > CHANGE_SEQUENCE_NUMBER", "LEAKDATA : PROCESS_ID > PID", "MEMORYALLOCATIONDATA : PROCESS_ID > PID", "MEMORYALLOCATIONDATA : THREAD_ID > TID", "NETWORK_API : SEQ > SEQUENCE_NUMBER", "NETWORK_API : FD_VALUE > NETWORK_FD", "NETWORK_API : TIME > API_TIME", "NETWORK_API : ID > API_ID", "NETWORK_API : ERROR > ERROR_NUMBER", "NETWORK_API : ARG > ARGUMENT", "NETWORK_API : RET > RETURN_VALUE", "NETWORK_API : LIB_NAME > CALLER_LIBRARY_NAME", "NETWORK_SERIES : FD_VALUE > NETWORK_FD", "NETWORK_SERIES : ID > API_ID", "PROFILINGCHILDDATA : PROFILINGDATAID > PROFILING_DATA_ID", "PROFILINGDATA : PROFILINGDATAID > PROFILING_DATA_ID", "PROFILINGDATA : FUNCTIONID > FUNCTION_ID", "PROFILINGDATA : BINARYID > BINARY_ID", "PROFILINGDATA : EXCOUNT > EXCLUSIVE_COUNT", "PROFILINGDATA : INCOUNT > INCLUSIVE_COUNT", "PROFILINGDATA : CALLCOUNT > CALL_COUNT", "PROFILINGDATA : INCLEXETIME > INCLUSIVE_EXECUTION_TIME", "PROFILINGDATA : EXCLEXETIME > EXCLUSIVE_EXECUTION_TIME", "SYNCAPI : SEQNUMBER > SEQUENCE_NUMBER", "SYNCAPI : APICALLTIME > CALL_TIME", "SYNCAPI : APIID > API_ID", "SYNCAPI : SYNCVALUE > SYNC_VALUE", "SYNCDATA : SYNCDATAID > SYNC_DATA_ID", "SYNCDATA : SYNCTYPE > SYNC_TYPE", "SYNCDATA : SYNCVALUE > SYNC_VALUE", "SYNCDATA : ATTRIBUTETYPE > ATTRIBUTE_TYPE", "SYNCDATA : SYNCDATATYPE > SYNC_DATA_TYPE", "SYNCDATA : PARENTID > PARENT_ID", "SYNCEVENT : APISEQNUMBER > SEQUENCE_NUMBER", "SYNCEVENT : SYNCDATAID > SYNC_DATA_ID", "SYNCEVENT : EVENTTIME > EVENT_TIME", "SYNCEVENT : APITYPE > API_TYPE", "SYNCEVENT : SYNCVALUE > SYNC_VALUE", "SYNCEVENT : BLOCKENDTIME > BLOCK_END_TIME", "THREADAPI : SEQNUMBER > SEQUENCE_NUMBER", "THREADAPI : THREADDATAID > THREAD_DATA_ID", "THREADAPI : APICALLTIME > CALL_TIME", "THREADAPI : APIID > API_ID", "THREADDATA : THREADDATAID > THREAD_DATA_ID", "THREADDATA : THREADTYPE > THREAD_TYPE", "THREADDATA : ATTRIBUTETYPE > ATTRIBUTE_TYPE", "THREADDATA : STARTTIME > START_TIME", "THREADDATA : ENDTIME > END_TIME", "THREADDATA : FUNCTIONID > API_ID", "THREADDATA : CLASSNAME > CLASS_NAME", "THREADDATA : CREATETID > CREATE_TID", "THREADDATA : JOINTID > JOIN_TID", "THREADEVENT : THREADDATAID > THREAD_DATA_ID", "THREADEVENT : EVENTTIME > EVENT_TIME", "THREADEVENT : APITYPE > API_TYPE", "THREADEVENT : EVENTTYPE > EVENT_TYPE", "THREADEVENT : THREADTYPE > THREAD_TYPE", "THREADEVENT : CALLERID > CALLER_ID", "TIMELINE_TARGET_PROCESS : THREAD_ID > TID", "WARNINGDATA : PROCESS_ID > PID", "WARNINGDATA : THREAD_ID > TID"};
    private static final String[] change_table_name = new String[]{"CALLSTACKDATA > CALL_STACK_DATA", "CALLSTACKUNITS > CALL_STACK_UNIT", "FAILEDAPIDATA > FAILED_API_DATA", "FILE_ACCESS_DB > FILE_ACCESS", "FILE_ACCESSOR_DB > FILE_ACCESSOR", "FILE_API_DB > FILE_API", "FILE_STATUS_DB > FILE_STATUS", "FREEDATA > FREE_DATA", "FUNCTIONENTRY > FUNCTION_ENTRY", "FUNCTIONEXIT > FUNCTION_EXIT", "FUNCTIONSAMPLE > FUNCTION_SAMPLE", "LEAKDATA > LEAK_DATA", "MEMORYALLOCATIONDATA > MEMORY_ALLOCATION_DATA", "PROFILINGCHILDDATA > PROFILING_CHILD_DATA", "PROFILINGDATA > PROFILING_DATA", "SYNCAPI > SYNC_API", "SYNCDATA > SYNC_DATA", "SYNCEVENT > SYNC_EVENT", "THREADAPI > THREAD_API", "THREADDATA > THREAD_DATA", "THREADEVENT > THREAD_EVENT", "WARNINGDATA > WARNING_DATA"};
    private static final String[] create_table = new String[]{"APP_STARTUP", "GL_BUFFER_SIZE", "CHECKPOINT_VALUE", "CHECKPOINT_VARIABLE", "WEB_APP_STARTUP", "WEB_FUNCTION_ENTRY", "WEB_FUNCTION_EXIT", "WEB_PROFILING_DATA"};
    private IConvert converter = null;

    public SubConverter10to20Later(IConvert converter) {
        this.converter = converter;
    }

    public boolean convert() {
        this.converter.init();
        Set<String> tables = this.converter.getTables();
        if (!this.dropColumns(tables)) {
            return false;
        }
        if (!this.renameColumns(tables)) {
            return false;
        }
        if (!this.renameTables(tables)) {
            return false;
        }
        return this.createTables(tables);
    }

    private boolean renameTables(Set<String> tables) {
        int i = 0;
        while (i < change_table_name.length) {
            String[] tableNames = change_table_name[i].split(CHANGE_SEPERATOR);
            if (tableNames.length == 2) {
                String from = tableNames[0].trim();
                String to = tableNames[1].trim();
                if (tables.contains(from) && !this.converter.renameTable(from, to)) {
                    return false;
                }
            } else {
                Logger.error((Object)"parsing failed while converting DB (rename table)");
            }
            ++i;
        }
        return true;
    }

    private boolean renameColumns(Set<String> tables) {
        int i = 0;
        while (i < change_column_name.length) {
            String[] splitA = change_column_name[i].split(TABLENAME_SEPERATOR);
            if (splitA.length == 2) {
                String tableName = splitA[0].trim();
                String[] splitB = splitA[1].trim().split(CHANGE_SEPERATOR);
                if (splitB.length == 2) {
                    String from = splitB[0].trim();
                    String to = splitB[1].trim();
                    Set<String> columns = this.converter.getColumns(tableName);
                    if (columns != null && columns.contains(from) && !this.converter.renameColumn(tableName, from, to)) {
                        return false;
                    }
                } else {
                    Logger.error((Object)"parsing failed while converting DB (rename column)");
                }
            } else {
                Logger.error((Object)"parsing failed while converting DB (rename column)");
            }
            ++i;
        }
        return true;
    }

    private boolean dropColumns(Set<String> tables) {
        int i = 0;
        while (i < drop_column.length) {
            String[] splitA = drop_column[i].split(TABLENAME_SEPERATOR);
            if (splitA.length == 2) {
                String tableName = splitA[0].trim();
                String columnName = splitA[1].trim();
                Set<String> columns = this.converter.getColumns(tableName);
                if (columns != null && columns.contains(columnName) && !this.converter.dropColumn(tableName, columnName)) {
                    return false;
                }
            } else {
                Logger.error((Object)"parsing failed while converting DB (drop column)");
            }
            ++i;
        }
        return true;
    }

    private boolean createTables(Set<String> tables) {
        DBTableRegistry.registerEnabled(false);
        AppStartupDBTable appStartup = new AppStartupDBTable();
        GLBufferSizeDBTableManager glBufferSize = new GLBufferSizeDBTableManager();
        InteractiveValueDBTable interValue = new InteractiveValueDBTable();
        InteractiveVariableDBTable interVariable = new InteractiveVariableDBTable();
        WebAppStartupDBTable webStartup = new WebAppStartupDBTable();
        WebFunctionEntryDBTable webFuncEntry = new WebFunctionEntryDBTable();
        WebFunctionExitDBTable webFuncExit = new WebFunctionExitDBTable();
        WebProfilingDataDBTable webProfiling = new WebProfilingDataDBTable();
        DBTableRegistry.registerEnabled(true);
        if (!(tables.contains(((DBTable)appStartup).getTableName()) || appStartup.createTable() && appStartup.createIndexTable())) {
            return false;
        }
        if (!(tables.contains(((DBTable)glBufferSize).getTableName()) || glBufferSize.createTable() && glBufferSize.createIndexTable())) {
            return false;
        }
        if (!(tables.contains(((DBTable)interValue).getTableName()) || interValue.createTable() && interValue.createIndexTable())) {
            return false;
        }
        if (!(tables.contains(((DBTable)interVariable).getTableName()) || interVariable.createTable() && interVariable.createIndexTable())) {
            return false;
        }
        if (!(tables.contains(((DBTable)webStartup).getTableName()) || webStartup.createTable() && webStartup.createIndexTable())) {
            return false;
        }
        if (!(tables.contains(((DBTable)webFuncEntry).getTableName()) || webFuncEntry.createTable() && webFuncEntry.createIndexTable())) {
            return false;
        }
        if (!(tables.contains(((DBTable)webFuncExit).getTableName()) || webFuncExit.createTable() && webFuncExit.createIndexTable())) {
            return false;
        }
        return tables.contains(((DBTable)webProfiling).getTableName()) || webProfiling.createTable() && webProfiling.createIndexTable();
    }
}

