/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import java.io.File;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.explorer.ExplorerUtil;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableCellRenderer;
import org.tizen.sdblib.service.FileEntry;

public class DeviceExplorerTableRenderer
extends DATableCellRenderer {
    @Override
    public void paint(GC gc, Object value) {
        int len;
        this.textTopMargin = 8;
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        boolean drawAsSelected = this.isSelected();
        boolean drawBackground = true;
        if (this.isCellSelected()) {
            drawAsSelected = true;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.EXPLORER_SELECT_START);
            gc.setBackground(ColorResources.EXPLORER_SELECT_END);
        } else if (item.getParent().isEnabled()) {
            gc.setBackground(ColorResources.EXPLORER_CELL_BG);
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        if (drawBackground && drawAsSelected) {
            gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        } else if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y + 1, this.getBounds().width, this.getBounds().height);
        }
        int x = this.leftMargin;
        if (this.isCheck()) {
            this.checkRenderer.setChecked(item.getChecked(this.getColumn()));
            this.checkRenderer.setGrayed(item.getGrayed(this.getColumn()));
            if (!item.getParent().isEnabled()) {
                this.checkRenderer.setGrayed(true);
            }
            this.checkRenderer.setHover(this.getHoverDetail().equals("check"));
            this.checkRenderer.setBounds(this.getBounds().x + x, (this.getBounds().height - this.checkRenderer.getBounds().height) / 2 + this.getBounds().y, this.checkRenderer.getBounds().width, this.checkRenderer.getBounds().height);
            this.checkRenderer.paint(gc, null);
            x += this.checkRenderer.getBounds().width + this.insideMargin;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        String text = item.getText(this.getColumn());
        if (this.getAlignment() == 131072) {
            len = gc.stringExtent((String)text).x;
            if (len < width) {
                x += width - len;
            }
        } else if (this.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.BLACK);
        } else {
            Color fontColor = item.getForeground();
            if (fontColor != null) {
                gc.setForeground(item.getForeground());
            } else {
                gc.setForeground(ColorResources.BLACK);
            }
        }
        Image image = null;
        Object object = item.getData(ExplorerUtil.DATA_FIEL_KEY);
        if (object instanceof File) {
            File file = (File)object;
            image = file.isDirectory() ? ImageResources.FILE_TYPE_DIR : (file.isFile() ? ImageResources.FILE_TYPE_FILE : ImageResources.FILE_TYPE_ETC);
        } else if (object instanceof FileEntry) {
            FileEntry entry = (FileEntry)object;
            switch (entry.getType()) {
                case File: {
                    image = ImageResources.FILE_TYPE_FILE;
                    break;
                }
                case Link: {
                    image = ImageResources.FILE_TYPE_FILE_LINK;
                    break;
                }
                case Directory: {
                    image = ImageResources.FILE_TYPE_DIR;
                    break;
                }
                case DirectoryLink: {
                    image = ImageResources.FILE_TYPE_DIR_LINK;
                    break;
                }
                case RootEmulator: {
                    image = ImageResources.FILE_TYPE_EMULATOR;
                    break;
                }
                case RootDevice: {
                    image = ImageResources.FILE_TYPE_DEVICE;
                    break;
                }
                default: {
                    image = ImageResources.FILE_TYPE_ETC;
                }
            }
        }
        int imageTopMargin = 0;
        int imageLeftMargin = 16;
        int textLeftMargin = 66;
        Rectangle rect = this.getBounds();
        gc.drawImage(image, rect.x + imageLeftMargin, rect.y + imageTopMargin);
        gc.setFont(FontResources.getDADefaultFont());
        gc.drawText(text, rect.x + textLeftMargin, rect.y + this.textTopMargin, true);
        if (item.getParent().getLinesVisible()) {
            gc.setForeground(ColorResources.EXPLORER_CELL_LINE);
            gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width - 1, rect.y + rect.height);
        }
        if (this.isCellFocus()) {
            Rectangle focusRect = new Rectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width, this.getBounds().height + 1);
            gc.setForeground(ColorResources.RED);
            gc.drawRectangle(focusRect);
            if (this.isFocus()) {
                ++focusRect.x;
                focusRect.width -= 2;
                ++focusRect.y;
                focusRect.height -= 2;
                gc.drawRectangle(focusRect);
            }
        }
    }
}

