/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.FilePageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.file.FileApiListTable;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileSelectedData;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class FileApiListView
extends DAAdvancedViewComposite {
    private long analysisStartTime = 0L;
    private long analysisEndTime = 0L;
    private int preSelectionPId = 1;
    private long preAnalysisStartTime = 0L;
    private long preAnalysisEndTime = 0L;
    private FileSelectedData selectedData = null;
    private String[] columnNames = new String[]{FilePageLabels.FILE_API_LIST_VIEW_INDEX, FilePageLabels.FILE_API_LIST_VIEW_START_TIME, FilePageLabels.FILE_API_LIST_VIEW_ELAPSED_TIME, FilePageLabels.FILE_API_LIST_VIEW_PID, FilePageLabels.FILE_API_LIST_VIEW_THREAD_ID, FilePageLabels.FILE_API_LIST_VIEW_FD, FilePageLabels.FILE_API_LIST_VIEW_API, FilePageLabels.FILE_API_LIST_VIEW_PARAMETER, FilePageLabels.FILE_API_LIST_VIEW_RETURN, FilePageLabels.FILE_API_LIST_VIEW_ERRNO};
    private int[] columnSizes = new int[]{40, 70, 100, 40, 40, 40, 120, 250, 70, 100};
    private int[] columnAlignment = new int[]{131072, 131072, 131072, 131072, 131072, 131072, 16384, 16384, 16384, 16384};
    int[] sortTypes = new int[]{1, 2, 2, 1, 1, 1, 2, 2, 2, 2};
    FileApiListTable tableComp = null;
    FileDataManager manager = FileDataManager.getInstance();

    public FileApiListView(Composite parent, int style) {
        super(parent, style, false, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(FilePageLabels.FILE_API_LIST_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new FileApiListTable(contents, 0, 68354);
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames);
        this.tableComp.setColumnSize(this.columnSizes);
        this.tableComp.setTableName(FilePageLabels.FILE_API_LIST_VIEW_TITLE);
        this.setTable(this.tableComp);
    }

    public void updateView() {
        if (this.tableComp == null || this.selectedData == null) {
            return;
        }
        if (this.isUpdateTable()) {
            this.tableComp.updateTable();
        }
    }

    private boolean isUpdateTable() {
        boolean isUpdate = false;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPId != -1 && this.preSelectionPId != selectedPid) {
            isUpdate = true;
        }
        this.preSelectionPId = selectedPid;
        long newAnalysisStartTime = 0L;
        long newAnalysisEndTime = 0L;
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            newAnalysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
            newAnalysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
        } else {
            newAnalysisStartTime = 0L;
            newAnalysisEndTime = 0L;
        }
        if (newAnalysisStartTime != this.preAnalysisStartTime || newAnalysisEndTime != this.preAnalysisEndTime) {
            this.preAnalysisStartTime = newAnalysisStartTime;
            this.preAnalysisEndTime = newAnalysisEndTime;
            isUpdate = true;
        }
        return isUpdate;
    }

    public Control getControl() {
        return this.tableComp;
    }

    public void clear() {
        this.tableComp.getTable().removeAll();
        this.selectedData = null;
    }

    public void updateView(DAViewData data) {
        if (!(data instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)data;
        long selectionStartTime = selData.getStartTime();
        long selectionEndTime = selData.getEndTime();
        if (selData.getData() instanceof FileSelectedData) {
            this.selectedData = (FileSelectedData)selData.getData();
            if (this.selectedData == null) {
                return;
            }
            this.manager.setSelectedData(this.selectedData);
            this.tableComp.updateTable();
            this.tableComp.setSelectionByTime(selectionStartTime, selectionEndTime);
        }
    }

    public FileSelectedData getSelectedData() {
        return this.selectedData;
    }

    public long getRangeStartTime() {
        return this.analysisStartTime;
    }

    public long getRangeEndTime() {
        return this.analysisEndTime;
    }
}

