/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.swap.model.data.WebAppStartupData;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDataManager;
import org.tizen.dynamicanalyzer.ui.info.appStartup.WebAppStartupDBTable;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class WebAppStartupTable
extends DATableComposite {
    public static final int START_TIME = 3;
    public static final int END_TIME = 4;
    private int tableListIndex = 0;
    private String[] columnNames = new String[]{InformationViewLabels.APP_STARTUP_VIEW_PID, InformationViewLabels.APP_STARTUP_VIEW_RESOURCE, InformationViewLabels.APP_STARTUP_VIEW_STAGE, InformationViewLabels.APP_STARTUP_VIEW_START_TIME, InformationViewLabels.APP_STARTUP_VIEW_END_TIME, InformationViewLabels.APP_STARTUP_VIEW_ELAPSED_TIME};
    private int[] columnSizes = new int[]{40, 100, 100, 70, 70, 70};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true};
    private int[] sortTypes = new int[]{1, 2, 2, 1, 1, 1};

    public WebAppStartupTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setTableName(InformationViewLabels.APP_STARTUP_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(this.sortTypes);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AnalyzerManager.getCurrentPage().updateView(new DAViewData(TimelineTableView.tabID, null));
                GridItem[] sels = WebAppStartupTable.this.table.getSelection();
                if (sels.length > 0) {
                    WebAppStartupTable.this.table.setFocusItem(sels[0]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        this.tableListIndex = 0;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        HashMap<Integer, List<WebAppStartupTableData>> pidMap = new HashMap<Integer, List<WebAppStartupTableData>>();
        List<List<Object>> datas = AppStartupDataManager.getInstance().getWebAppStartupDBTable().getObjectDataFromDB(selectedPid);
        int rowsize = datas.size();
        int i = 0;
        while (i < rowsize) {
            List<Object> rowData = datas.get(i);
            Integer stageID = (Integer)rowData.get(WebAppStartupDBTable.COLUMN.STAGE_ID.getIndex());
            switch (stageID) {
                case 1: 
                case 3: 
                case 5: {
                    this.makeStartData(input, rowData, pidMap, stageID);
                    break;
                }
                case 2: {
                    this.makeEndData(input, rowData, pidMap, 1);
                    break;
                }
                case 4: {
                    this.makeEndData(input, rowData, pidMap, 3);
                    break;
                }
                case 6: {
                    this.makeEndData(input, rowData, pidMap, 5);
                    break;
                }
            }
            ++i;
        }
        return input;
    }

    public void setSelectionByTime(long selectionStartTime, long selectionEndTime) {
        ArrayList<Integer> selectionList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            GridItem gridItem = this.table.getItem(i);
            DATableDataFormat gridData = (DATableDataFormat)gridItem.getData();
            if (gridData != null) {
                long startTime = Long.parseLong((String)gridData.getData().get(3));
                long endTime = Long.parseLong((String)gridData.getData().get(4));
                if (selectionStartTime <= startTime && startTime <= selectionEndTime || selectionStartTime <= endTime && endTime <= selectionEndTime) {
                    selectionList.add(i);
                }
            }
            ++i;
        }
        int[] sels = new int[selectionList.size()];
        int i2 = 0;
        while (i2 < selectionList.size()) {
            sels[i2] = (Integer)selectionList.get(i2);
            ++i2;
        }
        this.table.setSelection(sels);
    }

    private void makeStartData(List<TableInput> input, List<Object> rowData, Map<Integer, List<WebAppStartupTableData>> pidMap, int stageID) {
        ArrayList<String> contentText = new ArrayList<String>();
        ArrayList<String> contentData = new ArrayList<String>();
        Integer pid = (Integer)rowData.get(WebAppStartupDBTable.COLUMN.PID.getIndex());
        contentText.add(Integer.toString(pid));
        contentData.add(Integer.toString(pid));
        Integer resourceID = (Integer)rowData.get(WebAppStartupDBTable.COLUMN.RESOURCE_ID.getIndex());
        String fileName = null;
        if (stageID == 1) {
            String resourceName = (String)rowData.get(WebAppStartupDBTable.COLUMN.RESOURCE_PATH.getIndex());
            int lastIndex = resourceName.lastIndexOf("/");
            fileName = resourceName.substring(lastIndex + 1);
            contentText.add(fileName);
            contentData.add(fileName);
        } else if (stageID == 3) {
            List<WebAppStartupTableData> tableDataList = pidMap.get(pid);
            WebAppStartupTableData startData = this.getTableData(tableDataList, 1, resourceID, false);
            if (startData != null) {
                contentText.add(startData.fileName);
                contentData.add(startData.fileName);
            } else {
                Logger.error((Object)"WSP_RES_PROC_BEGIN : load begin data does not exist. ");
            }
        } else if (stageID == 5) {
            contentText.add("-");
            contentData.add("-");
        }
        contentText.add(WebAppStartupDBTable.STAGE.getName(stageID));
        contentData.add(WebAppStartupDBTable.STAGE.getName(stageID));
        long time = (Long)rowData.get(WebAppStartupDBTable.COLUMN.TIME.getIndex());
        contentText.add(Formatter.toTimeFormat(time));
        contentData.add(Long.toString(time));
        TableInput tableInput = this.createTableData(rowData, contentText, contentData, time);
        input.add(tableInput);
        List<WebAppStartupTableData> tableDataList = pidMap.get(pid);
        if (tableDataList == null) {
            tableDataList = new ArrayList<WebAppStartupTableData>();
            pidMap.put(pid, tableDataList);
        }
        WebAppStartupTableData startData = new WebAppStartupTableData();
        startData.stageID = stageID;
        startData.startTime = time;
        startData.tableIndex = this.tableListIndex++;
        startData.resourceID = resourceID;
        startData.fileName = fileName;
        tableDataList.add(startData);
    }

    private void makeEndData(List<TableInput> input, List<Object> rowData, Map<Integer, List<WebAppStartupTableData>> pidMap, int stageID) {
        Integer pid = (Integer)rowData.get(WebAppStartupDBTable.COLUMN.PID.getIndex());
        Integer resourceID = (Integer)rowData.get(WebAppStartupDBTable.COLUMN.RESOURCE_ID.getIndex());
        List<WebAppStartupTableData> tableDataList = pidMap.get(pid);
        WebAppStartupTableData startData = this.getTableData(tableDataList, stageID, resourceID, true);
        if (startData == null) {
            Logger.error((Object)(String.valueOf(stageID) + " : data does not exist. "));
            return;
        }
        List<String> contentText = input.get(startData.tableIndex).getText();
        DATableDataFormat tableData = (DATableDataFormat)input.get(startData.tableIndex).getData();
        List<Object> contentData = tableData.getData();
        long endTime = (Long)rowData.get(WebAppStartupDBTable.COLUMN.TIME.getIndex());
        contentText.add(Formatter.toTimeFormat(endTime));
        contentData.add(Long.toString(endTime));
        contentText.add(Formatter.toTimeFormat(endTime - startData.startTime));
        contentData.add(Long.toString(endTime - startData.startTime));
    }

    private TableInput createTableData(List<Object> rowData, List<String> contentText, List<String> contentData, long time) {
        DATableDataFormat tableData = new DATableDataFormat((Long)rowData.get(WebAppStartupDBTable.COLUMN.SEQUENCE_NUMBER.getIndex()));
        tableData.setLogData(this.makeWebAppStartupData(rowData));
        tableData.getData().addAll(contentData);
        tableData.setType(512);
        TableInput tableInput = new TableInput();
        tableInput.setText(contentText);
        tableInput.setData(tableData);
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
            long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
            if (time >= analysisStartTime && time <= analysisEndTime) {
                tableInput.setInRange(true);
            }
        }
        return tableInput;
    }

    private WebAppStartupTableData getTableData(List<WebAppStartupTableData> tableDataList, int stageID, int resourceID, boolean isRemove) {
        int i = 0;
        while (i < tableDataList.size()) {
            WebAppStartupTableData tableData = tableDataList.get(i);
            if (tableData.stageID == stageID && tableData.resourceID == resourceID) {
                if (isRemove) {
                    tableDataList.remove(i);
                }
                return tableData;
            }
            ++i;
        }
        return null;
    }

    private WebAppStartupData makeWebAppStartupData(List<Object> rowData) {
        WebAppStartupData logData = new WebAppStartupData();
        logData.setSeq((Long)rowData.get(WebAppStartupDBTable.COLUMN.SEQUENCE_NUMBER.getIndex()));
        return logData;
    }

    private class WebAppStartupTableData {
        int stageID = 0;
        int resourceID = 0;
        String fileName = null;
        long startTime = 0L;
        int tableIndex = 0;

        private WebAppStartupTableData() {
        }
    }
}

