/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.tizen.dynamicanalyzer.common.DALimit;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.control.DataThread;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackDataDBTable;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnitDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.util.Logger;

public class CallStackInserter
extends DataThread<CallStackData> {
    public static final CallStackData END_OF_QUEUE = new CallStackData(-1L);
    private static final int FULL_COUNT = 5000;
    private static CallStackInserter instance = new CallStackInserter();
    private CallStackDataDBTable callStackDataTable = new CallStackDataDBTable();
    private CallStackUnitDBTable callStackUnitTable = new CallStackUnitDBTable();

    private CallStackInserter() {
    }

    public static CallStackInserter getInstance() {
        return instance;
    }

    public CallStackDataDBTable getCallStackDataTable() {
        return this.callStackDataTable;
    }

    public CallStackUnitDBTable getCallStackUnitTable() {
        return this.callStackUnitTable;
    }

    @Override
    protected String getThreadName() {
        return "Callstack inserter";
    }

    @Override
    protected boolean workAfterStart() {
        return true;
    }

    @Override
    protected boolean workAfterStopNormal() {
        return true;
    }

    @Override
    protected boolean workAfterStopForced() {
        return true;
    }

    @Override
    protected void resetBeforeStart() {
    }

    @Override
    protected void clearAfterStop() {
    }

    @Override
    public void run() {
        Thread curThread = Thread.currentThread();
        ArrayList<CallStackData> bufferList = new ArrayList<CallStackData>();
        while (this.testThread(curThread)) {
            CallStackData data = (CallStackData)this.pollData();
            if (data == null || data == END_OF_QUEUE) break;
            bufferList.add(data);
            if (bufferList.size() < 5000) continue;
            this.saveCallStackData(bufferList);
            bufferList.clear();
        }
        if (!bufferList.isEmpty() && this.testThread(curThread)) {
            this.saveCallStackData(bufferList);
            bufferList.clear();
        }
    }

    private void saveCallStackData(List<CallStackData> dataList) {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        long lastInsertSeq = -1L;
        int dataSize = dataList.size();
        int i = 0;
        while (i < dataSize) {
            CallStackData csd = dataList.get(i);
            List<Long> addrs = csd.getAddrs();
            ArrayList<Object> insertRowData = new ArrayList<Object>();
            try {
                insertRowData.add(csd.getSeq());
                insertRowData.add(addrs);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
            insertData.add(insertRowData);
            lastInsertSeq = csd.getSeq();
            ++i;
        }
        if (!insertData.isEmpty()) {
            this.callStackDataTable.insertData(insertData);
            if (!SettingDataManager.INSTANCE.getSelectedFlatFeatureSet().contains((Object)FlatFeature.MEMORY_ALLOC)) {
                if (SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.FUNCTION_SAMPLING_RATE) > 0) {
                    long lastSampleSeq = FunctionUsageProfiler.getInstance().getLastSampleSeq();
                    if (lastSampleSeq != -1L) {
                        if (lastSampleSeq <= lastInsertSeq) {
                            this.removeCallstackData(lastSampleSeq);
                        } else {
                            this.removeCallstackData(lastInsertSeq);
                        }
                    }
                } else {
                    this.removeCallstackData(lastInsertSeq);
                }
            }
        }
        List<Integer> tids = Global.getRuntimeCallstackManager().getTidsOfSeqTimeMap();
        int size = tids.size();
        int i2 = 0;
        while (i2 < size) {
            NavigableMap<Long, Long> seqByTimeMap = Global.getRuntimeCallstackManager().getSeqTimeByTidMap(tids.get(i2), false);
            if (seqByTimeMap != null && seqByTimeMap.size() > 1000000) {
                DALimit.stopTraceAndOpenWarningDialog();
            }
            ++i2;
        }
    }

    private void removeCallstackData(long seq) {
        NavigableMap<Long, CallStackData> callstackDataMap = Global.getRuntimeCallstackManager().getCallStackDataBySeqMap();
        SortedMap<Long, CallStackData> headMap = callstackDataMap.headMap(seq);
        Iterator<Map.Entry<Long, CallStackData>> itr = headMap.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }
}

